/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Optional;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="channelSetNickModule", parent=IMixComponent.class, active=true)
public class ChannelSetNickModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_SETNICK = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"setnick", (String)"urn:xmpp:mix:core:1"));
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;

    public Criteria getModuleCriteria() {
        return CRIT_SETNICK;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getStanzaTo().getLocalpart() == null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        BareJID channelJID = packet.getStanzaTo().getBareJID();
        BareJID senderJID = packet.getStanzaFrom().getBareJID();
        try {
            this.mixLogic.checkPermission(channelJID, senderJID, MixAction.publish);
            String nick = Optional.ofNullable(packet.getElement()).map(el -> el.findChild(c -> c.getName() == "setnick" && c.getXMLNS() == "urn:xmpp:mix:core:1")).map(el -> el.findChild(c -> c.getName() == "nick")).map(Element::getCData).orElseThrow(() -> new PubSubException(Authorization.NOT_ALLOWED));
            IParticipant participant = this.mixRepository.updateParticipant(channelJID, senderJID, nick);
            Element setnickEl = new Element("setnick");
            setnickEl.setXMLNS("urn:xmpp:mix:core:1");
            Element nickEl = new Element("nick", nick);
            setnickEl.addChild((XMLNodeIfc)nickEl);
            this.packetWriter.write(packet.okResult(setnickEl, 0));
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

