/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.bcstarttls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.io.CertificateContainerIfc;
import tigase.io.IOInterface;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSEventHandler;
import tigase.io.TLSIOIfc;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;
import tigase.stats.StatisticsList;

public class BcTLSIO
implements IOInterface,
TLSIOIfc {
    public static final String TLS_CAPS = "tls-caps";
    private static final Logger log = Logger.getLogger(BcTLSIO.class.getName());
    private final CertificateContainerIfc certificateContainer;
    private final TrustManager[] clientTrustManagers;
    private final BcTlsCrypto crypto;
    private final TLSEventHandler eventHandler;
    private final String hostname;
    private final boolean needClientAuth;
    private final SecureRandom random;
    private final DefaultTlsServer server;
    private final TlsServerProtocol serverProtocol;
    private final boolean wantClientAuth;
    private Certificate bcCert;
    private int bytesRead = 0;
    private boolean handshakeCompleted = false;
    private IOInterface io = null;
    private Certificate peerCertificate;
    private AsymmetricKeyParameter privateKey;
    private ByteBuffer tlsInput = null;
    private byte[] tlsUnique;
    private TLSWrapper fakeWrapper = new TLSWrapper(){

        public int bytesConsumed() {
            throw new RuntimeException("Cannot be used!");
        }

        public void close() throws SSLException {
            try {
                BcTLSIO.this.serverProtocol.close();
            }
            catch (IOException e) {
                log.log(Level.FINE, "Cannot close Server Protocol", e);
            }
        }

        public int getAppBuffSize() {
            throw new RuntimeException("Cannot be used!");
        }

        public CertCheckResult getCertificateStatus(boolean revocationEnabled, SSLContextContainerIfc sslContextContainer) {
            java.security.cert.Certificate[] chain;
            try {
                chain = this.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                return CertCheckResult.none;
            }
            if (chain == null || chain.length == 0) {
                return CertCheckResult.none;
            }
            try {
                return CertificateUtil.validateCertificate((java.security.cert.Certificate[])chain, (KeyStore)sslContextContainer.getTrustStore(), (boolean)revocationEnabled);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem validating certificate", ex);
                return CertCheckResult.invalid;
            }
        }

        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            if (BcTLSIO.this.handshakeCompleted) {
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        public java.security.cert.Certificate[] getLocalCertificates() {
            java.security.cert.Certificate[] c = BcTLSIO.this.gen(BcTLSIO.this.bcCert);
            return c;
        }

        public int getNetBuffSize() {
            throw new RuntimeException("Cannot be used!");
        }

        public int getPacketBuffSize() {
            throw new RuntimeException("Cannot be used!");
        }

        public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            if (BcTLSIO.this.peerCertificate == null) {
                return null;
            }
            java.security.cert.Certificate[] result = BcTLSIO.this.gen(BcTLSIO.this.peerCertificate);
            return result;
        }

        public TLSStatus getStatus() {
            return TLSStatus.OK;
        }

        public byte[] getTlsUniqueBindingData() {
            return BcTLSIO.this.tlsUnique;
        }

        public boolean isClientMode() {
            return false;
        }

        public boolean isNeedClientAuth() {
            return BcTLSIO.this.needClientAuth;
        }

        public void setDebugId(String id) {
            throw new RuntimeException("Cannot be used!");
        }

        public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
            throw new RuntimeException("Cannot be used!");
        }

        public boolean wantClientAuth() {
            return BcTLSIO.this.wantClientAuth;
        }

        public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
            throw new RuntimeException("Cannot be used!");
        }
    };

    public BcTLSIO(CertificateContainerIfc certificateContainer, TLSEventHandler eventHandler, IOInterface ioi, String hostname, ByteOrder order, boolean wantClientAuth, boolean needClientAuth, String[] enabledCiphers, String[] enabledProtocols, TrustManager[] x509TrustManagers) throws IOException {
        this.clientTrustManagers = x509TrustManagers;
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = needClientAuth;
        this.certificateContainer = certificateContainer;
        this.eventHandler = eventHandler;
        this.random = new SecureRandom();
        this.crypto = new BcTlsCrypto(this.random);
        this.hostname = hostname;
        this.io = ioi;
        this.tlsInput = ByteBuffer.allocate(2048);
        this.tlsInput.order(order);
        this.serverProtocol = new TlsServerProtocol();
        this.server = new TigaseTlsServer((TlsCrypto)this.crypto);
        try {
            this.loadKeys();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.serverProtocol.accept((TlsServer)this.server);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "TLS Socket created: {0}", this.io.toString());
        }
    }

    public int bytesRead() {
        return this.bytesRead;
    }

    public boolean checkCapabilities(String caps) {
        return caps.contains(TLS_CAPS) || this.io.checkCapabilities(caps);
    }

    public long getBuffOverflow(boolean reset) {
        return this.io.getBuffOverflow(reset);
    }

    public long getBytesReceived(boolean reset) {
        return this.io.getBytesReceived(reset);
    }

    public long getBytesSent(boolean reset) {
        return this.io.getBytesSent(reset);
    }

    public int getInputPacketSize() throws IOException {
        return this.io.getInputPacketSize();
    }

    public SocketChannel getSocketChannel() {
        return this.io.getSocketChannel();
    }

    public void getStatistics(StatisticsList list, boolean reset) {
        if (this.io != null) {
            this.io.getStatistics(list, reset);
        }
    }

    public long getTotalBuffOverflow() {
        return this.io.getTotalBuffOverflow();
    }

    public long getTotalBytesReceived() {
        return this.io.getTotalBytesReceived();
    }

    public long getTotalBytesSent() {
        return this.io.getTotalBytesSent();
    }

    public boolean isConnected() {
        return this.io.isConnected();
    }

    public boolean isRemoteAddress(String addr) {
        return this.io.isRemoteAddress(addr);
    }

    public ByteBuffer read(ByteBuffer buff) throws IOException {
        this.pumpData();
        this.bytesRead = this.serverProtocol.readInput(buff.array(), buff.position(), buff.remaining());
        if (this.bytesRead > 0) {
            buff.position(buff.position() + this.bytesRead);
            buff.flip();
        }
        this.pumpData();
        return buff;
    }

    public void setLogId(String logId) {
        this.io.setLogId(logId);
    }

    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called..." + this.toString());
        }
        this.io.stop();
        this.serverProtocol.close();
    }

    public String toString() {
        return "TLS: " + this.io.toString();
    }

    public boolean waitingToSend() {
        return this.io.waitingToSend();
    }

    public int waitingToSendSize() {
        return this.io.waitingToSendSize();
    }

    public int write(ByteBuffer buff) throws IOException {
        int result;
        this.pumpData();
        if (buff == null) {
            return this.io.write(null);
        }
        try {
            this.serverProtocol.writeApplicationData(buff.array(), buff.position(), buff.remaining());
            result = buff.remaining();
            buff.position(buff.position() + result);
            this.serverProtocol.flush();
            this.pumpData();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SSLException(e);
        }
        return result;
    }

    public void processHandshake(byte[] data) throws IOException {
        this.serverProtocol.offerInput(data);
        this.pumpData();
    }

    private X509Certificate[] gen(Certificate chain) {
        if (chain == null) {
            return null;
        }
        try {
            X509Certificate[] result = new X509Certificate[chain.getLength()];
            for (int i = 0; i < chain.getLength(); ++i) {
                X509Certificate cert;
                TlsCertificate c = chain.getCertificateAt(i);
                result[i] = cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(c.getEncoded()));
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Certificate gen(java.security.cert.Certificate[] certChain) throws CertificateEncodingException, IOException {
        TlsCertificate[] arr = new TlsCertificate[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            TlsCertificate cc;
            arr[i] = cc = this.crypto.createCertificate(certChain[i].getEncoded());
        }
        return new Certificate(arr);
    }

    private Certificate gen(KeyPair keypair) throws Exception {
        X500Name subject = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.hostname).build();
        byte[] id = new byte[20];
        this.random.nextBytes(id);
        BigInteger serial = new BigInteger(160, this.random);
        JcaX509v3CertificateBuilder certificate = new JcaX509v3CertificateBuilder(subject, serial, new Date(), new Date(new Date().getTime() + 600000000L), subject, keypair.getPublic());
        certificate.addExtension(Extension.subjectKeyIdentifier, false, id);
        certificate.addExtension(Extension.authorityKeyIdentifier, false, id);
        BasicConstraints constraints = new BasicConstraints(true);
        certificate.addExtension(Extension.basicConstraints, true, constraints.getEncoded());
        KeyUsage usage = new KeyUsage(132);
        certificate.addExtension(Extension.keyUsage, false, usage.getEncoded());
        ExtendedKeyUsage usageEx = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth});
        certificate.addExtension(Extension.extendedKeyUsage, false, usageEx.getEncoded());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(keypair.getPrivate());
        X509CertificateHolder holder = certificate.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        converter.setProvider((Provider)new BouncyCastleProvider());
        X509Certificate x509 = converter.getCertificate(holder);
        TlsCertificate c = this.crypto.createCertificate(holder.getEncoded());
        TlsCertificate[] arr = new TlsCertificate[]{c};
        Certificate zz = new Certificate(arr);
        return zz;
    }

    private Collection<X500Name> getAcceptedIssuers() {
        if (this.clientTrustManagers != null) {
            ArrayList<X500Name> result = new ArrayList<X500Name>();
            for (TrustManager clientTrustManager : this.clientTrustManagers) {
                X509Certificate[] iss;
                if (!(clientTrustManager instanceof X509TrustManager)) continue;
                for (X509Certificate certificate : iss = ((X509TrustManager)clientTrustManager).getAcceptedIssuers()) {
                    X500Name n = new X500Name(certificate.getSubjectDN().toString());
                    result.add(n);
                }
            }
            return result;
        }
        return null;
    }

    private byte[] getBytes(ByteBuffer buff) {
        byte[] tmp;
        if (buff != null) {
            tmp = new byte[buff.remaining()];
            buff.get(tmp);
            buff.compact();
        } else {
            tmp = null;
        }
        return tmp;
    }

    private void loadKeys() throws Exception {
        CertificateEntry kk = this.certificateContainer.getCertificateEntry(this.hostname);
        this.privateKey = PrivateKeyFactory.createKey((byte[])kk.getPrivateKey().getEncoded());
        this.bcCert = this.gen(kk.getCertChain());
    }

    private void pumpData() throws IOException {
        int resOut;
        int resIn;
        int counter = 0;
        do {
            byte[] tmp;
            ByteBuffer bb;
            int dataLen;
            ++counter;
            resOut = 0;
            int waiting = this.serverProtocol.getAvailableOutputBytes();
            if (waiting > 0 && (dataLen = this.serverProtocol.readOutput((bb = ByteBuffer.allocate(waiting)).array(), 0, bb.array().length)) > 0) {
                bb.position(resOut += dataLen);
                bb.flip();
                this.io.write(bb);
            }
            resIn = 0;
            bb = this.io.read(this.tlsInput);
            if (this.io.bytesRead() <= 0 || (tmp = this.getBytes(bb)) == null || tmp.length <= 0) continue;
            resIn += tmp.length;
            this.serverProtocol.offerInput(tmp);
        } while ((resIn > 0 || resOut > 0) && counter <= 1000);
    }

    private class TigaseTlsServer
    extends DefaultTlsServer {
        public TigaseTlsServer(TlsCrypto crypto) {
            super(crypto);
        }

        public CertificateRequest getCertificateRequest() throws IOException {
            if (!BcTLSIO.this.needClientAuth && !BcTLSIO.this.wantClientAuth) {
                return null;
            }
            short[] certificateTypes = new short[]{1, 2, 64};
            Vector serverSigAlgs = null;
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)this.serverVersion)) {
                serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms((TlsContext)this.context);
            }
            Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
            Collection<X500Name> acceptedIssuers = BcTLSIO.this.getAcceptedIssuers();
            if (acceptedIssuers != null) {
                certificateAuthorities.addAll(acceptedIssuers);
            }
            return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
        }

        public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
            BcTLSIO.this.peerCertificate = clientCertificate;
        }

        public void notifyHandshakeComplete() throws IOException {
            super.notifyHandshakeComplete();
            BcTLSIO.this.handshakeCompleted = true;
            BcTLSIO.this.tlsUnique = this.context.exportChannelBinding(1);
            try {
                if (BcTLSIO.this.eventHandler != null) {
                    BcTLSIO.this.eventHandler.handshakeCompleted(BcTLSIO.this.fakeWrapper);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log(Level.WARNING, "Cannot handle handshakeCompleted handler", e);
                throw new TlsFatalAlert(80);
            }
        }

        public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        }

        protected TlsCredentialedDecryptor getRSAEncryptionCredentials() {
            Certificate crt = BcTLSIO.this.bcCert;
            AsymmetricKeyParameter pk = BcTLSIO.this.privateKey;
            return new BcDefaultTlsCredentialedDecryptor(BcTLSIO.this.crypto, crt, pk);
        }

        protected TlsCredentialedSigner getRSASignerCredentials() {
            TlsCryptoParameters crpP = new TlsCryptoParameters((TlsContext)this.context);
            AsymmetricKeyParameter pk = BcTLSIO.this.privateKey;
            Certificate crt = BcTLSIO.this.bcCert;
            SignatureAndHashAlgorithm alg = new SignatureAndHashAlgorithm(2, 1);
            return new BcDefaultTlsCredentialedSigner(crpP, BcTLSIO.this.crypto, pk, crt, alg);
        }
    }
}

