/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Inject;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.ExtendedQuery;
import tigase.xmpp.mam.MAM2QueryParser;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;

public class MAM2ExtendedQueryParser<Query extends Query>
extends MAM2QueryParser<Query> {
    protected static final String MAM2_EXTENDED_XMLNS = "urn:xmpp:mam:2#extended";
    @Inject
    private MAMRepository mamRepository;

    public MAM2ExtendedQueryParser() {
        this(Stream.empty());
    }

    protected MAM2ExtendedQueryParser(Stream<String> additionalNamespaces) {
        super(Stream.concat(additionalNamespaces, Stream.of(MAM2_EXTENDED_XMLNS)));
    }

    @Override
    public Query parseQuery(Query query, Packet packet) throws ComponentException {
        Query result = super.parseQuery(query, packet);
        Element queryEl = packet.getElement().getChildStaticStr("query");
        if (query instanceof ExtendedQuery) {
            ExtendedQuery extQuery = (ExtendedQuery)result;
            extQuery.setBeforeId(DataForm.getFieldValue(queryEl, "before-id"));
            extQuery.setAfterId(DataForm.getFieldValue(queryEl, "after-id"));
            extQuery.setIds(Optional.ofNullable(DataForm.getFieldValues(queryEl, "ids")).map(Arrays::asList).orElseGet(Collections::emptyList));
        }
        return result;
    }

    @Override
    public Element prepareForm(Element elem, String xmlns, Packet packet) {
        JID from;
        Element form = super.prepareForm(elem, xmlns, packet);
        Element x = form.getChild("x", "jabber:x:data");
        if (x != null && xmlns == "urn:xmpp:mam:2" && (from = packet.getStanzaFrom()) != null && this.mamRepository.newQuery(from.getBareJID()) instanceof ExtendedQuery) {
            this.addField(x, "after-id", "text-single", "After item with ID");
            this.addField(x, "before-id", "text-single", "Before item with ID");
            this.addField(x, "ids", "text-multi", "Item IDs");
        }
        return form;
    }
}

