/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.cluster.strategy.ConnectionRecordIfc;
import tigase.cluster.strategy.cmd.PacketForwardCmd;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.Algorithms;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class DefaultClusteringStrategyAbstract<E extends ConnectionRecordIfc>
implements ClusteringStrategyIfc<E> {
    private static final String ERROR_FORWARDING_KEY = "error-forwarding";
    private static final Logger log = Logger.getLogger(DefaultClusteringStrategyAbstract.class.getName());
    private static final String PACKET_FORWARD_CMD = "packet-forward-sm-cmd";
    @Inject
    protected ClusterControllerIfc cluster = null;
    protected String comp = "sess-man";
    @Inject
    protected EventBus eventBus = null;
    protected String prefix = "strategy/" + this.getClass().getSimpleName() + "/";
    @Inject
    protected SessionManagerClusteredIfc sm = null;
    private JID ampJID = JID.jidInstanceNS((String)"amp", (String)DNSResolverFactory.getInstance().getDefaultHost());
    private Set<CommandListener> commands = new CopyOnWriteArraySet<CommandListener>();
    @ConfigField(desc="Forward error packets within cluster", alias="error-forwarding")
    private ErrorForwarding errorForwarding = ErrorForwarding.forward;
    private static EnumSet<StanzaType> ERROR_OR_RESULT = EnumSet.of(StanzaType.error, StanzaType.result);
    private Map<String, JID> iqResourceToClusterNode = new ConcurrentHashMap<String, JID>();

    public DefaultClusteringStrategyAbstract() {
        this.addCommandListener(new PacketForwardCmd(PACKET_FORWARD_CMD, this));
    }

    @Override
    public void statisticExecutedIn(long executionTime) {
    }

    @Override
    public void everyHour() {
    }

    @Override
    public void everyMinute() {
    }

    @Override
    public void everySecond() {
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
    }

    @Override
    public void setStatisticsPrefix(String prefix) {
        this.prefix = prefix;
    }

    public final void addCommandListener(CommandListener cmd) {
        this.commands.add(cmd);
    }

    @Override
    public boolean containsJid(BareJID jid) {
        return false;
    }

    @Override
    public boolean containsJidLocally(BareJID jid) {
        return false;
    }

    @Override
    public boolean containsJidLocally(JID jid) {
        return false;
    }

    @Override
    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalPresenceSet(XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalResourceBind(XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalUserLogin(BareJID userId, XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalUserLogout(BareJID userId, XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalUserChangedConnId(BareJID userId, XMPPResourceConnection conn, JID oldConnId, JID newConnId) {
    }

    @Override
    public boolean processPacket(Packet packet, XMPPResourceConnection conn) {
        boolean result;
        List<JID> toNodes = this.getNodesForPacketForward(this.sm.getComponentId(), null, packet);
        boolean bl = result = toNodes != null && toNodes.size() > 0;
        if (result) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Forwarding packet {0} to nodes: {1}", new Object[]{packet, toNodes});
            }
            LinkedHashMap<String, String> data = null;
            if (conn != null || packet.getPacketFrom() != null || packet.getStableId() != null) {
                data = new LinkedHashMap<String, String>();
                if (conn != null) {
                    data.put("user-session-found-key", this.sm.getComponentId().toString());
                }
                if (packet.getPacketFrom() != null) {
                    data.put("packet-from", packet.getPacketFrom().toString());
                }
                if (packet.getStableId() != null) {
                    data.put("stable-id", packet.getStableId());
                }
            }
            this.cluster.sendToNodes(PACKET_FORWARD_CMD, data, packet.getElement(), this.sm.getComponentId(), null, toNodes.toArray(new JID[toNodes.size()]));
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No cluster nodes found for packet forward: {0}", new Object[]{packet});
        }
        return result;
    }

    public boolean sendToNextNode(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Packet packet) {
        boolean result = false;
        List<JID> nextNodes = this.getNodesForPacketForward(fromNode, visitedNodes, packet);
        if (nextNodes != null && nextNodes.size() > 0) {
            this.cluster.sendToNodes(PACKET_FORWARD_CMD, data, packet.getElement(), fromNode, visitedNodes, nextNodes.toArray(new JID[nextNodes.size()]));
            result = true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for packet: {0}, visitedNodes: {1}, result: {2}", new Object[]{packet, visitedNodes, result});
        }
        return result;
    }

    public String toString() {
        return this.getInfo();
    }

    @Override
    public List<JID> getNodesConnected() {
        return this.sm.getNodesConnected();
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        return null;
    }

    @Override
    public E getConnectionRecord(JID jid) {
        return null;
    }

    @Override
    public E getConnectionRecordInstance() {
        return (E)new ConnectionRecord();
    }

    @Override
    public Set<E> getConnectionRecords(BareJID bareJID) {
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(ERROR_FORWARDING_KEY, ErrorForwarding.drop.name());
        return props;
    }

    @Override
    public String getInfo() {
        return "basic strategy";
    }

    public List<JID> getNodesForPacketForward(JID fromNode, Set<JID> visitedNodes, Packet packet) {
        if (visitedNodes != null) {
            return null;
        }
        List<JID> nodes = null;
        if (this.isSuitableForForward(packet)) {
            nodes = this.isIqResponseToNode(packet) ? this.getNodesForIqResponse(packet) : this.getNodesConnected();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Selected nodes: {0}, for packet: {1}", new Object[]{nodes, packet});
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return nodes;
    }

    public boolean isIqResponseToNode(Packet packet) {
        if (packet.getElemName() == "iq" && ERROR_OR_RESULT.contains((Object)packet.getType())) {
            JID to = packet.getStanzaTo();
            return to != null && this.sm.isLocalDomain(to.getBareJID().toString(), false) && to.getResource() != null;
        }
        return false;
    }

    public List<JID> getNodesForIqResponse(Packet packet) {
        JID clusterNode = this.iqResourceToClusterNode.get(packet.getStanzaTo().getResource());
        if (clusterNode != null) {
            return Collections.singletonList(clusterNode);
        }
        return null;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        for (CommandListener cmd : this.commands) {
            cmd.getStatistics(list);
        }
        this.getStatistics("sess-man/", list);
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return false;
    }

    @Override
    public void nodeConnected(JID node) {
        String hash = Algorithms.sha256((String)node.getDomain());
        this.iqResourceToClusterNode.put(hash, node);
    }

    @Override
    public void nodeDisconnected(JID node) {
        String hash = Algorithms.sha256((String)node.getDomain());
        this.iqResourceToClusterNode.remove(hash, node);
    }

    @Override
    public void setClusterController(ClusterControllerIfc clComp) {
        this.cluster = clComp;
        for (CommandListener cmd : this.commands) {
            this.cluster.removeCommandListener(cmd);
            this.cluster.setCommandListener(cmd);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(ERROR_FORWARDING_KEY)) {
            this.errorForwarding = ErrorForwarding.valueOf((String)props.get(ERROR_FORWARDING_KEY));
        }
    }

    public SessionManagerClusteredIfc getSM() {
        return this.sm;
    }

    public void fireEvent(Object event) {
        this.eventBus.fire(event);
    }

    protected boolean isSuitableForForward(Packet packet) {
        Element amp;
        switch (this.errorForwarding) {
            case forward: {
                break;
            }
            default: {
                if (packet.getType() != StanzaType.error) break;
                return false;
            }
        }
        if (packet.getPacketFrom() != null && this.sm.hasXMPPResourceConnectionForConnectionJid(packet.getPacketFrom())) {
            return false;
        }
        if (packet.getStanzaTo() == null || this.sm.isLocalDomain(packet.getStanzaTo().toString(), false) || this.sm.getComponentId().getBareJID().equals((Object)packet.getStanzaTo().getBareJID())) {
            return false;
        }
        if (packet.getStanzaFrom() == null || this.sm.isLocalDomain(packet.getStanzaFrom().toString(), false) || this.sm.getComponentId().getBareJID().equals((Object)packet.getStanzaFrom().getBareJID())) {
            return false;
        }
        if (!this.sm.isLocalDomain(packet.getStanzaTo().getDomain(), false)) {
            return false;
        }
        if (packet.getElemName() == "iq" && packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null) {
            return false;
        }
        return packet.getElemName() != "message" || packet.getType() == StanzaType.error || !this.ampJID.equals((Object)packet.getPacketFrom()) || (amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp")) == null || amp.getAttributeStaticStr("status") != null;
    }

    private static enum ErrorForwarding {
        forward,
        drop;

    }
}

