/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.MechanismSelector;
import tigase.auth.callbacks.CallbackHandlerFactoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.core.Kernel;
import tigase.server.xmppsession.SessionManager;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="sasl-provider", parent=SessionManager.class, active=true)
public class TigaseSaslProvider
extends Provider
implements Initializable,
UnregisterAware,
RegistrarBean {
    public static final String FACTORY_KEY = "factory";
    private static final String INFO = "This is tigase provider (provides Tigase server specific mechanisms)";
    private static final Logger log = Logger.getLogger(TigaseSaslProvider.class.getName());
    private static final String MY_NAME = "tigase.sasl";
    private static final long serialVersionUID = 1L;
    private static final double VERSION = 1.0;
    @Inject
    private CallbackHandlerFactoryIfc callbackHandlerFactory;
    @Inject
    private MechanismSelector mechanismSelector;
    @Inject(nullAllowed=true)
    private CopyOnWriteArraySet<SaslServerFactory> saslServerFactories = new CopyOnWriteArraySet();
    private ConcurrentHashMap<SaslServerFactory, List<Provider.Service>> saslServerFactoriesServices = new ConcurrentHashMap();

    public TigaseSaslProvider() {
        super(MY_NAME, 1.0, INFO);
    }

    public void setSaslServerFactories(CopyOnWriteArraySet<SaslServerFactory> saslServerFactories) {
        this.saslServerFactories.stream().filter(factory -> saslServerFactories == null || !saslServerFactories.contains(factory)).forEach(this::unregisterFactory);
        if (saslServerFactories != null) {
            saslServerFactories.stream().filter(factory -> !this.saslServerFactories.contains(factory)).forEach(this::registerFactory);
        }
        this.saslServerFactories = saslServerFactories == null ? new CopyOnWriteArraySet() : saslServerFactories;
    }

    @Override
    public void beforeUnregister() {
        Security.removeProvider(MY_NAME);
    }

    @Override
    public void initialize() {
        Security.insertProviderAt(this, 1);
    }

    public CallbackHandler create(String mechanismName, XMPPResourceConnection session, NonAuthUserRepository repo, Map<String, Object> settings) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.callbackHandlerFactory.create(mechanismName, session, repo, settings);
    }

    public Collection<String> filterMechanisms(Enumeration<SaslServerFactory> serverFactories, XMPPResourceConnection session) {
        return this.mechanismSelector.filterMechanisms(serverFactories, session);
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    protected synchronized void putService(Provider.Service s) {
        log.config("Registering SASL mechanism '" + s.getAlgorithm() + "' with factory " + s.getClassName());
        super.putService(s);
    }

    @Override
    protected synchronized void removeService(Provider.Service s) {
        log.config("Unregistering SASL mechanism '" + s.getAlgorithm() + "' with factory " + s.getClassName());
        super.removeService(s);
    }

    private void registerFactory(SaslServerFactory factory) {
        String factoryClassName = factory.getClass().getName();
        List<Provider.Service> services = Arrays.stream(factory.getMechanismNames(new HashMap())).map(name -> new Provider.Service(this, "SaslServerFactory", (String)name, factoryClassName, null, null)).collect(Collectors.toList());
        services.forEach(this::putService);
        this.saslServerFactoriesServices.put(factory, services);
    }

    private void unregisterFactory(SaslServerFactory factory) {
        List<Provider.Service> services = this.saslServerFactoriesServices.remove(factory);
        if (services != null) {
            services.forEach(this::removeService);
        }
    }
}

