/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload;

import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.Module;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.http.upload.FileTooLargeException;
import tigase.http.upload.FileUploadComponent;
import tigase.http.upload.logic.Logic;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;

@Bean(name="slotRequestModule", parent=FileUploadComponent.class, active=true)
public class SlotRequestModule
implements Module {
    private static final String XMLNS = "urn:xmpp:http:upload:0";
    private static final Criteria CRITERIA = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"request", (String)"urn:xmpp:http:upload:0"));
    private static final String[] FEATURES = new String[]{"urn:xmpp:http:upload:0"};
    @Inject
    private Logic logic;
    @Inject
    private PacketWriter packetWriter;

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRITERIA;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        String contentType;
        long size;
        String filename;
        try {
            Element request = packet.getElement().getChild("request", XMLNS);
            filename = XMLUtils.unescape((String)request.getAttributeStaticStr("filename"));
            size = Long.parseLong(request.getAttributeStaticStr("size"));
            contentType = request.getAttributeStaticStr("content-type");
        }
        catch (NullPointerException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, null, (Throwable)ex);
        }
        if (size <= 0L) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid file size");
        }
        if (size > this.logic.getMaxFileSize()) {
            throw new FileTooLargeException(this.logic.getMaxFileSize());
        }
        String slotId = this.logic.requestSlot(packet.getStanzaFrom(), filename, size, contentType);
        String uploadURI = this.logic.getUploadURI(packet.getStanzaFrom(), slotId, filename);
        String downloadURI = this.logic.getDownloadURI(packet.getStanzaFrom(), slotId, filename);
        Element slot = new Element("slot");
        slot.setXMLNS(XMLNS);
        slot.addChild((XMLNodeIfc)new Element("put", new String[]{"url"}, new String[]{XMLUtils.escape((String)uploadURI)}));
        slot.addChild((XMLNodeIfc)new Element("get", new String[]{"url"}, new String[]{XMLUtils.escape((String)downloadURI)}));
        Packet result = packet.okResult(slot, 0);
        this.packetWriter.write(result);
    }
}

