/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.security.NoSuchProviderException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cert.CertificateGenerator;

public class CertificateGeneratorFactory {
    private static final Logger log = Logger.getLogger(CertificateGeneratorFactory.class.getCanonicalName());
    private static CertificateGenerator generator;

    public static CertificateGenerator getGenerator() throws NoSuchProviderException {
        if (generator == null) {
            throw new NoSuchProviderException("Self-signed certificate generator is unavailable.");
        }
        return generator;
    }

    static {
        try {
            String generatorClassName = "tigase.cert.KeytoolCertificateGenerator";
            generator = (CertificateGenerator)Class.forName("tigase.cert.KeytoolCertificateGenerator").newInstance();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            log.log(Level.WARNING, "could not initialize self-signed SSL certificate generator", ex);
        }
    }
}

