/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.mix.IMixComponent;
import tigase.mix.Mix;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.ChannelNodePermission;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.mix.model.RoomPresenceRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.PublisherModel;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.ManageAffiliationsModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.DefaultPubSubLogic;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.BasicComponent;
import tigase.server.CmdAcl;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.util.datetime.TimestampHelper;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="logic", parent=IMixComponent.class, active=true)
public class DefaultMixLogic
extends DefaultPubSubLogic
implements MixLogic {
    private static final Logger log = Logger.getLogger(DefaultMixLogic.class.getCanonicalName());
    private static final Set<String> MIX_NODES = Mix.Nodes.ALL_NODES;
    private static final TimestampHelper timestampHelper = new TimestampHelper();
    @ConfigField(desc="ACL for creation public channels")
    private CmdAcl.Type publicChannelCreationAcl = CmdAcl.Type.DOMAIN_ADMIN;
    @ConfigField(desc="ACL for creation ad-hoc channels")
    private CmdAcl.Type adhocChannelCreationAcl = CmdAcl.Type.DOMAIN;
    @Inject
    private IMixRepository mixRepository;
    @Inject(nullAllowed=true)
    private RoomPresenceRepository roomPresenceRepository;
    @Inject(nullAllowed=true, bean="service")
    private BasicComponent component;

    public boolean isServiceAutoCreated() {
        return true;
    }

    @Override
    public String generateParticipantId(BareJID channelJID, BareJID participantRealJID) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(channelJID.getDomain().getBytes(StandardCharsets.UTF_8));
            md.update(participantRealJID.toString().getBytes(StandardCharsets.UTF_8));
            md.update(channelJID.getLocalpart().getBytes(StandardCharsets.UTF_8));
            return Algorithms.bytesToHex((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    @Override
    public String generateTempParticipantId(BareJID channelJID, JID participantRealJID) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(channelJID.getDomain().getBytes(StandardCharsets.UTF_8));
            md.update(participantRealJID.toString().getBytes(StandardCharsets.UTF_8));
            md.update(channelJID.getLocalpart().getBytes(StandardCharsets.UTF_8));
            return "temp-" + Algorithms.bytesToHex((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public void checkNodeConfig(AbstractNodeConfig nodeConfig) throws PubSubException {
        if (nodeConfig.getNodeAccessModel() != AccessModel.whitelist) {
            throw new PubSubException(Authorization.NOT_ALLOWED, "Only 'whitelist' access mode is allowed!");
        }
        if (MIX_NODES.contains(nodeConfig.getNodeName())) {
            if (nodeConfig.getSendLastPublishedItem() != SendLastPublishedItem.never) {
                throw new PubSubException(Authorization.NOT_ALLOWED, "Only 'whitelist' access mode is allowed!");
            }
            if (nodeConfig.getNodeType() != NodeType.leaf) {
                throw new PubSubException(Authorization.NOT_ALLOWED, "MIX nodes can only be leafs!");
            }
            if (nodeConfig.isDeliverPresenceBased()) {
                throw new PubSubException(Authorization.NOT_ALLOWED, "Presence based delivery is not allowed for MIX nodes!");
            }
            if (nodeConfig.isPresenceExpired()) {
                throw new PubSubException(Authorization.NOT_ALLOWED, "Presence expiring is not allowed for MIX nodes!");
            }
            if (nodeConfig.getCollection() != null && !"".equals(nodeConfig.getCollection())) {
                throw new PubSubException(Authorization.NOT_ALLOWED, "MIX nodes cannot be part of the collection!");
            }
            if (nodeConfig.getPublisherModel() != PublisherModel.publishers) {
                throw new PubSubException(Authorization.NOT_ALLOWED, "Only publishers can post to MIX nodes!");
            }
        }
        super.checkNodeConfig(nodeConfig);
    }

    private boolean checkAcl(BareJID channel, CmdAcl.Type type, BareJID jid) {
        switch (type) {
            case ALL: {
                return true;
            }
            case LOCAL: {
                return this.component.isLocalDomain(jid.getDomain());
            }
            case ADMIN: {
                return this.component.isAdmin(JID.jidInstance((BareJID)jid));
            }
            case DOMAIN: {
                String domain = channel.getDomain().substring(this.component.getName().length() + 1);
                return domain.equals(jid.getDomain());
            }
            case DOMAIN_ADMIN: {
                String domain = channel.getDomain().substring(this.component.getName().length() + 1);
                return Optional.ofNullable(this.component.getVHostItem(domain)).filter(vhost -> vhost.isAdmin(jid.toString())).isPresent() || this.component.isAdmin(JID.jidInstance((BareJID)jid));
            }
            case DOMAIN_OWNER: {
                String domain = channel.getDomain().substring(this.component.getName().length() + 1);
                return Optional.ofNullable(this.component.getVHostItem(domain)).filter(vhost -> vhost.isOwner(jid.toString())).isPresent();
            }
        }
        return false;
    }

    @Override
    public void checkPermission(BareJID channel, BareJID senderJid, MixAction action) throws PubSubException, RepositoryException {
        switch (action) {
            case manage: {
                ChannelConfiguration configuration;
                ChannelConfiguration channelConfiguration = configuration = channel.getLocalpart() == null ? null : this.mixRepository.getChannelConfiguration(channel);
                if (configuration != null) {
                    if (configuration.isOwner(senderJid)) break;
                    throw new PubSubException(Authorization.NOT_ALLOWED);
                }
                if (!(channel.getLocalpart() == null ? !this.checkAcl(channel, this.adhocChannelCreationAcl, senderJid) : !this.checkAcl(channel, this.publicChannelCreationAcl, senderJid))) break;
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            case publish: {
                if (this.mixRepository.getParticipant(channel, senderJid) != null) break;
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
            case join: {
                ChannelConfiguration configuration2 = this.mixRepository.getChannelConfiguration(channel);
                if (configuration2 != null && configuration2.isOwner(senderJid)) {
                    return;
                }
                Optional<List<BareJID>> allowed = this.mixRepository.getAllowed(channel);
                if (allowed.isPresent() && !allowed.get().contains(senderJid) && !allowed.get().contains(BareJID.bareJIDInstanceNS((String)senderJid.getDomain()))) {
                    throw new PubSubException(Authorization.NOT_ALLOWED);
                }
                Optional<List<BareJID>> banned = this.mixRepository.getBanned(channel);
                if (!banned.isPresent()) break;
                if (banned.get().contains(senderJid)) {
                    throw new PubSubException(Authorization.NOT_ALLOWED);
                }
                if (!banned.get().contains(BareJID.bareJIDInstanceNS((String)senderJid.getDomain()))) break;
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
            case relay: {
                ChannelConfiguration configuration1 = this.mixRepository.getChannelConfiguration(channel);
                if (configuration1 == null) break;
                if (!configuration1.arePrivateMessagesAllowed()) {
                    throw new PubSubException(Authorization.NOT_ALLOWED);
                }
                if (this.mixRepository.getParticipant(channel, senderJid) != null) break;
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
        }
    }

    public void checkPermission(BareJID serviceJid, String nodeName, JID senderJid, PubSubLogic.Action action) throws PubSubException, RepositoryException {
        ChannelConfiguration configuration = this.mixRepository.getChannelConfiguration(serviceJid);
        if (configuration == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (action == PubSubLogic.Action.manageNode && (nodeName == null || nodeName.isEmpty())) {
            this.checkPermission(serviceJid, senderJid.getBareJID(), MixAction.manage);
        }
        if (action == PubSubLogic.Action.retrieveItems && "urn:xmpp:mix:nodes:messages".equals(nodeName) && this.roomPresenceRepository != null && this.roomPresenceRepository.isRoomParticipant(serviceJid, senderJid)) {
            return;
        }
        super.checkPermission(serviceJid, nodeName, senderJid, action);
    }

    @Override
    public boolean isChannelCreationAllowed(BareJID channelJID, BareJID senderJID) {
        return this.checkAcl(channelJID, this.publicChannelCreationAcl, senderJID) || this.checkAcl(channelJID, this.adhocChannelCreationAcl, senderJID);
    }

    public boolean isMAMEnabled(BareJID serviceJid, String node) throws RepositoryException {
        if ("urn:xmpp:mix:nodes:messages".equals(node) || node == null) {
            return true;
        }
        return super.isMAMEnabled(serviceJid, node);
    }

    public String validateItemId(BareJID toJid, String node, String id) {
        if ("urn:xmpp:mix:nodes:info".equals(node) || "urn:xmpp:mix:nodes:config".equals(node)) {
            return timestampHelper.format(new Date());
        }
        return super.validateItemId(toJid, node, id);
    }

    @Override
    public void generateAffiliationChangesNotifications(BareJID channelJid, ChannelConfiguration oldConfig, ChannelConfiguration newConfig, Consumer<Packet> packetConsumer) {
        HashSet<BareJID> changed = new HashSet<BareJID>();
        DefaultMixLogic.xor(oldConfig.getOwners(), newConfig.getOwners(), changed::add);
        DefaultMixLogic.xor(oldConfig.getAdministrators(), newConfig.getAdministrators(), changed::add);
        if (!changed.isEmpty()) {
            try {
                String[] childNodes = this.getRepository().getRootCollection(channelJid);
                if (childNodes != null) {
                    for (String node : childNodes) {
                        this.generateAffiliationNotifications(channelJid, node, changed, packetConsumer);
                    }
                }
            }
            catch (RepositoryException ex) {
                log.log(Level.FINEST, "Could not list nodes for channel " + channelJid, ex);
            }
        }
        this.generateAffiliationChangesNotificationsForNodeUpdateRights(channelJid, newConfig, oldConfig.getInformationNodeUpdateRights(), newConfig.getInformationNodeUpdateRights(), "urn:xmpp:mix:nodes:info", packetConsumer);
        this.generateAffiliationChangesNotificationsForNodeUpdateRights(channelJid, newConfig, oldConfig.getAvatarNodesUpdateRights(), newConfig.getAvatarNodesUpdateRights(), "urn:xmpp:avatar:metadata", packetConsumer);
        this.generateAffiliationChangesNotificationsForNodeUpdateRights(channelJid, newConfig, oldConfig.getAvatarNodesUpdateRights(), newConfig.getAvatarNodesUpdateRights(), "urn:xmpp:avatar:data", packetConsumer);
    }

    protected void generateAffiliationChangesNotificationsForNodeUpdateRights(BareJID channelJID, ChannelConfiguration configuration, ChannelNodePermission oldPermission, ChannelNodePermission newPermission, String node, Consumer<Packet> packetConsumer) {
        try {
            block1 : switch (oldPermission) {
                case owners: {
                    switch (newPermission) {
                        case owners: {
                            break;
                        }
                        case admins: {
                            this.generateAffiliationNotifications(channelJID, node, configuration.getAdministrators(), packetConsumer);
                            break;
                        }
                        case participants: {
                            this.generateAffiliationNotifications(channelJID, node, this.mixRepository.getNodeSubscriptions(channelJID, node).getSubscriptions().map(UsersSubscription::getJid).filter(jid -> !configuration.isOwner((BareJID)jid)).collect(Collectors.toSet()), packetConsumer);
                            break;
                        }
                    }
                }
                case admins: {
                    switch (newPermission) {
                        case owners: {
                            this.generateAffiliationNotifications(channelJID, node, configuration.getAdministrators(), packetConsumer);
                            break;
                        }
                        case admins: {
                            break;
                        }
                        case participants: {
                            this.generateAffiliationNotifications(channelJID, node, this.mixRepository.getNodeSubscriptions(channelJID, node).getSubscriptions().map(UsersSubscription::getJid).filter(jid -> !configuration.isAdministrator((BareJID)jid)).filter(jid -> !configuration.isOwner((BareJID)jid)).collect(Collectors.toSet()), packetConsumer);
                            break;
                        }
                    }
                }
                case participants: {
                    switch (newPermission) {
                        case owners: {
                            this.generateAffiliationNotifications(channelJID, node, this.mixRepository.getNodeSubscriptions(channelJID, node).getSubscriptions().map(UsersSubscription::getJid).filter(jid -> !configuration.isOwner((BareJID)jid)).collect(Collectors.toSet()), packetConsumer);
                        }
                        case admins: {
                            this.generateAffiliationNotifications(channelJID, node, this.mixRepository.getNodeSubscriptions(channelJID, node).getSubscriptions().map(UsersSubscription::getJid).filter(jid -> !configuration.isAdministrator((BareJID)jid)).filter(jid -> !configuration.isOwner((BareJID)jid)).collect(Collectors.toSet()), packetConsumer);
                            break block1;
                        }
                    }
                }
            }
        }
        catch (RepositoryException ex) {
            log.log(Level.FINEST, "Could not load subscriptions for channel " + channelJID + " and node " + node, ex);
        }
    }

    protected void generateAffiliationNotifications(BareJID channelJID, String node, Set<BareJID> changed, Consumer<Packet> packetConsumer) {
        try {
            JID channel = JID.jidInstance((BareJID)channelJID);
            IAffiliations affiliations = this.getRepository().getNodeAffiliations(channelJID, node);
            ISubscriptions subscriptions = this.getRepository().getNodeSubscriptions(channelJID, node);
            if (affiliations != null && subscriptions != null) {
                for (BareJID jid : changed) {
                    if (subscriptions.getSubscription(jid) != Subscription.subscribed) continue;
                    UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(jid);
                    Packet notification = ManageAffiliationsModule.createAffiliationNotification((JID)channel, (JID)JID.jidInstance((BareJID)jid), (String)node, (Affiliation)affiliation.getAffiliation());
                    if (notification == null) continue;
                    packetConsumer.accept(notification);
                }
            }
        }
        catch (RepositoryException ex) {
            log.log(Level.FINEST, "Could not load affiliations for channel " + channelJID + " and node " + node, ex);
        }
    }

    private static <T> void xor(Collection<T> oldCollection, Collection<T> newCollection, Consumer<T> consumer) {
        oldCollection.stream().filter(it -> !newCollection.contains(it)).forEach(consumer);
        newCollection.stream().filter(it -> !oldCollection.contains(it)).forEach(consumer);
    }
}

