/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import tigase.annotations.TigaseDeprecated;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.xep0136.Query;
import tigase.db.DataSource;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.util.MAMUtil;
import tigase.xmpp.mam.util.Range;
import tigase.xmpp.rsm.RSM;

public abstract class AbstractMessageArchiveRepository<Q extends Query, DS extends DataSource, ADP extends AddMessageAdditionalDataProvider>
implements MessageArchiveRepository<Q, DS> {
    protected static final String[] MSG_BODY_PATH = new String[]{"message", "body"};
    protected static final String[] MSG_SUBJECT_PATH = new String[]{"message", "subject"};
    private static final SimpleDateFormat TIMESTAMP_FORMATTER1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");

    @TigaseDeprecated(removeIn="4.0.0", note="Use MAMUtil::calculateOffsetAndPosition directly", since="3.1.0")
    @Deprecated
    protected void calculateOffsetAndPosition(Q query, int count, Integer before, Integer after, Range range) {
        RSM rsm = query.getRsm();
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, (Integer)before, (Integer)after, (Range)range);
    }

    @TigaseDeprecated(removeIn="4.0.0", note="Use method with `range` parameter", since="3.1.0")
    @Deprecated
    protected void calculateOffsetAndPosition(Q query, int count, Integer before, Integer after) {
        RSM rsm = query.getRsm();
        this.calculateOffsetAndPosition(rsm, count, before, after);
    }

    @TigaseDeprecated(removeIn="4.0.0", note="Use method with `range` parameter", since="3.1.0")
    @Deprecated
    protected void calculateOffsetAndPosition(RSM rsm, int count, Integer before, Integer after) {
        int index = rsm.getIndex() == null ? 0 : rsm.getIndex();
        int limit = rsm.getMax();
        if (after != null) {
            index = after + 1;
        } else if (before != null) {
            index = before - rsm.getMax();
            if (index < 0) {
                index = 0;
                limit = before;
            }
        } else if (rsm.hasBefore() && (index = count - rsm.getMax()) < 0) {
            index = 0;
        }
        rsm.setIndex(Integer.valueOf(index));
        rsm.setMax(limit);
        rsm.setCount(Integer.valueOf(count));
    }

    protected String extractOriginId(Element msg) {
        String id;
        Element originId = msg.getChild("origin-id", "urn:xmpp:sid:0");
        if (originId != null && (id = originId.getAttributeStaticStr("id")) != null) {
            return id;
        }
        return msg.getAttributeStaticStr("id");
    }

    protected String findRefStableId(BareJID owner, BareJID buddy, String refOriginId) {
        return null;
    }

    protected void archiveMessage(BareJID owner, BareJID buddy, Date timestamp, Element msg, String stableId, Set<String> tags, ADP additionParametersProvider) {
        String stanzaId = this.extractOriginId(msg);
        if (stanzaId != null && stanzaId.length() >= 64) {
            stanzaId = null;
        }
        String refStableId = this.findRefStableId(owner, buddy, null);
        this.archiveMessage(owner, buddy, timestamp, msg, stableId, stanzaId, refStableId, tags, additionParametersProvider);
    }

    protected abstract void archiveMessage(BareJID var1, BareJID var2, Date var3, Element var4, String var5, String var6, String var7, Set<String> var8, ADP var9);

    static {
        TIMESTAMP_FORMATTER1.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static interface AddMessageAdditionalDataProvider {
    }
}

