/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDH;
import org.bouncycastle.util.BigIntegers;

public class JceTlsDHDomain
implements TlsDHDomain {
    protected JcaTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameterSpec dhDomain;

    public JceTlsDHDomain(JcaTlsCrypto jcaTlsCrypto, TlsDHConfig tlsDHConfig) {
        this.crypto = jcaTlsCrypto;
        this.dhConfig = tlsDHConfig;
        this.dhDomain = this.getParameters(tlsDHConfig);
    }

    public byte[] calculateDHAgreement(DHPublicKey dHPublicKey, DHPrivateKey dHPrivateKey) throws GeneralSecurityException {
        KeyAgreement keyAgreement = this.crypto.getHelper().createKeyAgreement("DH");
        keyAgreement.init(dHPrivateKey);
        keyAgreement.doPhase(dHPublicKey, true);
        return keyAgreement.generateSecret("TlsPremasterSecret").getEncoded();
    }

    public TlsAgreement createDH() {
        return new JceTlsDH(this);
    }

    public static BigInteger decodeParameter(byte[] byArray) throws IOException {
        return new BigInteger(1, byArray);
    }

    public DHPublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            BigInteger bigInteger = JceTlsDHDomain.decodeParameter(byArray);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("DH");
            return (DHPublicKey)keyFactory.generatePublic(new DHPublicKeySpec(bigInteger, this.dhDomain.getP(), this.dhDomain.getG()));
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    public byte[] encodeParameter(BigInteger bigInteger) throws IOException {
        return BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
    }

    public byte[] encodePublicKey(DHPublicKey dHPublicKey) throws IOException {
        return this.encodeParameter(dHPublicKey.getY());
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("DH");
            keyPairGenerator.initialize(this.getParameters(this.dhConfig), this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    public DHParameterSpec getParameters(TlsDHConfig tlsDHConfig) {
        BigInteger[] bigIntegerArray = tlsDHConfig.getExplicitPG();
        if (bigIntegerArray != null) {
            return new DHParameterSpec(bigIntegerArray[0], bigIntegerArray[1]);
        }
        throw new IllegalStateException("No DH configuration provided");
    }
}

