/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.net.IOService;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.util.StringUtilities;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOServiceListener;
import tigase.xmpp.jid.JID;

public class XMPPIOService<RefObject>
extends IOService<RefObject> {
    public static final String ACK_NAME = "ack";
    public static final String CROSS_DOMAIN_POLICY_FILE_PROP_KEY = "cross-domain-policy-file";
    public static final String CROSS_DOMAIN_POLICY_FILE_PROP_VAL = "etc/cross-domain-policy.xml";
    public static final String DOM_HANDLER = "XMPPDomBuilderHandler";
    public static final String ID_ATT = "id";
    public static final String REQ_NAME = "req";
    public static final String STREAM_CLOSING = "stream-closing";
    private static final Logger log = Logger.getLogger(XMPPIOService.class.getName());
    public ReentrantLock writeInProgress = new ReentrantLock();
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    protected XMPPIOProcessor[] processors = null;
    private XMPPDomBuilderHandler<RefObject> domHandler = null;
    private boolean firstPacket = true;
    private JID authorisedUserJid = null;
    private long lastXmppPacketReceivedTime = System.currentTimeMillis();
    private long packetsReceived = 0L;
    private long packetsSent = 0L;
    private ConcurrentLinkedQueue<Packet> receivedPackets = new ConcurrentLinkedQueue();
    private long req_idx = 0L;
    protected XMPPIOServiceListener serviceListener = null;
    private boolean strict_ack = false;
    private long totalPacketsReceived = 0L;
    private long totalPacketsSent = 0L;
    private ConcurrentSkipListMap<String, Packet> waitingForAck = new ConcurrentSkipListMap();
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private boolean white_char_ack = false;
    private String xmlns = null;
    private boolean xmpp_ack = false;

    public XMPPIOService() {
        this.domHandler = new XMPPDomBuilderHandler(this);
        this.getSessionData().put(DOM_HANDLER, this.domHandler);
    }

    public void addPacketToSend(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added packet to send: {1} [{0}]", new Object[]{this.toString(), packet});
        }
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                if (!processor.processOutgoing(this, packet)) continue;
                return;
            }
        }
        if (this.xmpp_ack) {
            String req = "" + ++this.req_idx;
            packet.getElement().addChild((XMLNodeIfc)new Element(REQ_NAME, new String[]{ID_ATT}, new String[]{req}));
            this.waitingForAck.put(req, packet);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Added req {1} for packet: {2} [{0}]", new Object[]{this.toString(), req, packet});
            }
        }
        if (this.shouldCountPacket(packet)) {
            ++this.packetsSent;
            ++this.totalPacketsSent;
        }
        this.waitingPackets.offer(packet);
    }

    @Override
    public IOService<?> call() throws IOException {
        Object io = super.call();
        if (this.isConnected() && !this.waitingPackets.isEmpty() && this.writeInProgress.tryLock()) {
            try {
                this.processWaitingPackets();
            }
            finally {
                this.writeInProgress.unlock();
            }
        }
        return io;
    }

    @Override
    public boolean checkBufferLimit(int bufferSize) {
        if (!super.checkBufferLimit(bufferSize)) {
            try {
                this.writeRawData("<stream:error><policy-violation xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>");
                int counter = 0;
                while (this.isConnected() && this.waitingToSend() && ++counter < 10) {
                    this.writeData(null);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ex) {
                log.log(Level.FINEST, "Exception sending policy-violation stream error [{0}]", new Object[]{this.toString()});
            }
            this.forceStop();
            return false;
        }
        return true;
    }

    public boolean checkData(char[] data) throws IOException {
        return false;
    }

    public void clearWaitingPackets() {
        this.waitingPackets.clear();
    }

    public Queue<Packet> getWaitingPackets() {
        return this.waitingPackets;
    }

    @Override
    public void forceStop() {
        boolean stop = false;
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                stop |= processor.serviceStopped(this, false);
            }
        }
        if (!stop) {
            super.forceStop();
        }
    }

    @Override
    public void processWaitingPackets() throws IOException {
        Packet packet = null;
        while ((packet = this.waitingPackets.peek()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending packet: {1} [{0}]", new Object[]{this.toString(), packet});
            }
            this.writeRawData(packet.getElement().toString());
            this.waitingPackets.poll();
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "SENT: {1} [{0}]", new Object[]{this.toString(), packet.getElement().toString()});
        }
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                processor.packetsSent(this);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public String toString() {
        return "jid: " + this.authorisedUserJid + ", " + super.toString();
    }

    public void writeRawData(String data) throws IOException {
        this.writeData(data);
    }

    public void xmppStreamOpen(String data) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending data: {1} [{0}]", new Object[]{this.toString(), data});
            }
            this.writeRawData(data);
            assert (this.debug(data, "--SENT:"));
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error sending stream open data: {1} [{0}]", new Object[]{this.toString(), e});
            this.forceStop();
        }
    }

    public long getPacketsReceived(boolean reset) {
        long tmp = this.packetsReceived;
        if (reset) {
            this.packetsReceived = 0L;
        }
        return tmp;
    }

    public long getPacketsSent(boolean reset) {
        long tmp = this.packetsSent;
        if (reset) {
            this.packetsSent = 0L;
        }
        return tmp;
    }

    public Queue<Packet> getReceivedPackets() {
        return this.receivedPackets;
    }

    public long getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    public long getTotalPacketsSent() {
        return this.totalPacketsSent;
    }

    public Optional<JID> getAuthorisedUserJid() {
        return Optional.ofNullable(this.authorisedUserJid);
    }

    public void setAuthorisedUserJid(JID authorisedUserJid) {
        this.authorisedUserJid = authorisedUserJid;
    }

    @Deprecated
    @TigaseDeprecated(removeIn="9.0.0", since="8.2.0", note="#getAuthorisedUserJid should be used instead")
    public String getUserJid() {
        return this.getAuthorisedUserJid().map(JID::toString).orElse(null);
    }

    @Deprecated
    @TigaseDeprecated(removeIn="9.0.0", since="8.2.0", note="#setAuthorisedUserJid should be used instead")
    public void setUserJid(String jid) {
        this.authorisedUserJid = JID.jidInstanceNS((String)jid);
    }

    public Map<String, Packet> getWaitingForAct() {
        for (Packet p : this.waitingForAck.values()) {
            Element req = p.getElement().getChild(REQ_NAME);
            if (req == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Missing req element in waiting for ACK packet: {1} [{0}]", new Object[]{this.toString(), p});
                continue;
            }
            p.getElement().removeChild(req);
        }
        return this.waitingForAck;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    public void setXMLNS(String xmlns) {
        this.xmlns = xmlns;
    }

    public void setAckMode(boolean white_char_ack, boolean xmpp_ack, boolean strict) {
        this.white_char_ack = white_char_ack;
        this.xmpp_ack = xmpp_ack;
        this.strict_ack = strict;
    }

    public void setElementLimits(int limit) {
    }

    public void setIOServiceListener(XMPPIOServiceListener servList) {
        this.serviceListener = servList;
        super.setIOServiceListener(servList);
    }

    public void setProcessors(XMPPIOProcessor[] processors) {
        this.processors = processors;
    }

    public long getLastXmppPacketReceiveTime() {
        return this.lastXmppPacketReceivedTime;
    }

    protected void addReceivedPacket(Packet packet) {
        if (this.firstPacket) {
            if ("policy-file-request" == packet.getElemName()) {
                String cross_domain_policy;
                log.log(Level.FINER, "Got flash cross-domain request" + packet);
                String string = cross_domain_policy = this.serviceListener instanceof ConnectionManager ? ((ConnectionManager)this.serviceListener).getFlashCrossDomainPolicy() : null;
                if (cross_domain_policy != null) {
                    try {
                        this.writeRawData(cross_domain_policy);
                    }
                    catch (Exception ex) {
                        log.log(Level.CONFIG, "Can't send cross-domain policy: ", ex);
                    }
                    log.log(Level.FINER, "Cross-domain policy sent: {1}", cross_domain_policy);
                } else {
                    log.log(Level.FINER, "No cross-domain policy defined to sent.");
                }
                return;
            }
            this.firstPacket = false;
        }
        if (this.processors != null) {
            boolean stop = false;
            for (XMPPIOProcessor processor : this.processors) {
                stop |= processor.processIncoming(this, packet);
            }
            if (stop) {
                return;
            }
        }
        if (packet.getElemName() == ACK_NAME) {
            String string = packet.getAttributeStaticStr(ID_ATT);
        } else {
            this.sendAck(packet);
            if (this.shouldCountPacket(packet)) {
                ++this.packetsReceived;
                ++this.totalPacketsReceived;
            }
            this.setLastXmppPacketReceiveTime();
            this.receivedPackets.offer(packet);
        }
    }

    protected boolean shouldCountPacket(Packet packet) {
        return packet.getXMLNS() != "urn:xmpp:sm:3";
    }

    protected String prepareStreamClose() {
        return "</stream:stream>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSocketData() throws IOException {
        if (this.isConnected()) {
            char[] data = this.readData();
            while (this.isConnected() && data != null && data.length > 0) {
                boolean disconnect;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "READ:{1} [{0}]", new Object[]{this.toString(), new String(data)});
                }
                if (disconnect = this.checkData(data)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "checkData says disconnect: {1} [{0}]", new Object[]{this.toString(), new String(data)});
                    } else {
                        log.log(Level.CONFIG, "checkData says disconnect [{0}]", this.toString());
                    }
                    this.forceStop();
                    return;
                }
                assert (this.debug(new String(data), "--RECEIVED:"));
                try {
                    this.parser.parse(this.domHandler, data, 0, data.length);
                    if (this.domHandler.parseError()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Data parsing error: {1} [{0}]", new Object[]{this.toString(), StringUtilities.convertNonPrintableCharactersToLiterals((String)new String(data))});
                        } else {
                            log.log(Level.CONFIG, "Data parsing error, stopping connection [{0}]", this.toString());
                        }
                        if (this.serviceListener != null) {
                            Element err = new Element("not-well-formed", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-streams"});
                            String streamErrorStr = this.serviceListener.xmppStreamError(this, Collections.singletonList(err));
                            this.writeRawData(streamErrorStr);
                        }
                        this.forceStop();
                        return;
                    }
                    this.moveParsedPacketsToReceived(true);
                }
                catch (Exception ex) {
                    log.log(Level.CONFIG, "Incorrect XML data: " + new String(data) + ", stopping connection  [" + this.toString() + "] exception: ", ex);
                    this.forceStop();
                }
                finally {
                    if (this.domHandler.isStreamClosed()) {
                        this.xmppStreamClosed();
                    }
                }
                data = this.readData();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Function called when the service is not connected! forceStop() [{0}]", this.toString());
            }
            this.forceStop();
        }
    }

    @Override
    protected int receivedPackets() {
        return this.receivedPackets.size();
    }

    protected void xmppStreamClosed() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Received STREAM-CLOSE from the client [{0}]", this.toString());
        }
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                processor.serviceStopped(this, true);
            }
        }
        try {
            if (this.isConnected()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending data: </stream:stream>, as socket is still connected [{0}]", this.toString());
                }
                this.writeRawData(this.prepareStreamClose());
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Not sending data: </stream:stream>, as socket is already closed [{0}]", this.toString());
            }
        }
        catch (IOException e) {
            log.log(Level.CONFIG, "Error sending stream closed data: {1} [{0}]", new Object[]{this.toString(), e});
        }
        if (this.serviceListener != null) {
            this.serviceListener.xmppStreamClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xmppStreamOpened(Map<String, String> attribs) {
        if (this.serviceListener != null) {
            CharSequence[] responses = this.serviceListener.xmppStreamOpened(this, attribs);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending data: {1} [{0}]", new Object[]{this.toString(), responses != null ? String.join((CharSequence)"", responses) : "null"});
                }
                if (responses == null) {
                    if (this.writeInProgress.tryLock()) {
                        try {
                            this.writeRawData(null);
                            this.processWaitingPackets();
                        }
                        finally {
                            this.writeInProgress.unlock();
                        }
                    }
                } else {
                    this.writeInProgress.lock();
                    try {
                        for (CharSequence response : responses) {
                            this.writeRawData((String)response);
                        }
                        this.processWaitingPackets();
                    }
                    finally {
                        this.writeInProgress.unlock();
                    }
                }
                if (responses != null && responses[responses.length - 1].endsWith("</stream:stream>")) {
                    this.stop();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Error sending stream open data: {1} [{0}]", new Object[]{this.toString(), e});
                this.forceStop();
            }
        }
    }

    private void sendAck(Packet packet) {
        if (this.white_char_ack || this.xmpp_ack) {
            Element req;
            Object ack = null;
            if (this.white_char_ack) {
                ack = " ";
            }
            if (this.xmpp_ack && (req = packet.getElement().getChild(REQ_NAME)) != null) {
                packet.getElement().removeChild(req);
                String req_val = req.getAttributeStaticStr(ID_ATT);
                if (req_val != null) {
                    ack = "<ack id=\"" + req_val + "\"/>";
                }
            }
            if (ack != null) {
                try {
                    this.writeRawData((String)ack);
                    log.log(Level.FINEST, "Sent ack confirmation: '" + (String)ack + "'");
                }
                catch (Exception ex) {
                    this.forceStop();
                    log.log(Level.FINE, "Can't send ack confirmation: '" + (String)ack + "'", ex);
                }
            }
        }
    }

    protected boolean hasParsedElements() {
        return !this.domHandler.getParsedElements().isEmpty();
    }

    protected void moveParsedPacketsToReceived(boolean sendAck) {
        Element elem = null;
        Queue<Element> elems = this.domHandler.getParsedElements();
        if (elems.size() > 0 && sendAck) {
            this.readCompleted();
        }
        while ((elem = elems.poll()) != null) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Read packet: {1} [{0}]", new Object[]{this.toString(), elem});
                }
                Packet pack = Packet.packetInstance(elem);
                this.addReceivedPacket(pack);
                if (!sendAck) continue;
                this.sendAck(pack);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.CONFIG, "Incorrect to/from JID format for stanza: " + elem.toString() + " [" + this.toString() + "]", ex);
            }
        }
    }

    private void setLastXmppPacketReceiveTime() {
        this.lastXmppPacketReceivedTime = System.currentTimeMillis();
    }
}

