/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.common;

import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimerTask
implements Runnable {
    private static final Logger log = Logger.getLogger(TimerTask.class.getName());
    private boolean cancelled = false;
    private ScheduledFuture<?> future = null;

    public void setScheduledFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public boolean isScheduled() {
        return this.future != null && !this.future.isCancelled() && !this.future.isDone();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancel(false);
    }

    public void cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        if (this.future != null && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Cancelling tigase task, mayInterruptIfRunning: {0}, done: {1}, cancelled: {2}, future: {3}", new Object[]{mayInterruptIfRunning, this.future.isDone(), this.future.isCancelled(), this.future});
        }
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(mayInterruptIfRunning);
        }
    }

    public void reset(boolean mayInterruptIfRunning) {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(mayInterruptIfRunning);
        }
        this.future = null;
    }
}

