/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.S2SConnection;
import tigase.xmpp.XMPPIOService;

public class S2SIOService
extends XMPPIOService<Object> {
    public static final String S2S_CONNECTION_KEY = "s2s-connection-key";
    public static final String HANDSHAKING_DOMAIN_KEY = "handshaking-domain-key";
    protected static final String HANDSHAKING_ONLY_KEY = "handshaking-only-key";
    private static final Logger log = Logger.getLogger(S2SIOService.class.getName());
    private Set<CID> authenticatedCIDsOUT = new CopyOnWriteArraySet<CID>();
    private Set<CID> authenticatedCIDsIN = new CopyOnWriteArraySet<CID>();
    private boolean streamNegotiationCompleted = false;
    private CIDConnections cid_conns = null;
    private String dbKey = null;
    private S2SConnection s2s_conn = null;
    private String session_id = null;

    public void addCID(CID cid) {
        this.addCID(cid, DIRECTION.BOTH);
    }

    public void addCID(CID cid, DIRECTION direction) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding CID to authenticated: {1} [{0}]", new Object[]{this, cid});
        }
        switch (direction) {
            case IN: {
                this.authenticatedCIDsIN.add(cid);
                break;
            }
            case OUT: {
                this.authenticatedCIDsOUT.add(cid);
                break;
            }
            default: {
                this.authenticatedCIDsIN.add(cid);
                this.authenticatedCIDsOUT.add(cid);
            }
        }
    }

    public Set<CID> getCIDs() {
        CopyOnWriteArraySet<CID> cids = new CopyOnWriteArraySet<CID>();
        cids.addAll(this.authenticatedCIDsIN);
        cids.retainAll(this.authenticatedCIDsOUT);
        return cids;
    }

    public S2SConnection getS2SConnection() {
        return this.s2s_conn;
    }

    public void setS2SConnection(S2SConnection s2s_conn) {
        this.s2s_conn = s2s_conn;
    }

    public String getSessionId() {
        return this.session_id;
    }

    public void setSessionId(String session_id) {
        this.session_id = session_id;
    }

    public boolean isAuthenticated(CID cid) {
        return this.authenticatedCIDsOUT.contains(cid) && this.authenticatedCIDsIN.contains(cid);
    }

    public boolean isAuthenticated() {
        return this.authenticatedCIDsOUT.size() > 0 && this.authenticatedCIDsIN.size() > 0;
    }

    public boolean isHandshakingOnly() {
        return this.getSessionData().get(HANDSHAKING_ONLY_KEY) != null;
    }

    public boolean isStreamNegotiationCompleted() {
        return this.streamNegotiationCompleted;
    }

    public void streamNegotiationCompleted() {
        log.log(Level.FINEST, "Marking the service as negotiated: " + this);
        this.streamNegotiationCompleted = true;
    }

    public void setDBKey(String key) {
        this.dbKey = key;
    }

    @Override
    public String toString() {
        CID cid = (CID)this.getSessionData().get("cid");
        return "CID: " + cid + ", IN: " + this.authenticatedCIDsIN.size() + ", OUT: " + this.authenticatedCIDsOUT.size() + ", authenticated: " + this.isAuthenticated() + ", remote-session-id: " + this.getSessionId() + ", streamNegotiationCompleted: " + this.streamNegotiationCompleted + ", " + super.toString();
    }

    static enum DIRECTION {
        IN,
        OUT,
        BOTH,
        ANY;

    }
}

