/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterConnectionManager;
import tigase.cluster.repo.ClusterRepoItem;
import tigase.cluster.repo.ClusterRepoItemEvent;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourceHelper;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.core.Kernel;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHostDualIPSQLRepository;
import tigase.server.xmppclient.SeeOtherHostHashed;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="seeOtherHost", parent=ClientConnectionManager.class, active=true)
@ClusterModeRequired(active=true)
public class SeeOtherHostDualIP
extends SeeOtherHostHashed
implements Initializable,
RegistrarBean,
UnregisterAware {
    public static final String SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY = "cm-see-other-host/fallback-redirection-host";
    public static final String SEE_OTHER_HOST_DATA_SOURCE_KEY = "cm-see-other-host/data-source";
    public static final String SEE_OTHER_HOST_DATA_SOURCE_VALUE = SeeOtherHostDualIPSQLRepository.class.getName();
    public static final String SEE_OTHER_HOST_DB_URL_KEY = "cm-see-other-host/db-url";
    private static final Logger log = Logger.getLogger(SeeOtherHostDualIP.class.getName());
    private final Map<BareJID, BareJID> redirectsMap = Collections.synchronizedMap(new HashMap());
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Failback host", alias="failbackHost")
    private BareJID fallback_host = null;
    @Inject(bean="dualIPRepository")
    private DualIPRepository repo = null;

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        BareJID see_other_host = super.findHostForJID(jid, host);
        BareJID redirection = this.redirectsMap.get(see_other_host);
        if (redirection == null) {
            this.reloadRedirection();
            redirection = this.redirectsMap.get(see_other_host);
        }
        if (redirection == null && this.fallback_host != null) {
            redirection = this.fallback_host;
        }
        return redirection;
    }

    @HandleEvent
    public void clusterRepoItemEvent(ClusterRepoItemEvent event) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Procesing ClusterRepoItemEvent: {0}", new Object[]{event});
        }
        if (event.getItem() == null || event.getAction() == null) {
            return;
        }
        ClusterConnectionManager.REPO_ITEM_UPDATE_TYPE action = event.getAction();
        ClusterRepoItem item = event.getItem();
        String hostnameStr = item.getHostname();
        if (null == hostnameStr) {
            return;
        }
        BareJID hostname = BareJID.bareJIDInstanceNS((String)hostnameStr);
        BareJID secondary = null;
        String secondaryStr = item.getSecondaryHostname();
        if (null != secondaryStr && !secondaryStr.trim().isEmpty()) {
            secondary = BareJID.bareJIDInstanceNS((String)secondaryStr);
        }
        switch (action) {
            case ADDED: 
            case UPDATED: {
                BareJID oldItem = this.redirectsMap.put(hostname, secondary);
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Redirection item :: hostname: {0}, secondary: {1}, added/updated! Replaced: {2}", new Object[]{hostname, secondary, oldItem});
                break;
            }
            case REMOVED: {
                BareJID oldItem = this.redirectsMap.remove(hostname);
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Redirection item :: hostname: {0}, {1}", new Object[]{hostname, oldItem != null ? "removed" : "was not present in redirection map"});
            }
        }
    }

    @Override
    public void setNodes(List<JID> connectedNodes) {
        super.setNodes(connectedNodes);
        this.reloadRedirection();
    }

    @Override
    public boolean isRedirectionRequired(BareJID defaultHost, BareJID redirectionHost) {
        return this.redirectsMap.get(defaultHost) != null ? !this.redirectsMap.get(defaultHost).equals((Object)redirectionHost) : false;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerAll(this);
        this.reloadRedirection();
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    protected void reloadRedirection() {
        if (null == this.repo) {
            return;
        }
        try {
            Map<BareJID, BareJID> queryAllDB = this.repo.queryAllDB();
            if (null != queryAllDB) {
                this.redirectsMap.clear();
                this.redirectsMap.putAll(queryAllDB);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reloaded redirection items: " + Arrays.asList(this.redirectsMap));
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Reloading redirection items failed: ", ex);
        }
    }

    public static interface DualIPRepository<T extends DataSource>
    extends DataSourceAware<T> {
        public static final String HOSTNAME_ID = "hostname";
        public static final String SECONDARY_HOSTNAME_ID = "secondary";

        public Map<BareJID, BareJID> queryAllDB() throws SQLException;
    }

    @Bean(name="dualIPRepository", parent=SeeOtherHostDualIP.class, active=true)
    public static class DualIPRepositoryWrapper
    extends MDRepositoryBeanWithStatistics<DualIPRepository>
    implements DualIPRepository<DataSource> {
        public DualIPRepositoryWrapper() {
            super(DualIPRepository.class);
        }

        @Override
        public Map<BareJID, BareJID> queryAllDB() throws SQLException {
            return ((DualIPRepository)this.getRepository("")).queryAllDB();
        }

        @Override
        public void setDataSource(DataSource dataSource) {
        }

        @Override
        public Class<?> getDefaultBeanClass() {
            return DualIPRepositoryWrapperConfigBean.class;
        }

        @Override
        protected Class<? extends DualIPRepository> findClassForDataSource(DataSource dataSource) throws DBInitException {
            return DataSourceHelper.getDefaultClass(DualIPRepository.class, dataSource.getResourceUri());
        }

        public static class DualIPRepositoryWrapperConfigBean
        extends MDRepositoryBean.MDRepositoryConfigBean<DualIPRepository> {
        }
    }
}

