/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.server.BasicComponent;
import tigase.server.Packet;
import tigase.server.xmppclient.ClientConnectionManager;

@Bean(name="stanza-source-checker", parent=Kernel.class, active=true, exportable=true)
public class StanzaSourceChecker {
    @Inject(nullAllowed=true)
    private Set<ClientConnectionManager> clientConnectionManagers;
    private Set<String> clientConnectionManagersIds = new HashSet<String>(3);

    public void setClientConnectionManagers(Set<ClientConnectionManager> clientConnectionManagers) {
        this.clientConnectionManagers = clientConnectionManagers;
        if (clientConnectionManagers != null) {
            this.clientConnectionManagersIds = clientConnectionManagers.stream().map(BasicComponent::getName).collect(Collectors.toSet());
        }
    }

    public boolean isPacketFromConnectionManager(Packet packet) {
        return packet.getPacketFrom() != null && packet.getPacketFrom().getLocalpart() != null && this.clientConnectionManagersIds.contains(packet.getPacketFrom().getLocalpart());
    }
}

