/*
 * Decompiled with CFR 0.152.
 */
package tigase.stun;

import java.awt.image.Kernel;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.stun.StatisticsCollector;
import tigase.stun.StunServerReceiverThread;
import tigase.stun.StunSocket;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

@Bean(name="stun", parent=Kernel.class, active=false)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
public class StunComponent
extends AbstractMessageReceiver
implements Configurable,
StatisticsCollector {
    private static final Logger log = Logger.getLogger(StunComponent.class.getCanonicalName());
    private static final String PRIMARY_EXTERNAL_IP_KEY = "stun-primary-external-ip";
    private static final String PRIMARY_EXTERNAL_PORT_KEY = "stun-primary-external-port";
    private static final String PRIMARY_IP_KEY = "stun-primary-ip";
    private static final String PRIMARY_PORT_KEY = "stun-primary-port";
    private static final String SECONDARY_EXTERNAL_IP_KEY = "stun-secondary-external-ip";
    private static final String SECONDARY_EXTERNAL_PORT_KEY = "stun-secondary-external-port";
    private static final String SECONDARY_IP_KEY = "stun-secondary-ip";
    private static final String SECONDARY_PORT_KEY = "stun-secondary-port";
    private static final String STUN_DISCO_DESCRIPTION = "STUN Component";
    private long last_hour_packets = 0L;
    private long last_minute_packets = 0L;
    private long last_second_packets = 0L;
    private long packets_per_hour = 0L;
    private long packets_per_minute = 0L;
    private long packets_per_second = 0L;
    private long packets_received = 0L;
    private Vector<StunSocket> sockets = null;
    private List<StunServerReceiverThread> threads = null;

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        this.deinit();
        try {
            this.init(props);
        }
        catch (UnknownHostException e) {
            log.warning(e.getMessage());
        }
        catch (SocketException e) {
            log.warning(e.getMessage());
        }
    }

    public void deinit() {
        if (this.threads != null) {
            for (StunServerReceiverThread stunServerReceiverThread : this.threads) {
                stunServerReceiverThread.shutdown();
            }
            this.threads.clear();
        }
        if (this.sockets != null) {
            for (DatagramSocket datagramSocket : this.sockets) {
                datagramSocket.close();
            }
            this.sockets.clear();
        }
    }

    public void init(Map<String, Object> props) throws UnknownHostException, SocketException {
        if (this.threads == null) {
            this.threads = new LinkedList<StunServerReceiverThread>();
        }
        if (this.sockets == null) {
            this.sockets = new Vector();
        }
        InetAddress primaryAddress = InetAddress.getByName((String)props.get(PRIMARY_IP_KEY));
        int primaryPort = (Integer)props.get(PRIMARY_PORT_KEY);
        InetAddress secondaryAddress = InetAddress.getByName((String)props.get(SECONDARY_IP_KEY));
        int secondaryPort = (Integer)props.get(SECONDARY_PORT_KEY);
        InetAddress primaryExternalAddress = primaryAddress;
        int primaryExternalPort = primaryPort;
        InetAddress secondaryExternalAddress = secondaryAddress;
        int secondaryExternalPort = secondaryPort;
        if (props.containsKey(PRIMARY_EXTERNAL_IP_KEY)) {
            primaryExternalAddress = InetAddress.getByName((String)props.get(PRIMARY_EXTERNAL_IP_KEY));
        }
        if (props.containsKey(PRIMARY_EXTERNAL_PORT_KEY)) {
            primaryExternalPort = (Integer)props.get(PRIMARY_EXTERNAL_PORT_KEY);
        }
        if (props.containsKey(SECONDARY_EXTERNAL_IP_KEY)) {
            secondaryExternalAddress = InetAddress.getByName((String)props.get(SECONDARY_EXTERNAL_IP_KEY));
        }
        if (props.containsKey(SECONDARY_EXTERNAL_PORT_KEY)) {
            secondaryExternalPort = (Integer)props.get(SECONDARY_EXTERNAL_PORT_KEY);
        }
        this.sockets.add(new StunSocket(primaryPort, primaryAddress, primaryExternalPort, primaryExternalAddress));
        this.sockets.add(new StunSocket(secondaryPort, primaryAddress, secondaryExternalPort, primaryExternalAddress));
        this.sockets.add(new StunSocket(primaryPort, secondaryAddress, primaryExternalPort, secondaryExternalAddress));
        this.sockets.add(new StunSocket(secondaryPort, secondaryAddress, secondaryExternalPort, secondaryExternalAddress));
        for (StunSocket socket : this.sockets) {
            socket.setReceiveBufferSize(2000);
            StunServerReceiverThread ssrt = new StunServerReceiverThread(socket, this.sockets, this);
            this.threads.add(ssrt);
            ssrt.start();
        }
    }

    public String getDiscoDescription() {
        return STUN_DISCO_DESCRIPTION;
    }

    public void processPacket(Packet packet) {
        try {
            this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, false));
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.WARNING, "bad packet type to return error = {0}", packet);
        }
    }

    public synchronized void everyHour() {
        this.packets_per_hour = this.packets_received - this.last_hour_packets;
        this.last_hour_packets = this.packets_received;
        super.everyHour();
    }

    public synchronized void everyMinute() {
        this.packets_per_minute = this.packets_received - this.last_minute_packets;
        this.last_minute_packets = this.packets_received;
        super.everyMinute();
    }

    public synchronized void everySecond() {
        this.packets_per_second = this.packets_received - this.last_second_packets;
        this.last_second_packets = this.packets_received;
        super.everySecond();
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Total STUN packets", this.packets_received, Level.FINE);
        list.add(this.getName(), "Last second STUN packets", this.packets_per_second, Level.FINE);
        list.add(this.getName(), "Last minute STUNB packets", this.packets_per_minute, Level.FINE);
        list.add(this.getName(), "Last hour STUN packets", this.packets_per_hour, Level.FINE);
    }

    @Override
    public void packetReceived() {
        ++this.packets_received;
    }
}

