/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.cluster.strategy.cmd;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.server.cluster.strategy.cmd.TrafficSyncCmdAbstract;
import tigase.xml.Element;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.JID;

public class RequestSyncOnlineCmd
extends TrafficSyncCmdAbstract {
    private static final Logger a = Logger.getLogger(RequestSyncOnlineCmd.class.getName());

    public RequestSyncOnlineCmd(String name, OnlineUsersCachingStrategy strat) {
        super(name, strat);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        this.incSyncInTraffic();
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (XMPPResourceConnection xMPPResourceConnection : this.getStrategy().getSM().getXMPPResourceConnections().values()) {
            try {
                if (!xMPPResourceConnection.isResourceSet()) continue;
                ConnectionRecordExt connectionRecordExt = this.getStrategy().getConnectionRecordInstance();
                connectionRecordExt.setRecordFields(this.getStrategy().getSM().getComponentId(), xMPPResourceConnection.getJID(), xMPPResourceConnection.getSessionId(), xMPPResourceConnection.getConnectionId());
                linkedList.add(connectionRecordExt.toElement());
                if (linkedList.size() <= 1000) continue;
                this.incSyncOutTraffic();
                this.getStrategy().getCluster().sendToNodes("resp-sync-online-sm-cmd", linkedList, this.getStrategy().getSM().getComponentId(), null, new JID[]{fromNode});
                linkedList = new LinkedList();
            }
            catch (NoConnectionIdException | NotAuthorizedException throwable) {}
        }
        if (linkedList.size() > 0) {
            this.incSyncOutTraffic();
            this.getStrategy().getCluster().sendToNodes("resp-sync-online-sm-cmd", linkedList, this.getStrategy().getSM().getComponentId(), null, new JID[]{fromNode});
        } else {
            this.getStrategy().getCluster().sendToNodes("resp-sync-online-sm-cmd", this.getStrategy().getSM().getComponentId(), new JID[]{fromNode});
        }
    }
}

