/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.meet.jingle.Action;
import tigase.meet.jingle.Content;
import tigase.meet.jingle.ContentAction;
import tigase.meet.jingle.Description;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class SDP {
    private final String a;
    private final List<Content> b;
    private final List<String> c;

    public static SDP from(Element jingleEl) {
        List<Content> list = Optional.ofNullable(jingleEl.getChildren()).orElse(Collections.emptyList()).stream().map(Content::from).filter(Objects::nonNull).collect(Collectors.toList());
        List list2 = Optional.ofNullable(jingleEl.getChild("group", "urn:xmpp:jingle:apps:grouping:0")).map(element -> element.getChildren()).orElse(Collections.EMPTY_LIST);
        List<String> list3 = list2.stream().filter(element -> "content".equals(element.getName())).map(element -> element.getAttributeStaticStr("name")).filter(Objects::nonNull).collect(Collectors.toList());
        return new SDP(String.valueOf(new Date().getTime()), list, list3);
    }

    public static SDP from(String sdp, Function<String, Content.Creator> creatorProvider, Content.Creator localRole) {
        String[] stringArray2 = sdp.substring(0, sdp.length() - 2).split("\r\nm=");
        List list = Arrays.stream(stringArray2).skip(1L).map(string -> "m=" + string).collect(Collectors.toList());
        String[] stringArray3 = stringArray2[0].split("\r\n");
        Optional<String[]> optional = Arrays.stream(stringArray3).filter(string -> string.startsWith("o=")).findFirst().map(string -> string.split(" "));
        if (optional.isEmpty() || optional.get().length <= 3) {
            return null;
        }
        String string2 = optional.get()[1];
        String string3 = optional.get()[2];
        Optional<String[]> optional2 = Arrays.stream(stringArray3).filter(string -> string.startsWith("a=group:BUNDLE ")).findFirst().map(string -> string.split(" "));
        List<String> list2 = optional2.filter(stringArray -> "a=group:BUNDLE".equals(stringArray[0])).map(stringArray -> Arrays.stream(stringArray).skip(1L).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<Content> list3 = list.stream().map(string -> Content.from(string, stringArray3, creatorProvider, localRole)).filter(Objects::nonNull).collect(Collectors.toList());
        return new SDP(string3, list3, list2);
    }

    public SDP(String id, List<Content> contents, List<String> bundle) {
        this.a = id;
        this.b = contents;
        this.c = bundle;
    }

    public String getId() {
        return this.a;
    }

    public List<Content> getContents() {
        return this.b;
    }

    public List<String> getBundle() {
        return this.c;
    }

    public Element toElement(Action action, String sessionId, JID from) {
        Element element2 = new Element("jingle");
        element2.setAttribute("xmlns", "urn:xmpp:jingle:1");
        element2.setAttribute("action", action.getValue());
        element2.setAttribute("sid", sessionId);
        switch (action) {
            case sessionInitiate: {
                element2.setAttribute("initiator", from.toString());
                break;
            }
            case sessionAccept: {
                element2.setAttribute("responder", from.toString());
                break;
            }
        }
        this.b.stream().map(Content::toElement).forEach(arg_0 -> ((Element)element2).addChild(arg_0));
        if (!this.c.isEmpty()) {
            element2.withElement("group", "urn:xmpp:jingle:apps:grouping:0", element -> {
                element.setAttribute("semantics", "BUNDLE");
                this.c.stream().map(string -> new Element("content", new String[]{"name"}, new String[]{string})).forEach(arg_0 -> ((Element)element).addChild(arg_0));
            });
        }
        return element2;
    }

    public String toString(String sid, Content.Creator localRole, Direction direction) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("v=0");
        arrayList.add("o=- " + sid + " " + this.a + " IN IP4 0.0.0.0");
        arrayList.add("s=-");
        arrayList.add("t=0 0");
        if (!this.c.isEmpty()) {
            arrayList.add("a=group:BUNDLE " + this.c.stream().collect(Collectors.joining(" ")));
        }
        this.b.stream().map(content -> content.toSDP(localRole, direction)).forEach(arrayList::add);
        return arrayList.stream().collect(Collectors.joining("\r\n")) + "\r\n";
    }

    public SDP applyDiff(ContentAction action, SDP diff) {
        switch (action) {
            case accept: 
            case add: {
                return new SDP(this.a, Stream.concat(this.getContents().stream(), diff.getContents().stream()).collect(Collectors.toList()), diff.getBundle());
            }
            case init: {
                return diff;
            }
            case modify: {
                Content[] contentArray = this.getContents().toArray(new Content[this.getContents().size()]);
                for (Content content2 : diff.getContents()) {
                    for (int i = 0; i < contentArray.length; ++i) {
                        if (!contentArray[i].getName().equals(content2.getName())) continue;
                        contentArray[i] = contentArray[i].withSenders(content2.getSenders()).withSSRCs(content2.getDescription().map(Description::getSsrcs).orElse(Collections.emptyList()), content2.getDescription().map(Description::getSsrcGroups).orElse(Collections.emptyList()));
                    }
                }
                return new SDP(this.a, new ArrayList<Content>(Arrays.asList(contentArray)), this.getBundle());
            }
            case remove: {
                Set set = diff.getContents().stream().map(Content::getName).collect(Collectors.toSet());
                return new SDP(this.a, this.getContents().stream().filter(content -> !set.contains(content.getName())).collect(Collectors.toList()), diff.getBundle());
            }
        }
        throw new UnsupportedOperationException("Unsupported content action: " + action.name());
    }

    public Map<ContentAction, SDP> diffFrom(SDP oldSdp) {
        List<Content> list;
        Object object;
        HashMap<ContentAction, SDP> hashMap = new HashMap<ContentAction, SDP>();
        List list2 = oldSdp.getContents().stream().map(Content::getName).collect(Collectors.toList());
        List list3 = this.getContents().stream().map(Content::getName).collect(Collectors.toList());
        List list4 = oldSdp.getContents().stream().filter(content -> !list3.contains(content.getName())).collect(Collectors.toList());
        if (!list4.isEmpty()) {
            object = new SDP(this.a, list4.stream().map(Content::cloneHeaderOnly).collect(Collectors.toList()), this.getBundle());
            hashMap.put(ContentAction.remove, (SDP)object);
        }
        if (!(object = this.getContents().stream().filter(content -> !list2.contains(content.getName())).collect(Collectors.toList())).isEmpty()) {
            hashMap.put(ContentAction.add, new SDP(this.a, (List<Content>)object, this.getBundle()));
        }
        if (!(list = this.getContents().stream().filter(content -> oldSdp.getContents().stream().filter(content2 -> content.getName().equals(content2.getName())).filter(content2 -> content.getSenders() != content2.getSenders()).findFirst().isPresent()).map(Content::cloneForModify).collect(Collectors.toList())).isEmpty()) {
            hashMap.put(ContentAction.modify, new SDP(this.a, list, Collections.emptyList()));
        }
        return hashMap;
    }

    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction incoming = new Direction();
        public static final /* enum */ Direction outgoing = new Direction();
        private static final /* synthetic */ Direction[] a;

        public static Direction[] values() {
            return (Direction[])a.clone();
        }

        public static Direction valueOf(String name) {
            return Enum.valueOf(Direction.class, name);
        }

        private static /* synthetic */ Direction[] a() {
            return new Direction[]{incoming, outgoing};
        }

        static {
            a = Direction.a();
        }
    }
}

