/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.xml.Element;

public class Payload {
    private final int a;
    private final int b;
    private final Optional<Integer> c;
    private final Optional<Integer> d;
    private final Optional<String> e;
    private final Optional<Integer> f;
    private final List<Parameter> g;
    private final List<RtcpFeedback> h;

    public static Payload from(Element el) {
        if ("payload-type".equals(el.getName())) {
            String string = el.getAttributeStaticStr("id");
            if (string == null) {
                return null;
            }
            String string2 = el.getAttributeStaticStr("channels");
            Optional<Integer> optional = Optional.ofNullable(el.getAttributeStaticStr("clockrate")).map(Integer::parseInt);
            Optional<Integer> optional2 = Optional.ofNullable(el.getAttributeStaticStr("ptime")).map(Integer::parseInt);
            Optional<Integer> optional3 = Optional.ofNullable(el.getAttributeStaticStr("maxptime")).map(Integer::parseInt);
            Optional<String> optional4 = Optional.ofNullable(el.getAttributeStaticStr("name"));
            List<Parameter> list = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().map(Parameter::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<RtcpFeedback> list2 = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().map(RtcpFeedback::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Payload(Integer.parseInt(string), string2 == null ? 1 : Integer.parseInt(string2), optional, optional3, optional4, optional2, list, list2);
        }
        return null;
    }

    public Payload(int id, int channels, Optional<Integer> clockrate, Optional<Integer> maxptime, Optional<String> name, Optional<Integer> ptime, List<Parameter> parameters, List<RtcpFeedback> rtcpFeedbacks) {
        this.a = id;
        this.b = channels;
        this.c = clockrate;
        this.d = maxptime;
        this.e = name;
        this.f = ptime;
        this.g = parameters;
        this.h = rtcpFeedbacks;
    }

    public int getId() {
        return this.a;
    }

    public int getChannels() {
        return this.b;
    }

    public Optional<Integer> getClockrate() {
        return this.c;
    }

    public Optional<Integer> getMaxptime() {
        return this.d;
    }

    public Optional<String> getName() {
        return this.e;
    }

    public Optional<Integer> getPtime() {
        return this.f;
    }

    public List<Parameter> getParameters() {
        return this.g;
    }

    public List<RtcpFeedback> getRtcpFeedback() {
        return this.h;
    }

    public Element toElement() {
        Element element = new Element("payload-type");
        element.setAttribute("id", String.valueOf(this.a));
        if (this.b != 1) {
            element.setAttribute("channels", String.valueOf(this.b));
        }
        this.e.ifPresent(string -> element.setAttribute("name", string));
        this.c.ifPresent(n -> element.setAttribute("clockrate", String.valueOf(n)));
        this.f.ifPresent(n -> element.setAttribute("ptime", String.valueOf(n)));
        this.d.ifPresent(n -> element.setAttribute("maxptime", String.valueOf(n)));
        this.g.stream().map(Parameter::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        this.h.stream().map(RtcpFeedback::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        return element;
    }

    public List<String> toSDP() {
        StringBuilder stringBuilder = new StringBuilder("a=rtpmap:").append(this.a);
        this.e.ifPresent(string -> {
            stringBuilder.append(" ").append((String)string);
            this.c.ifPresent(n -> stringBuilder.append("/").append(n));
            if (this.b > 1) {
                stringBuilder.append("/").append(this.b);
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringBuilder.toString());
        if (!this.g.isEmpty()) {
            arrayList.add("a=fmtp:" + this.a + " " + this.g.stream().map(Parameter::toSDP).collect(Collectors.joining(";")));
        }
        this.h.stream().map(rtcpFeedback -> {
            StringBuilder stringBuilder = new StringBuilder("a=rtcp-fb:").append(this.a).append(" ").append(rtcpFeedback.a);
            rtcpFeedback.getSubtype().ifPresent(string -> stringBuilder.append(" ").append((String)string));
            return stringBuilder.toString();
        }).forEach(arrayList::add);
        return arrayList;
    }

    public static class RtcpFeedback {
        private final String a;
        private final Optional<String> b;

        public static RtcpFeedback from(Element el) {
            if ("rtcp-fb".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:rtcp-fb:0".equals(el.getXMLNS())) {
                String string = el.getAttributeStaticStr("type");
                if (string == null) {
                    return null;
                }
                return new RtcpFeedback(string, Optional.ofNullable(el.getAttributeStaticStr("subtype")));
            }
            return null;
        }

        public static RtcpFeedback from(String sdp) {
            String[] stringArray = sdp.split(" ");
            return new RtcpFeedback(stringArray[0], Optional.ofNullable(stringArray.length > 1 ? stringArray[1] : null));
        }

        public RtcpFeedback(String type, Optional<String> subtype) {
            this.a = type;
            this.b = subtype;
        }

        public String getType() {
            return this.a;
        }

        public Optional<String> getSubtype() {
            return this.b;
        }

        public Element toElement() {
            Element element = new Element("rtcp-fb", new String[]{"xmlns", "type"}, new String[]{"urn:xmpp:jingle:apps:rtp:rtcp-fb:0", this.a});
            this.b.ifPresent(string -> element.setAttribute("subtype", string));
            return element;
        }
    }

    public static class Parameter {
        private final String a;
        private final String b;

        public static Parameter from(String sdp) {
            String[] stringArray = sdp.split("=");
            return new Parameter(stringArray[0], stringArray.length > 1 ? stringArray[1] : "");
        }

        public static Parameter from(Element el) {
            if ("parameter".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:1".equals(el.getXMLNS())) {
                String string = el.getAttributeStaticStr("name");
                String string2 = el.getAttributeStaticStr("value");
                if (string == null || string2 == null) {
                    return null;
                }
                return new Parameter(string, string2);
            }
            return null;
        }

        public Parameter(String name, String value) {
            this.a = name;
            this.b = value;
        }

        public String getName() {
            return this.a;
        }

        public String getValue() {
            return this.b;
        }

        public Element toElement() {
            return new Element("parameter", new String[]{"xmlns", "name", "value"}, new String[]{"urn:xmpp:jingle:apps:rtp:1", this.a, this.b});
        }

        public String toSDP() {
            return this.a + "=" + this.b;
        }
    }
}

