/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import tigase.meet.jingle.Candidate;
import tigase.meet.jingle.Description;
import tigase.meet.jingle.Encryption;
import tigase.meet.jingle.Fingerprint;
import tigase.meet.jingle.HdrExt;
import tigase.meet.jingle.Payload;
import tigase.meet.jingle.SDP;
import tigase.meet.jingle.SSRC;
import tigase.meet.jingle.SSRCGroup;
import tigase.meet.jingle.Transport;
import tigase.xml.Element;

public class Content {
    private final Creator a;
    private final String b;
    private final Optional<Description> c;
    private final List<Transport> d;
    private final Optional<Senders> e;

    public static Content from(Element el) {
        if ("content".equals(el.getName())) {
            String string = el.getAttributeStaticStr("name");
            if (string == null) {
                return null;
            }
            Optional<Creator> optional = Optional.ofNullable(el.getAttributeStaticStr("creator")).map(Creator::valueOf);
            if (optional.isEmpty()) {
                return null;
            }
            Optional<Senders> optional2 = Optional.ofNullable(el.getAttributeStaticStr("senders")).map(Senders::valueOf);
            List list = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList());
            Optional<Description> optional3 = list.stream().map(Description::from).filter(Objects::nonNull).findFirst();
            List<Transport> list2 = list.stream().map(Transport::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Content(optional.get(), string, optional2, optional3, list2);
        }
        return null;
    }

    public static Content from(String sdp, String[] sessionLines, Function<String, Creator> creatorProvider, Creator localRole) {
        String[] stringArray2 = sdp.split("\r\n");
        String[] stringArray3 = stringArray2[0].split(" ");
        String string2 = stringArray3[0].substring(2);
        String string4 = Arrays.stream(stringArray2).filter(string -> string.startsWith("a=mid:")).findFirst().map(string -> string.substring(6)).orElse(string2);
        Optional<String> optional = Arrays.stream(stringArray2).filter(string -> string.startsWith("a=ice-pwd:")).findFirst().map(string -> string.substring("a=ice-pwd:".length()));
        Optional<String> optional2 = Arrays.stream(stringArray2).filter(string -> string.startsWith("a=ice-ufrag:")).findFirst().map(string -> string.substring("a=ice-ufrag:".length()));
        Creator creator = creatorProvider.apply(string4);
        Optional<Senders> optional3 = StreamType.fromLines(stringArray2).map(streamType -> streamType.toSenders(localRole));
        List list = Arrays.stream(stringArray3).limit(stringArray2.length - 1).skip(3L).collect(Collectors.toList());
        List<Payload> list2 = list.stream().map(string3 -> {
            String string4 = "a=rtpmap:" + string3;
            Optional<String[]> optional = Arrays.stream(stringArray2).filter(string2 -> string2.startsWith(string4)).map(string2 -> string2.substring(string4.length())).findFirst().map(string -> string.split("/"));
            String string5 = "a=fmtp:" + string3;
            List<Payload.Parameter> list = Arrays.stream(stringArray2).filter(string2 -> string2.startsWith(string5)).map(string2 -> string2.substring(string5.length())).map(string -> string.split(";")).flatMap(Arrays::stream).map(Payload.Parameter::from).filter(Objects::nonNull).collect(Collectors.toList());
            String string6 = "a=rtcp-fb:" + string3 + " ";
            List<Payload.RtcpFeedback> list2 = Arrays.stream(stringArray2).filter(string2 -> string2.startsWith(string6)).map(string2 -> string2.substring(string6.length())).map(Payload.RtcpFeedback::from).filter(Objects::nonNull).collect(Collectors.toList());
            Optional<Integer> optional2 = optional.map(stringArray -> stringArray[1]).map(Integer::parseInt);
            int n = optional.filter(stringArray -> ((String[])stringArray).length > 2).map(stringArray -> stringArray[2]).map(Integer::parseInt).orElse(1);
            return new Payload(Integer.parseInt(string3), n, optional2, Optional.empty(), optional.map(stringArray -> stringArray[0].trim()), Optional.empty(), list, list2);
        }).collect(Collectors.toList());
        List<Encryption> list3 = Arrays.stream(stringArray2).filter(string -> string.startsWith("a=crypto:")).map(string -> string.split(" ")).filter(stringArray -> ((String[])stringArray).length > 3).map(stringArray -> new Encryption(stringArray[0], stringArray[1], Optional.ofNullable(((String[])stringArray).length > 3 ? stringArray[3] : null), stringArray[2])).filter(Objects::nonNull).collect(Collectors.toList());
        List<HdrExt> list4 = HdrExt.from(stringArray2);
        List<SSRC> list5 = SSRC.from(stringArray2);
        List<SSRCGroup> list6 = SSRCGroup.from(stringArray2);
        boolean bl = Arrays.stream(stringArray2).anyMatch(string -> string.equals("a=rtcp-mux"));
        Description description = new Description(string2, Optional.empty(), list2, null, list3, bl, list5, list6, list4);
        List<Candidate> list7 = Arrays.stream(stringArray2).filter(string -> string.startsWith("a=candidate:")).map(Candidate::from).filter(Objects::nonNull).collect(Collectors.toList());
        Optional<Fingerprint.Setup> optional4 = Fingerprint.Setup.from(stringArray2).or(() -> Fingerprint.Setup.from(sessionLines));
        Optional<Fingerprint.FingerprintData> optional5 = Fingerprint.FingerprintData.from(stringArray2).or(() -> Fingerprint.FingerprintData.from(sessionLines));
        Optional<Fingerprint> optional6 = optional4.flatMap(setup -> optional5.map(fingerprintData -> new Fingerprint(fingerprintData.getHash(), fingerprintData.getValue(), (Fingerprint.Setup)((Object)setup))));
        Transport transport = new Transport(optional2, optional, list7, optional6);
        return new Content(creator, string4, optional3, Optional.of(description), List.of(transport));
    }

    public Content(Creator creator, String name, Optional<Senders> senders, Optional<Description> description, List<Transport> transports) {
        this.a = creator;
        this.b = name;
        this.e = senders;
        this.c = description;
        this.d = transports;
    }

    public Creator getCreator() {
        return this.a;
    }

    public String getName() {
        return this.b;
    }

    public Optional<Description> getDescription() {
        return this.c;
    }

    public List<Transport> getTransports() {
        return this.d;
    }

    public Senders getSenders() {
        return this.e.orElse(Senders.both);
    }

    public Element toElement() {
        Element element = new Element("content");
        element.setAttribute("name", this.b);
        element.setAttribute("creator", this.a.name());
        this.e.ifPresent(senders -> element.setAttribute("senders", senders.name()));
        this.c.map(Description::toElement).ifPresent(arg_0 -> ((Element)element).addChild(arg_0));
        this.d.stream().map(Transport::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        return element;
    }

    public Content cloneHeaderOnly() {
        return new Content(this.a, this.b, this.e, Optional.empty(), Collections.emptyList());
    }

    public Content cloneForModify() {
        return new Content(this.a, this.b, this.e, this.c.map(Description::cloneWithSSRCsOnly), Collections.emptyList());
    }

    public Content withSenders(Senders senders) {
        return new Content(this.a, this.b, Optional.ofNullable(senders), this.c, this.d);
    }

    public Content withSSRCs(List<SSRC> ssrcs, List<SSRCGroup> ssrcGroups) {
        return new Content(this.a, this.b, this.e, this.c.map(description -> description.withSSRCs(ssrcs, ssrcGroups)), this.d);
    }

    public String toSDP(Creator localRole, SDP.Direction direction) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.c.ifPresent(description -> {
            String string = description.getEncryptions().isEmpty() && !this.d.stream().filter(transport -> transport.getFingerprint().isEmpty()).findAny().isEmpty() ? "RTP/AVPF" : "RTP/SAVPF";
            arrayList.add("m=" + description.getMedia() + " 1 " + string + " " + description.getPayloads().stream().map(payload -> payload.getId()).map(String::valueOf).collect(Collectors.joining(" ")));
        });
        arrayList.add("c=IN IP4 0.0.0.0");
        if (this.c.filter(description -> Set.of("audio", "video").contains(description.getMedia())).isPresent()) {
            arrayList.add("a=rtcp:1 IN IP4 0.0.0.0");
        }
        this.d.stream().findFirst().ifPresent(transport -> {
            transport.getUfrag().map(string -> "a=ice-ufrag:" + string).ifPresent(arrayList::add);
            transport.getPwd().map(string -> "a=ice-pwd:" + string).ifPresent(arrayList::add);
            transport.getFingerprint().ifPresent(fingerprint -> {
                arrayList.add("a=fingerprint:" + fingerprint.getHash() + " " + fingerprint.getValue());
                arrayList.add("a=setup:" + fingerprint.getSetup().name());
            });
        });
        arrayList.add("a=" + this.getSenders().toStreamType(localRole, direction).name());
        arrayList.add("a=mid:" + this.b);
        arrayList.add("a=ice-options:trickle");
        this.c.ifPresent(description -> {
            if (Set.of("audio", "video").contains(description.getMedia())) {
                if (description.isRtcpMux()) {
                    arrayList.add("a=rtcp-mux");
                }
                description.getEncryptions().stream().map(Encryption::toSDP).forEach(arrayList::add);
            }
            description.getPayloads().stream().map(Payload::toSDP).flatMap(Collection::stream).forEach(arrayList::add);
            description.getHdrExts().stream().map(HdrExt::toSDP).forEach(arrayList::add);
            description.getSsrcGroups().stream().map(SSRCGroup::toSDP).forEach(arrayList::add);
            description.getSsrcs().stream().map(SSRC::toSDP).flatMap(Collection::stream).forEach(arrayList::add);
            description.getSsrcs().stream().map(SSRC::getParameters).flatMap(list -> list.stream()).filter(parameter -> "msid".equals(parameter.getName()) && parameter.getValue().isPresent()).map(SSRC.Parameter::getValue).map(Optional::get).distinct().map(string -> "a=msid:" + string).forEach(arrayList::add);
        });
        this.d.stream().findFirst().ifPresent(transport -> transport.getCandidates().stream().map(Candidate::toSDP).map(string -> "a=" + string).forEach(arrayList::add));
        return arrayList.stream().collect(Collectors.joining("\r\n"));
    }

    public static final class Creator
    extends Enum<Creator> {
        public static final /* enum */ Creator initiator = new Creator();
        public static final /* enum */ Creator responder = new Creator();
        private static final /* synthetic */ Creator[] a;

        public static Creator[] values() {
            return (Creator[])a.clone();
        }

        public static Creator valueOf(String name) {
            return Enum.valueOf(Creator.class, name);
        }

        private static /* synthetic */ Creator[] a() {
            return new Creator[]{initiator, responder};
        }

        static {
            a = Creator.a();
        }
    }

    public static final class StreamType
    extends Enum<StreamType> {
        public static final /* enum */ StreamType inactive = new StreamType();
        public static final /* enum */ StreamType sendonly = new StreamType();
        public static final /* enum */ StreamType recvonly = new StreamType();
        public static final /* enum */ StreamType sendrecv = new StreamType();
        public static final Map<String, StreamType> SDP_LINE;
        private static final /* synthetic */ StreamType[] a;

        public static StreamType[] values() {
            return (StreamType[])a.clone();
        }

        public static StreamType valueOf(String name) {
            return Enum.valueOf(StreamType.class, name);
        }

        public static Optional<StreamType> fromLines(String[] lines) {
            return Arrays.stream(lines).map(SDP_LINE::get).filter(Objects::nonNull).findFirst();
        }

        public Senders toSenders(Creator creator) {
            switch (this) {
                case inactive: {
                    return Senders.none;
                }
                case sendrecv: {
                    return Senders.both;
                }
                case recvonly: {
                    return creator == Creator.initiator ? Senders.responder : Senders.initiator;
                }
                case sendonly: {
                    return creator == Creator.initiator ? Senders.initiator : Senders.responder;
                }
            }
            throw new IllegalStateException("Unsupported state: " + this.name() + " - " + creator.name());
        }

        private static /* synthetic */ StreamType[] a() {
            return new StreamType[]{inactive, sendonly, recvonly, sendrecv};
        }

        static {
            a = StreamType.a();
            SDP_LINE = Arrays.stream(StreamType.values()).collect(Collectors.toMap(streamType -> "a=" + streamType.name(), Function.identity()));
        }
    }

    public static final class Senders
    extends Enum<Senders> {
        public static final /* enum */ Senders none = new Senders();
        public static final /* enum */ Senders initiator = new Senders();
        public static final /* enum */ Senders responder = new Senders();
        public static final /* enum */ Senders both = new Senders();
        private static final /* synthetic */ Senders[] a;

        public static Senders[] values() {
            return (Senders[])a.clone();
        }

        public static Senders valueOf(String name) {
            return Enum.valueOf(Senders.class, name);
        }

        public StreamType toStreamType(Creator localRole, SDP.Direction direction) {
            switch (this) {
                case none: {
                    return StreamType.inactive;
                }
                case both: {
                    return StreamType.sendrecv;
                }
                case initiator: {
                    switch (direction) {
                        case outgoing: {
                            return localRole == Creator.initiator ? StreamType.sendonly : StreamType.recvonly;
                        }
                        case incoming: {
                            return localRole == Creator.responder ? StreamType.sendonly : StreamType.recvonly;
                        }
                    }
                }
                case responder: {
                    switch (direction) {
                        case outgoing: {
                            return localRole == Creator.responder ? StreamType.sendonly : StreamType.recvonly;
                        }
                        case incoming: {
                            return localRole == Creator.initiator ? StreamType.sendonly : StreamType.recvonly;
                        }
                    }
                }
            }
            throw new IllegalStateException("Unsupported state: " + this.name() + " - " + localRole.name() + " - " + direction);
        }

        private static /* synthetic */ Senders[] a() {
            return new Senders[]{none, initiator, responder, both};
        }

        static {
            a = Senders.a();
        }
    }
}

