/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.meet.AbstractMeet;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.meet.janus.videoroom.Publisher;

public abstract class AbstractParticipation<P extends AbstractParticipation<P, M>, M extends AbstractMeet<P>>
implements LocalPublisher.Listener,
LocalSubscriber.Listener {
    private static final Logger a = Logger.getLogger(AbstractParticipation.class.getCanonicalName());
    private final M b;
    protected final LocalPublisher publisher;
    protected final LocalSubscriber subscriber;

    public AbstractParticipation(M meet, LocalPublisher localPublisher, LocalSubscriber localSubscriber) {
        this.b = meet;
        this.publisher = localPublisher;
        this.subscriber = localSubscriber;
    }

    public M getMeet() {
        return this.b;
    }

    public void setListeners() {
        this.subscriber.setListener(this);
        this.publisher.setListener(this);
    }

    @Override
    public void addedPublishers(Collection<Publisher> publishers) {
        this.subscriber.subscribe(publishers.stream().flatMap(publisher -> publisher.getStreams().stream().map(stream -> new JanusVideoRoomPlugin.Stream(publisher.getId(), stream.getMid()))).collect(Collectors.toList()));
    }

    @Override
    public void removedPublishers(long publisherId) {
        this.subscriber.unsubscribe(publisherId);
    }

    public CompletableFuture<JSEP> sendPublisherSDP(JSEP offer) {
        return this.publisher.publish(offer).whenComplete((jSEP, throwable) -> {
            if (throwable != null) {
                this.leave((Throwable)throwable);
            }
        });
    }

    public CompletableFuture<Void> sendPublisherCandidate(JanusPlugin.Candidate candidate) {
        return this.publisher.sendCandidate(candidate);
    }

    public CompletableFuture<Void> sendSubscriberCandidate(JanusPlugin.Candidate candidate) {
        return this.subscriber.sendCandidate(candidate);
    }

    public CompletableFuture<Void> sendSubscriberSDP(JSEP answer) {
        return this.subscriber.start(answer).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                this.leave((Throwable)throwable);
            }
        });
    }

    public synchronized CompletableFuture<Void> leave(Throwable ex) {
        if (ex != null) {
            a.log(Level.WARNING, ex, () -> "participation " + this.toString() + " leaving due to error");
        }
        ((AbstractMeet)this.b).left((AbstractParticipation)this);
        return CompletableFuture.allOf(this.publisher.leave()).thenCompose(void_ -> this.publisher.getSession().destroy());
    }

    public String toString() {
        return "AbstractParticipation{meet=" + this.b + "}";
    }
}

