/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import tigase.meet.AbstractParticipation;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractMeet<T extends AbstractParticipation> {
    public static final BareJID ALLOW_EVERYONE = BareJID.bareJIDInstanceNS((String)"*");
    private final Object a;
    private final JanusConnection b;

    public AbstractMeet(JanusConnection janusConnection, Object roomId) {
        this.b = janusConnection;
        this.a = roomId;
    }

    public Object getRoomId() {
        return this.a;
    }

    public JanusConnection getJanusConnection() {
        return this.b;
    }

    protected CompletableFuture<T> join(String displayName, BiFunction<LocalPublisher, LocalSubscriber, T> participationConstructor) {
        return this.b.createSession().thenCompose(janusSession -> this.createParticipation((JanusSession)janusSession, displayName, participationConstructor).whenComplete((abstractParticipation, throwable) -> {
            if (throwable != null) {
                janusSession.destroy();
            }
        }));
    }

    protected CompletableFuture<T> createParticipation(JanusSession session, String displayName, BiFunction<LocalPublisher, LocalSubscriber, T> participationConstructor) {
        CompletionStage completionStage = session.attachPlugin(JanusVideoRoomPlugin.class).thenCompose(janusVideoRoomPlugin -> janusVideoRoomPlugin.createPublisher(this.a, displayName));
        CompletionStage completionStage2 = session.attachPlugin(JanusVideoRoomPlugin.class).thenApply(janusVideoRoomPlugin -> janusVideoRoomPlugin.createSubscriber(this.a));
        return ((CompletableFuture)completionStage).thenCombineAsync(completionStage2, participationConstructor);
    }

    public CompletableFuture<Void> destroy() {
        return ((CompletableFuture)this.b.createSession().thenCompose(janusSession -> ((CompletableFuture)janusSession.attachPlugin(JanusVideoRoomPlugin.class).thenCompose(janusVideoRoomPlugin -> janusVideoRoomPlugin.destroyRoom(this.a))).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                janusSession.destroy();
            }
        }))).thenAccept(void_ -> this.b.close());
    }

    public abstract void left(T var1);

    public String toString() {
        return "AbstractMeet{roomId=" + this.a + ", janusConnection=" + this.b + "}";
    }
}

