/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.cluster;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.cluster.StrategyIfc;
import tigase.workgroupqueues.cluster.WorkgroupQueuesClusteredComponent;
import tigase.workgroupqueues.data.Store;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="strategy", parent=WorkgroupQueuesClusteredComponent.class, active=true)
public class ClusteredStrategy
implements StrategyIfc {
    private static final String a = "wq-packet-forward-cmd";
    private static final Logger b = Logger.getLogger(ClusteredStrategy.class.getCanonicalName());
    private final ConcurrentMap<BareJID, JID> c = new ConcurrentHashMap<BareJID, JID>();
    private ClusterControllerIfc d;
    @Inject
    private WorkgroupQueuesClusteredComponent component;
    @Inject
    private EventBus eventBus;
    private JID e;

    @HandleEvent(filter=HandleEvent.Type.all)
    public void eventHandler(QueueOwnershipEvent event) {
        this.c.put(event.getQueueJid(), event.getNodeJid());
    }

    protected void forwardPacketToNode(JID nodeJid, Packet packet) {
        this.d.sendToNodes(a, packet.getElement(), this.e, null, new JID[]{nodeJid});
    }

    private JID a(BareJID bareJID) {
        JID jID = (JID)this.c.get(bareJID);
        return jID;
    }

    @Override
    public List<JID> getNodesConnected() {
        return null;
    }

    @Override
    public List<JID> getNodesConnectedWithLocal() {
        return null;
    }

    @Override
    public void nodeConnected(JID nodeJid) {
    }

    @Override
    public void nodeDisconnected(JID nodeJid) {
        Iterator iterator = this.c.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((JID)entry.getValue()).equals((Object)nodeJid)) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean processPacket(Packet packet) {
        BareJID bareJID = packet.getStanzaTo().getBareJID();
        JID jID = this.a(bareJID);
        if (bareJID.getLocalpart() == null) {
            return false;
        }
        if (jID == null || this.e.equals((Object)jID)) {
            this.publishOwnershipInformation(bareJID, this.e);
            return false;
        }
        if (b.isLoggable(Level.FINER)) {
            b.log(Level.FINER, "room = {0}, forwarding packet to node = {1}", new Object[]{bareJID, jID});
        }
        this.forwardPacketToNode(jID, packet);
        return true;
    }

    protected void publishOwnershipInformation(BareJID queueJid, JID nodeJid) {
        QueueOwnershipEvent queueOwnershipEvent = new QueueOwnershipEvent();
        queueOwnershipEvent.setNodeJid(nodeJid);
        queueOwnershipEvent.setQueueJid(queueJid);
        this.eventBus.fire((Object)queueOwnershipEvent);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.d = cl_controller;
    }

    @Override
    public void setComponent(WorkgroupQueuesClusteredComponent component) {
        this.component = component;
        this.setLocalNodeJid(JID.jidInstanceNS((String)component.getName(), (String)component.getDefHostName().getDomain(), null));
    }

    protected void setLocalNodeJid(JID jid) {
        this.e = jid;
    }

    @Override
    public void setStore(Store store) {
    }

    @Override
    public void start() {
        this.eventBus.registerAll((Object)this);
    }

    @Override
    public void stop() {
        this.eventBus.unregisterAll((Object)this);
    }

    public static class QueueOwnershipEvent
    implements Serializable {
        private JID a;
        private BareJID b;

        public JID getNodeJid() {
            return this.a;
        }

        public void setNodeJid(JID nodeJid) {
            this.a = nodeJid;
        }

        public BareJID getQueueJid() {
            return this.b;
        }

        public void setQueueJid(BareJID queueJid) {
            this.b = queueJid;
        }
    }

    @Bean(name="wq-packet-forward-cmd", parent=ClusteredStrategy.class, active=true)
    public static class PacketForwardCmd
    extends CommandListenerAbstract {
        @Inject
        private WorkgroupQueuesClusteredComponent component;

        public PacketForwardCmd() {
            super(ClusteredStrategy.a, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                for (Element element : packets) {
                    try {
                        Packet packet = Packet.packetInstance((Element)element);
                        if (b.isLoggable(Level.FINEST)) {
                            b.log(Level.FINEST, "received packet {0} forwarded from node {1}", new Object[]{packet, fromNode});
                        }
                        if (this.component.addPacketNB(packet)) {
                            if (!b.isLoggable(Level.FINEST)) continue;
                            b.log(Level.FINEST, "forwarded packet added to processing queue of component = {0}", packet.toString());
                            continue;
                        }
                        b.log(Level.FINE, "forwarded packet dropped due to component queue overflow = {0}", packet.toString());
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        b.log(Level.FINEST, "Addressing problem, stringprep failed for packet: {0}", element);
                    }
                }
            }
        }
    }
}

