/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.DSLBeanConfigurator;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigReader;
import tigase.db.DataRepository;
import tigase.db.DataSource;
import tigase.db.converter.ConverterUtil;
import tigase.db.converter.Convertible;
import tigase.db.converter.DataRepoPool;
import tigase.db.converter.QueryExecutor;
import tigase.db.converter.RowEntity;
import tigase.db.jdbc.DataRepositoryImpl;
import tigase.kernel.KernelException;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Kernel;
import tigase.util.ClassUtil;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.ParameterParser;

public class Converter {
    static final String repositoryClassParameter = "repository-class";
    static final String sourceUriParameter = "source-uri";
    static final String serverTypeParameter = "server-type";
    static final String virtualHostParameter = "virtual-host";
    private static final Logger log = Logger.getLogger(Converter.class.getName());
    private static final String defaultRepositoryClass = DataRepositoryImpl.class.getName();
    private static final Logger loggerFor = Logger.getLogger("convertible");
    private final ConverterProperties converterProperties;
    private final String respositoryClassStr;
    private final String sourceURI;
    DataRepoPool dataRepoPool;
    private Set<Class<Convertible>> convertibles;
    private boolean initialised = false;
    private Kernel kernel;
    private List<BeanConfig> registeredConvertibleBeans = new ArrayList<BeanConfig>();

    private static List<CommandlineParameter> getCommandlineOptions() {
        ArrayList<CommandlineParameter> options = new ArrayList<CommandlineParameter>();
        options.add(new CommandlineParameter.Builder("R", repositoryClassParameter).description("Data Repository implementation used for reading data from source; must implement " + DataSource.class.getName()).defaultValue(defaultRepositoryClass).required(true).build());
        options.add(new CommandlineParameter.Builder("S", sourceUriParameter).description("URI of the source do the data: `jdbc:xxxx://<host>/<database>\u2026`").required(true).build());
        options.add(new CommandlineParameter.Builder("T", serverTypeParameter).description("Type of the server from which import will be performed").options(SERVER.strings).required(true).build());
        options.add(new CommandlineParameter.Builder("H", virtualHostParameter).description("Virtual-host / domain name used by installation").required(true).build());
        return options;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        ConverterUtil.initLogger();
        ParameterParser parser = new ParameterParser(true);
        parser.addOptions(Converter.getCommandlineOptions());
        Properties properties = null;
        if (null == args || args.length == 0 || (properties = parser.parseArgs(args)) == null) {
            String usage = "$ java -cp jars/*:. tigase.db.converter.Converter [options]\n\t\tif the option defines default then <value> is optional";
            System.out.println(parser.getHelp(usage));
            System.exit(0);
        } else {
            System.out.println("Properties: " + properties);
        }
        Converter converter = null;
        try {
            converter = new Converter(properties);
            converter.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Converter initialisation failed: " + e);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Converter initialisation failed: " + e.getMessage(), e);
            }
            System.exit(1);
        }
        converter.convert();
        System.exit(0);
    }

    public Converter(Properties properties) {
        this.sourceURI = properties.getProperty(sourceUriParameter);
        this.respositoryClassStr = properties.getProperty(repositoryClassParameter);
        this.converterProperties = new ConverterProperties();
        String virtualHost = properties.getProperty(virtualHostParameter);
        this.converterProperties.setVHost(virtualHost);
        SERVER serverType = SERVER.valueOf(properties.getProperty(serverTypeParameter));
        this.converterProperties.setServerType(serverType);
    }

    private void log(RowEntity entity, boolean passed, AtomicInteger total, Exception e) {
        log.log(Level.FINE, String.format("Storing %1$s: entity: %2$s %3$s", passed ? "OK" : "FAILED", entity, e != null ? " (" + e.getMessage() + ")" : ""), e);
        loggerFor.log(passed ? Level.INFO : Level.WARNING, "[{0}] {1} : {2}{3}", new String[]{String.valueOf(total.get()), entity.getID(), passed ? "OK" : "FAILED", e != null ? " (" + e.getMessage() + ")" : ""});
    }

    private void convert() {
        if (!this.initialised) {
            throw new IllegalStateException("Converter hasn't been initialised yet");
        }
        this.registeredConvertibleBeans.stream().map(bean -> (Convertible)bean.getKernel().getInstance(bean.getClazz())).sorted(Comparator.comparing(convertible -> convertible.dependsOn().isPresent())).forEach(convertible -> {
            Optional<String> query = convertible.getMainQuery();
            AtomicInteger failCount = new AtomicInteger();
            AtomicInteger totalCount = new AtomicInteger();
            if (query.isPresent()) {
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    this.dataRepoPool.initPreparedStatement(query.get(), query.get());
                    preparedStatement = this.dataRepoPool.getPreparedStatement(1, query.get());
                    resultSet = preparedStatement.executeQuery();
                    while (!resultSet.isClosed() && resultSet.next()) {
                        Optional entity = Optional.empty();
                        totalCount.getAndIncrement();
                        try {
                            boolean result;
                            entity = convertible.processResultSet(resultSet);
                            if (entity.isPresent() && (result = convertible.storeEntity((RowEntity)entity.get()))) {
                                this.log((RowEntity)entity.get(), true, totalCount, null);
                                continue;
                            }
                            failCount.getAndIncrement();
                            this.log((RowEntity)entity.get(), false, totalCount, null);
                        }
                        catch (RepositoryException e) {
                            failCount.getAndIncrement();
                            this.log((RowEntity)entity.get(), false, totalCount, (Exception)((Object)e));
                        }
                    }
                    this.dataRepoPool.release(preparedStatement, resultSet);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error while converting data", e);
                }
                finally {
                    this.dataRepoPool.release(preparedStatement, resultSet);
                }
            }
            log.log(Level.INFO, "Conversion for {0} finished, {1} of {2} failed", new String[]{convertible.getClass().getSimpleName(), String.valueOf(failCount.get()), String.valueOf(totalCount.get())});
        });
    }

    private void init() throws Exception {
        Map config = new ConfigReader().read(new File("etc/config.tdsl"));
        config.put("schema-management", false);
        config.put("pool-size", 2);
        log.log(Level.CONFIG, "Using DSL configuration bootstrap: " + config);
        this.kernel = ConverterUtil.prepareKernel(config);
        DSLBeanConfigurator instance = (DSLBeanConfigurator)this.kernel.getInstance(DSLBeanConfigurator.class);
        StringWriter writer = new StringWriter();
        instance.dumpConfiguration((Writer)writer);
        log.log(Level.FINE, "Effective DSL config: " + writer.toString());
        Class<?> repoClazz = Class.forName(this.respositoryClassStr);
        try {
            this.dataRepoPool = new DataRepoPool();
            this.dataRepoPool.initialize(this.sourceURI);
            int repoPoolSize = 10;
            for (int i = 0; i < 10; ++i) {
                DataRepository sourceDataRepository = (DataRepository)repoClazz.newInstance();
                sourceDataRepository.initialize(this.sourceURI);
                this.dataRepoPool.addRepo(sourceDataRepository);
            }
            log.log(Level.INFO, "Source database type: " + this.dataRepoPool.getDatabaseType());
            this.converterProperties.setDatabaseType(this.dataRepoPool.getDatabaseType());
        }
        catch (KernelException e) {
            throw new ClassCastException("Class must implement DataRepository interface");
        }
        this.kernel.registerBean("QueryExecutor").asClass(QueryExecutor.class).exportable().exec();
        QueryExecutor queryExecutor = (QueryExecutor)this.kernel.getInstance(QueryExecutor.class);
        queryExecutor.initialise(this.dataRepoPool);
        this.convertibles = ClassUtil.getClassesImplementing(Convertible.class);
        log.log(Level.INFO, "Found converters: " + this.convertibles);
        this.registerConvertibleBeans();
        Set<Convertible> allConvertibleInstances = this.registeredConvertibleBeans.stream().map(bean -> {
            log.log(Level.FINE, "Retrieving bean " + bean.getBeanName() + " from " + bean.getKernel().getName());
            return bean.getKernel().getInstance(bean.getBeanName());
        }).filter(obj -> Convertible.class.isAssignableFrom(obj.getClass())).map(convertible -> {
            Convertible convertibleInstance = (Convertible)convertible;
            convertibleInstance.initialise(this.converterProperties);
            return convertibleInstance;
        }).collect(Collectors.toSet());
        Set supportedConvertibles = allConvertibleInstances.stream().filter(convertible -> convertible.getMainQuery().isPresent()).collect(Collectors.toSet());
        for (Convertible supportedConvertible : supportedConvertibles) {
            Map<String, String> queriesToInit = supportedConvertible.getAdditionalQueriesToInitialise();
            for (Map.Entry<String, String> entry : queriesToInit.entrySet()) {
                this.dataRepoPool.initPreparedStatement(entry.getKey(), entry.getValue());
            }
        }
        allConvertibleInstances.removeAll(supportedConvertibles);
        allConvertibleInstances.forEach(convertible -> {
            log.log(Level.FINE, "Unregistering: " + convertible.getClass().getSimpleName());
            this.convertibles.remove(convertible.getClass());
            List<BeanConfig> toUnregister = this.registeredConvertibleBeans.stream().filter(bean -> bean.getClazz().equals(convertible.getClass())).collect(Collectors.toList());
            toUnregister.forEach(bean -> bean.getKernel().unregister(convertible.getClass().getSimpleName()));
            this.registeredConvertibleBeans.removeAll(toUnregister);
        });
        log.log(Level.INFO, "Compatible converters: " + this.convertibles);
        this.initialised = true;
    }

    private void registerConvertibleBeans() {
        this.convertibles.forEach(this::registerConvertibleBean);
    }

    private void registerConvertibleBean(Class<Convertible> convertible) {
        try {
            Optional<Class> parent = convertible.newInstance().getParentBean();
            if (parent.isPresent()) {
                List found = this.kernel.getDependencyManager().getBeanConfigs(parent.get(), null, null, true);
                log.log(Level.FINEST, "Found parent beans for convertible " + convertible.getCanonicalName() + ": " + found);
                if (found.size() > 1) {
                    log.log(Level.WARNING, "Too many parent beans for convertible " + convertible.getCanonicalName() + ": " + found + ", skipping conversion...");
                    return;
                }
                if (found.isEmpty()) {
                    log.log(Level.WARNING, "No parent beans for convertible " + convertible.getCanonicalName() + ": " + found + ", skipping conversion...");
                    return;
                }
                BeanConfig parentBean = (BeanConfig)found.get(0);
                if (RegistrarBean.class.isAssignableFrom(parentBean.getClazz())) {
                    Object o = this.kernel.getInstance(parentBean.getClazz());
                    Kernel localKernel = (Kernel)this.kernel.getInstance(parentBean.getBeanName() + "#KERNEL");
                    localKernel.registerBean(convertible.getSimpleName()).asClass(convertible).exec();
                    this.registeredConvertibleBeans.add(localKernel.getDependencyManager().getBeanConfig(convertible.getSimpleName()));
                } else {
                    parentBean.getKernel().registerBean(convertible.getSimpleName()).asClass(convertible).exec();
                    this.registeredConvertibleBeans.add(parentBean.getKernel().getDependencyManager().getBeanConfig(convertible.getSimpleName()));
                }
            } else {
                this.kernel.registerBean(convertible.getSimpleName()).asClass(convertible).exec();
                this.registeredConvertibleBeans.add(this.kernel.getDependencyManager().getBeanConfig(convertible.getSimpleName()));
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class ConverterProperties {
        private String VHost;
        private DataRepository.dbTypes databaseType;
        private SERVER serverType;

        public String getVHost() {
            return this.VHost;
        }

        private void setVHost(String VHost) {
            this.VHost = VHost;
        }

        public SERVER getServerType() {
            return this.serverType;
        }

        private void setServerType(SERVER serverType) {
            this.serverType = serverType;
        }

        public DataRepository.dbTypes getDatabaseType() {
            return this.databaseType;
        }

        private void setDatabaseType(DataRepository.dbTypes databaseType) {
            this.databaseType = databaseType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ConverterProperties{");
            sb.append("VHost='").append(this.VHost).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum SERVER {
        ejabberd,
        ejabberd_new;

        public static final String[] strings;

        static {
            strings = (String[])EnumSet.allOf(SERVER.class).stream().map(Enum::name).toArray(String[]::new);
        }
    }
}

