/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.socks5.Limits;
import tigase.socks5.Socks5ConnectionType;
import tigase.socks5.repository.Socks5Repository;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:.*"})
@Repository.SchemaId(id="socks5", name="Tigase SOCKS5 Proxy Component")
public class JDBCSocks5Repository
implements Socks5Repository<DataRepository>,
RepositoryVersionAware {
    private static final String DEF_CREATE_TRANSFER_USED_BY_CONNECTION_QUERY = "{ call TigSocks5CreateTransferUsed(?, ?, ?) }";
    private static final String DEF_CREATE_UID_QUERY = "{ call TigSocks5CreateUid(?, ?) }";
    private static final String DEF_GET_UID_QUERY = "{ call TigSocks5GetUid(?) }";
    private static final String DEF_GLOBAL_SETTINGS = "socks5-global";
    private static final String DEF_TRANSFER_LIMITS_DOMAIN_QUERY = "{ call TigSocks5GetTransferLimits(?) }";
    private static final String DEF_TRANSFER_LIMITS_GENERAL_QUERY = "{ call TigSocks5GetTransferLimits(?) }";
    private static final String DEF_TRANSFER_LIMITS_USER_QUERY = "{ call TigSocks5GetTransferLimits(?) }";
    private static final String DEF_TRANSFER_USED_DOMAIN_QUERY = "{ call TigSocks5TransferUsedDomain(?) }";
    private static final String DEF_TRANSFER_USED_GENERAL_QUERY = "{ call TigSocks5TransferUsedGeneral() }";
    private static final String DEF_TRANSFER_USED_INSTANCE_QUERY = "{ call TigSocks5TransferUsedInstance(?) }";
    private static final String DEF_TRANSFER_USED_USER_QUERY = "{ call TigSocks5TransferUsedUser(?) }";
    private static final String DEF_UPDATE_TRANSFER_USED_BY_CONNECTION_QUERY = "{ call TigSocks5UpdateTransferUsed(?, ?) }";
    private static final Logger log = Logger.getLogger(Socks5Repository.class.getCanonicalName());
    protected DataRepository data_repo;
    @ConfigField(desc="Query to create an entry for data transferred over connection", alias="create-transfer-used-by-connection")
    private String createTransferUsedByConnection_query = "{ call TigSocks5CreateTransferUsed(?, ?, ?) }";
    @ConfigField(desc="Query to create UID", alias="create-uid")
    private String createUid_query = "{ call TigSocks5CreateUid(?, ?) }";
    @ConfigField(desc="Query to retrieve UID", alias="get-uid")
    private String getUid_query = "{ call TigSocks5GetUid(?) }";
    @ConfigField(desc="Query to get file transfer limit for domain", alias="file-size-limit-domain")
    private String transferLimitsDomain_query = "{ call TigSocks5GetTransferLimits(?) }";
    @ConfigField(desc="Query to get file transfer limit", alias="file-size-limit-general")
    private String transferLimitsGeneral_query = "{ call TigSocks5GetTransferLimits(?) }";
    @ConfigField(desc="Query to get file transfer limit for user", alias="file-size-limit-user")
    private String transferLimitsUser_query = "{ call TigSocks5GetTransferLimits(?) }";
    @ConfigField(desc="Query to get transfer used by users of a domain", alias="transfer-used-domain")
    private String transferUsedDomain_query = "{ call TigSocks5TransferUsedDomain(?) }";
    @ConfigField(desc="Query to get transfer used", alias="transfer-used-general")
    private String transferUsedGeneral_query = "{ call TigSocks5TransferUsedGeneral() }";
    @ConfigField(desc="Query to get transfer used by cluster node", alias="transfer-used-instance")
    private String transferUsedInstance_query = "{ call TigSocks5TransferUsedInstance(?) }";
    @ConfigField(desc="Query to get transfer used by particular user", alias="transfer-used-user")
    private String transferUsedUser_query = "{ call TigSocks5TransferUsedUser(?) }";
    @ConfigField(desc="Query to update transfer used by a single connection", alias="update-transfer-used-by-connection")
    private String updateTransferUsedByConnection_query = "{ call TigSocks5UpdateTransferUsed(?, ?) }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createTransferUsedByConnection(BareJID user, Socks5ConnectionType type, BareJID instance) throws TigaseDBException {
        long connectionId = 0L;
        long uid = this.getUID(user);
        try {
            PreparedStatement createTransferUsedByConnection;
            ResultSet rs = null;
            PreparedStatement preparedStatement = createTransferUsedByConnection = this.data_repo.getPreparedStatement(user, this.createTransferUsedByConnection_query);
            synchronized (preparedStatement) {
                try {
                    createTransferUsedByConnection.setLong(1, uid);
                    createTransferUsedByConnection.setInt(2, type == Socks5ConnectionType.Requester ? 0 : 1);
                    createTransferUsedByConnection.setString(3, instance.toString());
                    switch (this.data_repo.getDatabaseType()) {
                        case jtds: 
                        case sqlserver: {
                            createTransferUsedByConnection.executeUpdate();
                            rs = createTransferUsedByConnection.getGeneratedKeys();
                            break;
                        }
                        default: {
                            rs = createTransferUsedByConnection.executeQuery();
                        }
                    }
                    if (rs.next()) {
                        connectionId = rs.getLong(1);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return connectionId;
    }

    public void setDataSource(DataRepository data_repo) {
        try {
            data_repo.initPreparedStatement(this.createUid_query, this.createUid_query);
            data_repo.initPreparedStatement(this.getUid_query, this.getUid_query);
            data_repo.initPreparedStatement(this.transferLimitsGeneral_query, this.transferLimitsGeneral_query);
            data_repo.initPreparedStatement(this.transferLimitsDomain_query, this.transferLimitsDomain_query);
            data_repo.initPreparedStatement(this.transferLimitsUser_query, this.transferLimitsUser_query);
            data_repo.initPreparedStatement(this.transferUsedGeneral_query, this.transferUsedGeneral_query);
            data_repo.initPreparedStatement(this.transferUsedInstance_query, this.transferUsedInstance_query);
            data_repo.initPreparedStatement(this.transferUsedDomain_query, this.transferUsedDomain_query);
            data_repo.initPreparedStatement(this.transferUsedUser_query, this.transferUsedUser_query);
            data_repo.initPreparedStatement(this.createTransferUsedByConnection_query, this.createTransferUsedByConnection_query);
            data_repo.initPreparedStatement(this.updateTransferUsedByConnection_query, this.updateTransferUsedByConnection_query);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransferUsedByConnection(BareJID user_id, long stream_id, long transferred_bytes) throws TigaseDBException {
        try {
            PreparedStatement updateTransferUsedByConnection;
            PreparedStatement preparedStatement = updateTransferUsedByConnection = this.data_repo.getPreparedStatement(user_id, this.updateTransferUsedByConnection_query);
            synchronized (preparedStatement) {
                updateTransferUsedByConnection.setLong(1, stream_id);
                updateTransferUsedByConnection.setLong(2, transferred_bytes);
                updateTransferUsedByConnection.executeUpdate();
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Limits getTransferLimits() throws TigaseDBException {
        Limits limits = new Limits();
        try {
            PreparedStatement transferLimitsGeneral;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferLimitsGeneral = this.data_repo.getPreparedStatement(null, this.transferLimitsGeneral_query);
            synchronized (preparedStatement) {
                try {
                    transferLimitsGeneral.setString(1, DEF_GLOBAL_SETTINGS);
                    rs = transferLimitsGeneral.executeQuery();
                    if (rs.next()) {
                        limits.setTransferLimitPerFile(rs.getLong(1));
                        limits.setTransferLimitPerUser(rs.getLong(2));
                        limits.setTransferLimitPerDomain(rs.getLong(3));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Limits getTransferLimits(String domain) throws TigaseDBException {
        Limits limits = new Limits();
        try {
            PreparedStatement transferLimitsDomain;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferLimitsDomain = this.data_repo.getPreparedStatement(null, this.transferLimitsDomain_query);
            synchronized (preparedStatement) {
                try {
                    transferLimitsDomain.setString(1, domain);
                    rs = transferLimitsDomain.executeQuery();
                    if (rs.next()) {
                        limits.setTransferLimitPerFile(rs.getLong(1));
                        limits.setTransferLimitPerUser(rs.getLong(2));
                        limits.setTransferLimitPerDomain(rs.getLong(3));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Limits getTransferLimits(BareJID user) throws TigaseDBException {
        Limits limits = new Limits();
        try {
            PreparedStatement transferLimitsUser;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferLimitsUser = this.data_repo.getPreparedStatement(user, this.transferLimitsUser_query);
            synchronized (preparedStatement) {
                try {
                    transferLimitsUser.setString(1, user.toString());
                    rs = transferLimitsUser.executeQuery();
                    if (rs.next()) {
                        limits.setTransferLimitPerFile(rs.getLong(1));
                        limits.setTransferLimitPerUser(rs.getLong(2));
                        limits.setTransferLimitPerDomain(rs.getLong(3));
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTransferUsed() throws TigaseDBException {
        long transferUsed = 0L;
        try {
            PreparedStatement transferUsedGeneral;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferUsedGeneral = this.data_repo.getPreparedStatement(null, this.transferUsedGeneral_query);
            synchronized (preparedStatement) {
                try {
                    rs = transferUsedGeneral.executeQuery();
                    if (rs.next()) {
                        transferUsed = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTransferUsedByDomain(String domain) throws TigaseDBException {
        long transferUsed = 0L;
        try {
            PreparedStatement transferUsedDomain;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferUsedDomain = this.data_repo.getPreparedStatement(null, this.transferUsedDomain_query);
            synchronized (preparedStatement) {
                try {
                    transferUsedDomain.setString(1, domain);
                    rs = transferUsedDomain.executeQuery();
                    if (rs.next()) {
                        transferUsed = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTransferUsedByInstance(String instance) throws TigaseDBException {
        long transferUsed = 0L;
        try {
            PreparedStatement transferUsedInstance;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferUsedInstance = this.data_repo.getPreparedStatement(null, this.transferUsedInstance_query);
            synchronized (preparedStatement) {
                try {
                    transferUsedInstance.setString(1, instance);
                    rs = transferUsedInstance.executeQuery();
                    if (rs.next()) {
                        transferUsed = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTransferUsedByUser(BareJID user) throws TigaseDBException {
        long transferUsed = 0L;
        long uid = this.getUID(user);
        try {
            PreparedStatement transferUsedUser;
            ResultSet rs = null;
            PreparedStatement preparedStatement = transferUsedUser = this.data_repo.getPreparedStatement(user, this.transferUsedUser_query);
            synchronized (preparedStatement) {
                try {
                    transferUsedUser.setLong(1, uid);
                    rs = transferUsedUser.executeQuery();
                    if (rs.next()) {
                        transferUsed = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createUID(BareJID user) throws TigaseDBException {
        if (this.createUid_query == null) {
            return 0L;
        }
        long uid = 0L;
        try {
            PreparedStatement create_uid;
            ResultSet rs = null;
            PreparedStatement preparedStatement = create_uid = this.data_repo.getPreparedStatement(user, this.createUid_query);
            synchronized (preparedStatement) {
                try {
                    create_uid.setString(1, user.toString());
                    create_uid.setString(2, user.getDomain());
                    switch (this.data_repo.getDatabaseType()) {
                        case jtds: 
                        case sqlserver: {
                            create_uid.executeUpdate();
                            rs = create_uid.getGeneratedKeys();
                            break;
                        }
                        default: {
                            rs = create_uid.executeQuery();
                        }
                    }
                    if (rs.next()) {
                        uid = rs.getLong(1);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        return uid;
    }

    private String getParamWithDef(Map<String, String> params, String key, String defValue) {
        if (params == null) {
            return defValue;
        }
        String result = params.get(key);
        if (result != null) {
            log.log(Level.CONFIG, "Custom query loaded for ''{0}'': ''{1}''", new Object[]{key, result});
        } else {
            log.log(Level.CONFIG, "Default query loaded for ''{0}'': ''{1}''", new Object[]{key, defValue});
        }
        if (result != null) {
            result.trim();
            if (result.isEmpty()) {
                result = null;
            }
        }
        return result != null ? result : defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getUID(BareJID user) throws TigaseDBException {
        if (this.getUid_query == null) {
            return 0L;
        }
        long uid = 0L;
        try {
            PreparedStatement get_uid;
            ResultSet rs = null;
            PreparedStatement preparedStatement = get_uid = this.data_repo.getPreparedStatement(user, this.getUid_query);
            synchronized (preparedStatement) {
                block9: {
                    long l;
                    try {
                        get_uid.setString(1, user.toString());
                        rs = get_uid.executeQuery();
                        if (rs.next()) {
                            uid = rs.getLong(1);
                            break block9;
                        }
                        l = this.createUID(user);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return l;
                }
                this.data_repo.release(null, rs);
                return uid;
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
    }
}

