/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import tigase.eventbus.EventBus;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFlat;

public abstract class RosterFactory {
    public static final String ROSTER_IMPL_PROP_KEY = "roster-implementation";
    public static final String ROSTER_IMPL_PROP_VAL;
    public static String defaultRosterImplementation;
    private static RosterAbstract shared;

    public static RosterAbstract getRosterImplementation(boolean shared_impl) {
        try {
            if (shared_impl) {
                return shared;
            }
            return RosterFactory.newRosterInstance(defaultRosterImplementation);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public static RosterAbstract newRosterInstance(String class_name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (RosterAbstract)Class.forName(class_name).newInstance();
    }

    static {
        defaultRosterImplementation = ROSTER_IMPL_PROP_VAL = RosterFlat.class.getCanonicalName();
        shared = null;
    }

    @tigase.kernel.beans.Bean(name="rosterFactory", exportable=true, active=true)
    public static class Bean
    implements Initializable,
    UnregisterAware {
        @ConfigField(desc="Roster implementation class", alias="roster-implementation")
        private String defaultRosterImplementation = ROSTER_IMPL_PROP_VAL;
        @Inject
        private EventBus eventBus;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setDefaultRosterImplementation(String defaultRosterImplementation) {
            this.defaultRosterImplementation = defaultRosterImplementation;
            RosterFactory.defaultRosterImplementation = defaultRosterImplementation;
            try {
                shared = RosterFactory.newRosterInstance(defaultRosterImplementation);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            if (this.eventBus == null || shared == null) return;
            Class<RosterFactory> clazz = RosterFactory.class;
            synchronized (RosterFactory.class) {
                shared.setEventBus(this.eventBus);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            Class<RosterFactory> clazz = RosterFactory.class;
            synchronized (RosterFactory.class) {
                if (shared != null) {
                    shared.setEventBus(eventBus);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void beforeUnregister() {
            if (shared != null) {
                shared.setEventBus(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void initialize() {
            if (shared != null) return;
            try {
                shared = RosterFactory.newRosterInstance(this.defaultRosterImplementation);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            if (this.eventBus == null || shared == null) return;
            Class<RosterFactory> clazz = RosterFactory.class;
            synchronized (RosterFactory.class) {
                shared.setEventBus(this.eventBus);
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }
}

