/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsFilter;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;

@Bean(name="ignore-from-unknown", parent=PushNotifications.class, active=true)
public class IgnoreFromUnknownFilter
implements PushNotificationsFilter {
    public static final String XMLNS = "tigase:push:filter:ignore-unknown:0";
    private static final Logger log = Logger.getLogger(IgnoreFromUnknownFilter.class.getCanonicalName());
    public static final String ID = "ignore-from-unknown";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:push:filter:ignore-unknown:0"})};
    protected final RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);
    @Inject
    private UserRepository userRepository;

    @Override
    public Element[] getDiscoFeatures() {
        return DISCO_FEATURES;
    }

    @Override
    public void processEnableElement(Element enableEl, Element settingsEl) {
        if (enableEl.getChild("ignore-unknown", XMLNS) != null) {
            settingsEl.addAttribute(ID, "true");
        }
    }

    @Override
    public boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        if (Boolean.valueOf(pushServiceSettings.getAttributeStaticStr(ID)).booleanValue() && packet.getType() != StanzaType.groupchat) {
            return this.isInRoster(packet, session);
        }
        return true;
    }

    protected boolean isInRoster(Packet packet, XMPPResourceConnection session) {
        try {
            if (session != null && session.isAuthorized()) {
                RosterElement rosterElement = this.roster_util.getRosterElement(session, packet.getStanzaFrom());
                if (rosterElement == null) {
                    return false;
                }
                return rosterElement.getSubscription() != RosterAbstract.SubscriptionType.none_pending_in;
            }
            Map<BareJID, RosterElement> roster = this.getRoster(packet.getStanzaTo().getBareJID());
            if (roster != null) {
                RosterElement rosterElement = roster.get(packet.getStanzaFrom().getBareJID());
                if (rosterElement == null) {
                    return false;
                }
                return rosterElement.getSubscription() != RosterAbstract.SubscriptionType.none_pending_in;
            }
            return false;
        }
        catch (RepositoryException | NotAuthorizedException ex) {
            log.log(Level.WARNING, "Could not retrieve roster for user " + packet.getStanzaTo(), ex);
            return false;
        }
    }

    protected Map<BareJID, RosterElement> getRoster(BareJID jid) throws TigaseDBException {
        String tmp = this.userRepository.getData(jid, "roster");
        HashMap<BareJID, RosterElement> roster = new HashMap<BareJID, RosterElement>();
        if (tmp != null) {
            RosterFlat.parseRosterUtil(tmp, roster, null);
        }
        return roster;
    }
}

