/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.ElementMatcher;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.MessageDeliveryLogic;
import tigase.xmpp.jid.JID;

@Bean(name="msgoffline", parent=SessionManager.class, active=false)
public class OfflineMessages
extends XMPPProcessor
implements XMPPPostprocessorIfc,
XMPPProcessorIfc {
    public static final String[] MESSAGE_EVENT_PATH = new String[]{"message", "event"};
    public static final String[] MESSAGE_HEADER_PATH = new String[]{"message", "header"};
    public static final String[] MESSAGE_HINTS_NO_STORE = new String[]{"message", "no-store"};
    public static final String MESSAGE_HINTS_XMLNS = "urn:xmpp:hints";
    public static final String[] MESSAGE_RECEIVED_PATH = new String[]{"message", "received"};
    public static final String MESSAGE_RECEIVED_XMLNS = "urn:xmpp:receipts";
    public static final String[] PUBSUB_NODE_PATH = new String[]{"message", "event", "items"};
    public static final String PUBSUB_NODE_KEY = "node";
    protected static final String XMLNS = "jabber:client";
    protected static final String ID = "msgoffline";
    private static final Logger log = Logger.getLogger(OfflineMessages.class.getName());
    private static final String[][] ELEMENTS = new String[][]{{"presence"}, {"iq", "msgoffline"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "msgoffline"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private static final String MSG_OFFLINE_STORAGE_PATHS = "msg-store-offline-paths";
    private static final String MSG_REPO_CLASS_KEY = "msg-repo-class";
    private static final String MSG_PUBSUB_JID = "msg-pubsub-jid";
    private static final String MSG_PUBSUB_NODE = "msg-pubsub-node";
    private static final String MSG_PUBSUB_PUBLISHER = "msg-pubsub-publisher";
    private static String defHost = DNSResolverFactory.getInstance().getDefaultHost();
    private final SimpleDateFormat formatter;
    @Inject
    private MessageDeliveryLogic message;
    @Inject(nullAllowed=true)
    private SessionManager.MessageArchive messageArchive;
    @ConfigField(desc="Offline message implementation repository class", alias="msg-repo-class")
    private String msgRepoCls = null;
    @Inject(nullAllowed=true)
    private List<Notifier> notifiers;
    @ConfigField(desc="Store offline messages with mathing paths", alias="msg-store-offline-paths")
    private ElementMatcher[] offlineStorageMatchers = new ElementMatcher[0];

    public OfflineMessages() {
        this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> queue, Map<String, Object> settings) {
        if (conn == null || packet.getElemName() == "message" && !this.message.hasConnectionForMessageDelivery(conn)) {
            try {
                if (packet.getElemName() == "message" && packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
                    return;
                }
                if (conn != null && packet.getStanzaTo() != null && !conn.isUserId(packet.getStanzaTo().getBareJID())) {
                    return;
                }
                OfflineMsgRepositoryIfc msg_repo = this.getMsgRepoImpl(repo, conn);
                Authorization saveResult = this.savePacketForOffLineUser(packet, msg_repo, repo);
                Packet result = null;
                this.notifyNewOfflineMessage(packet, conn, queue, settings);
                switch (saveResult) {
                    case SERVICE_UNAVAILABLE: {
                        result = saveResult.getResponseMessage(packet, "Offline messages queue is full", true);
                        break;
                    }
                }
                if (result != null) {
                    queue.offer(result);
                }
            }
            catch (UserNotFoundException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("UserNotFoundException at trying to save packet for off-line user." + packet);
                }
            }
            catch (NotAuthorizedException ex) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "NotAuthorizedException when checking if message is to this user at trying to save packet for off-line user, {0}, {1}", new Object[]{packet, conn});
                }
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINE, "Could not sent error to packet sent to offline user which storage to offline store failed. Packet is error type already: {0}", packet.toStringSecure());
            }
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException {
        switch (packet.getElemName()) {
            case "presence": {
                if (!this.loadOfflineMessages(packet, conn)) break;
                try {
                    OfflineMsgRepositoryIfc msg_repo = this.getMsgRepoImpl(repo, conn);
                    Queue<Packet> packets = this.restorePacketForOffLineUser(conn, msg_repo);
                    if (packets == null) break;
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Sending off-line messages: " + packets.size());
                    }
                    results.addAll(packets);
                    if (packets.isEmpty()) break;
                    this.notifyOfflineMessagesRetrieved(conn, results);
                }
                catch (UserNotFoundException e) {
                    log.info("Something wrong, DB problem, cannot load offline messages. " + e);
                }
                break;
            }
            case "iq": {
                this.processIq(packet, conn, repo, results);
            }
        }
    }

    public void processIq(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> results) throws NotAuthorizedException {
        try {
            if (conn != null && packet.getFrom().equals((Object)conn.getConnectionId())) {
                Element msgoffline = packet.getElement().getChild(ID);
                String limitStr = null;
                switch (packet.getType()) {
                    case set: {
                        limitStr = msgoffline.getAttributeStaticStr("limit");
                        Long limit = null;
                        if (limitStr != null) {
                            limit = "none".equals(limitStr) || "false".equals(limitStr) ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(limitStr));
                        }
                        if (limit == null) {
                            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Value of limit attribute is incorrect", false));
                            break;
                        }
                        if (limit >= 0L) {
                            conn.setPublicData("offline-msgs", "store-limit", limitStr);
                        } else {
                            conn.removePublicData("offline-msgs", "store-limit");
                        }
                    }
                    case get: {
                        if (limitStr == null) {
                            limitStr = conn.getPublicData("offline-msgs", "store-limit", null);
                        }
                        if (limitStr == null) {
                            limitStr = "false";
                        }
                        msgoffline = new Element(ID, new String[]{"xmlns", "limit"}, new String[]{ID, limitStr});
                        results.offer(packet.okResult(msgoffline, 0));
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to access this private storage.", false));
            }
        }
        catch (TigaseDBException tigaseDBException) {
        }
        catch (NoConnectionIdException noConnectionIdException) {
        }
        catch (PacketErrorTypeException packetErrorTypeException) {
            // empty catch block
        }
    }

    public Queue<Packet> restorePacketForOffLineUser(XMPPResourceConnection conn, tigase.db.OfflineMsgRepositoryIfc repo) throws UserNotFoundException, NotAuthorizedException {
        Queue<Element> elems = repo.loadMessagesToJID(conn, true);
        if (elems != null) {
            LinkedList<Packet> pacs = new LinkedList<Packet>();
            Element elem = null;
            while ((elem = elems.poll()) != null) {
                try {
                    Packet p = Packet.packetInstance(elem);
                    if (p.getElemName() == "iq") {
                        p.initVars(p.getStanzaFrom(), conn.getJID());
                    }
                    pacs.offer(p);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Packet addressing problem, stringprep failed: " + elem);
                }
            }
            try {
                Collections.sort(pacs, new StampComparator());
            }
            catch (NullPointerException e) {
                try {
                    log.warning("Can not sort off line messages: " + pacs + ",\n" + e);
                }
                catch (Exception exc) {
                    log.log(Level.WARNING, "Can not print log message.", exc);
                }
            }
            return pacs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authorization savePacketForOffLineUser(Packet packet, tigase.db.OfflineMsgRepositoryIfc repo, NonAuthUserRepository userRepo) throws UserNotFoundException {
        StanzaType type = packet.getType();
        if (this.isAllowedForOfflineStorage(packet)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Storing packet for offline user: {0}", packet);
            }
            Packet pac = packet.copyElementOnly();
            pac.setStableId(packet.getStableId());
            if (this.messageArchive != null) {
                this.messageArchive.addStableId(pac, null);
            }
            C2SDeliveryErrorProcessor.filterErrorElement(pac.getElement());
            String stamp = null;
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                stamp = this.formatter.format(new Date());
            }
            String from = pac.getStanzaTo().getDomain();
            Element x = new Element("delay", "Offline Storage - " + defHost, new String[]{"from", "stamp", "xmlns"}, new String[]{from, stamp, "urn:xmpp:delay"});
            pac.getElement().addChild((XMLNodeIfc)x);
            pac.processedBy(ID);
            if (repo.storeMessage(pac.getStanzaFrom(), pac.getStanzaTo(), null, pac.getElement(), userRepo)) {
                return Authorization.AUTHORIZED;
            }
            return Authorization.SERVICE_UNAVAILABLE;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet for offline user not suitable for storing: {0}", packet);
        }
        return Authorization.FEATURE_NOT_IMPLEMENTED;
    }

    public String[] getOfflineStorageMatchers() {
        String[] result = new String[this.offlineStorageMatchers.length];
        for (int i = 0; i < this.offlineStorageMatchers.length; ++i) {
            result[i] = this.offlineStorageMatchers[i].toString();
        }
        return result;
    }

    public void setOfflineStorageMatchers(String[] matcherStrs) {
        ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
        for (String matcherStr : matcherStrs) {
            ElementMatcher matcher = ElementMatcher.create(matcherStr);
            if (matcher == null) continue;
            matchers.add(matcher);
        }
        this.offlineStorageMatchers = matchers.toArray(new ElementMatcher[0]);
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    protected OfflineMsgRepositoryIfc getMsgRepoImpl(NonAuthUserRepository repo, XMPPResourceConnection conn) {
        if (this.msgRepoCls == null) {
            return new MsgRepositoryImpl(repo, conn);
        }
        try {
            OfflineMsgRepositoryIfc msgRepo = (OfflineMsgRepositoryIfc)ModulesManagerImpl.getInstance().forName(this.msgRepoCls).newInstance();
            msgRepo.init(repo, conn);
            return msgRepo;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected boolean isAllowedForOfflineStorage(Packet pac) {
        for (ElementMatcher matcher : this.offlineStorageMatchers) {
            if (!matcher.matches(pac)) continue;
            return matcher.getValue();
        }
        return this.isAllowedForOfflineStorageDefaults(pac);
    }

    protected boolean isAllowedForOfflineStorageDefaults(Packet pac) {
        StanzaType type = pac.getType();
        switch (pac.getElemName()) {
            case "message": {
                if (type != null && type != StanzaType.normal && type != StanzaType.chat) break;
                if (pac.getAttributeStaticStr(MESSAGE_HINTS_NO_STORE, "xmlns") == MESSAGE_HINTS_XMLNS) {
                    return false;
                }
                if (pac.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH) != null) {
                    return true;
                }
                if (pac.getElemChildrenStaticStr(MESSAGE_EVENT_PATH) != null) {
                    return true;
                }
                if (pac.getElemChildrenStaticStr(MESSAGE_HEADER_PATH) != null) {
                    return true;
                }
                if (pac.getElement().getXMLNSStaticStr(MESSAGE_RECEIVED_PATH) != MESSAGE_RECEIVED_XMLNS) break;
                return true;
            }
            case "presence": {
                if (type != StanzaType.subscribe && type != StanzaType.subscribed && type != StanzaType.unsubscribe && type != StanzaType.unsubscribed) break;
                return true;
            }
        }
        return false;
    }

    protected boolean loadOfflineMessages(Packet packet, XMPPResourceConnection conn) {
        if (conn == null || conn.isAnonymous()) {
            return false;
        }
        if (conn.getSessionData(ID) != null) {
            return false;
        }
        if (packet.getStanzaTo() != null) {
            return false;
        }
        if (conn.getCommonSessionData("http://jabber.org/protocol/offline") != null) {
            return false;
        }
        StanzaType type = packet.getType();
        if (type == null || type == StanzaType.available) {
            String priority_str = packet.getElemCDataStaticStr(Presence.PRESENCE_PRIORITY_PATH);
            int priority = 0;
            if (priority_str != null) {
                try {
                    priority = Integer.decode(priority_str);
                }
                catch (NumberFormatException e) {
                    priority = 0;
                }
            }
            if (priority >= 0) {
                if (conn.getPresence() == null) {
                    conn.setPriority(priority);
                }
                conn.putSessionData(ID, ID);
                return true;
            }
        }
        return false;
    }

    protected void notifyNewOfflineMessage(Packet packet, XMPPResourceConnection conn, Queue<Packet> queue, Map<String, Object> settings) {
        if (this.notifiers != null) {
            this.notifiers.forEach(notifier -> notifier.notifyNewOfflineMessage(packet, conn, queue, settings));
        }
    }

    protected void notifyOfflineMessagesRetrieved(XMPPResourceConnection conn, Queue<Packet> queue) {
        if (this.notifiers != null) {
            this.notifiers.forEach(notifier -> notifier.notifyOfflineMessagesRetrieved(conn, queue));
        }
    }

    private class MsgRepositoryImpl
    implements OfflineMsgRepositoryIfc {
        private SimpleParser parser = SingletonFactory.getParserInstance();
        private NonAuthUserRepository repo = null;

        private MsgRepositoryImpl(NonAuthUserRepository repo, XMPPResourceConnection conn) {
            this.init(repo, conn);
        }

        @Override
        public void init(NonAuthUserRepository repo, XMPPResourceConnection conn) {
            this.repo = repo;
        }

        @Override
        @Deprecated
        public void initRepository(String conn_str, Map<String, String> map) {
        }

        @Override
        public Element getMessageExpired(long time, boolean delete) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
            try {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                String[] msgs = session.getOfflineDataList(OfflineMessages.ID, "messages");
                if (msgs != null && msgs.length > 0) {
                    session.removeOfflineData(OfflineMessages.ID, "messages");
                    StringBuilder sb = new StringBuilder();
                    for (String msg : msgs) {
                        sb.append(msg);
                    }
                    char[] data = sb.toString().toCharArray();
                    this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
                    return domHandler.getParsedElements();
                }
            }
            catch (NotAuthorizedException ex) {
                log.info("User not authrized to retrieve offline messages, this happens quite often on some installations where there are a very short living client connections. They can disconnect at any time. " + ex);
            }
            catch (TigaseDBException ex) {
                log.warning("Error accessing database for offline message: " + ex);
            }
            return null;
        }

        @Override
        public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
            this.repo.addOfflineDataList(to.getBareJID(), OfflineMessages.ID, "messages", new String[]{msg.toString()});
            return true;
        }
    }

    public static class StampComparator
    implements Comparator<Packet> {
        @Override
        public int compare(Packet p1, Packet p2) {
            String stamp2;
            boolean isStamp2New;
            Element stamp_el1 = p1.getElement().getChild("delay", "urn:xmpp:delay");
            Element stamp_el2 = p2.getElement().getChild("delay", "urn:xmpp:delay");
            boolean isStamp1New = stamp_el1 != null;
            boolean bl = isStamp2New = stamp_el2 != null;
            if (isStamp1New && isStamp2New) {
                String stamp1 = stamp_el1.getAttributeStaticStr("stamp");
                String stamp22 = stamp_el2.getAttributeStaticStr("stamp");
                return stamp1.compareTo(stamp22);
            }
            if (!isStamp1New) {
                stamp_el1 = p1.getElement().getChild("x", "jabber:x:delay");
            }
            if (!isStamp2New) {
                stamp_el2 = p2.getElement().getChild("x", "jabber:x:delay");
            }
            String stamp1 = stamp_el1 == null ? "" : stamp_el1.getAttributeStaticStr("stamp");
            String string = stamp2 = stamp_el2 == null ? "" : stamp_el2.getAttributeStaticStr("stamp");
            if (isStamp1New) {
                stamp1 = stamp1.replace("-", "");
            } else if (isStamp2New) {
                stamp2 = stamp2.replace("-", "");
            }
            return stamp1.compareTo(stamp2);
        }
    }

    @Bean(name="msg-offline-pubsub-publisher-notifier", parent=SessionManager.class, active=false, exportable=true)
    public static class PubSubPublisherNotifier
    implements Notifier {
        @ConfigField(desc="PubSub offline message publisher", alias="msg-pubsub-publisher")
        private String defaultPublisher;
        @ConfigField(desc="PubSub component JID", alias="msg-pubsub-jid")
        private String pubSubJID;
        @ConfigField(desc="PubSub node for offline messages", alias="msg-pubsub-node")
        private String pubSubNode;

        @Override
        public void notifyNewOfflineMessage(Packet packet, XMPPResourceConnection conn, Queue<Packet> queue, Map<String, Object> settings) {
            if (this.pubSubJID == null || this.pubSubNode == null) {
                return;
            }
            StanzaType type = packet.getType();
            if (packet.getElemName().equals("message") && (packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH) != null || packet.getElemChildrenStaticStr(MESSAGE_EVENT_PATH) != null || packet.getElemChildrenStaticStr(MESSAGE_HEADER_PATH) != null) && (type == null || type == StanzaType.normal || type == StanzaType.chat) || packet.getElemName().equals("presence") && (type == StanzaType.subscribe || type == StanzaType.subscribed || type == StanzaType.unsubscribe || type == StanzaType.unsubscribed)) {
                String tmpNode = packet.getElement().getAttributeStaticStr(PUBSUB_NODE_PATH, OfflineMessages.PUBSUB_NODE_KEY);
                if (tmpNode != null && tmpNode.equals(this.pubSubNode)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Publishing skipped to prevent loops: {0}", packet);
                    }
                    return;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Publishing packet in pubsub: {0}", packet);
                }
                try {
                    if (this.defaultPublisher != null) {
                        Element iq = new Element("iq", new String[]{"type", "id", "to", "from"}, new String[]{"set", "" + System.nanoTime(), this.pubSubJID, this.defaultPublisher});
                        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                        iq.addChild((XMLNodeIfc)pubsub);
                        Element publish = new Element("publish", new String[]{OfflineMessages.PUBSUB_NODE_KEY}, new String[]{this.pubSubNode});
                        pubsub.addChild((XMLNodeIfc)publish);
                        Element item = new Element("item");
                        publish.addChild((XMLNodeIfc)item);
                        item.addChild((XMLNodeIfc)packet.getElement());
                        Packet out = Packet.packetInstance(iq);
                        out.setXMLNS(OfflineMessages.XMLNS);
                        queue.add(out);
                    } else if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "Cannot publish message in PubSub, because cannot determine publisher. Please define default publisher JID.", packet);
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Problem during publish packet in pubsub", e);
                }
            }
        }
    }

    public static interface OfflineMsgRepositoryIfc
    extends tigase.db.OfflineMsgRepositoryIfc {
        public void init(NonAuthUserRepository var1, XMPPResourceConnection var2);
    }

    public static interface Notifier {
        public void notifyNewOfflineMessage(Packet var1, XMPPResourceConnection var2, Queue<Packet> var3, Map<String, Object> var4);

        default public void notifyOfflineMessagesRetrieved(XMPPResourceConnection session, Queue<Packet> results) {
        }
    }
}

