/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.annotation.StreamFeature;
import tigase.xmpp.impl.annotation.StreamFeatures;
import tigase.xmpp.jid.JID;

@Id(value="mobile_v3")
@Handles(value={@Handle(path={"iq", "mobile"}, xmlns="http://tigase.org/protocol/mobile#v3")})
@StreamFeatures(value={@StreamFeature(elem="mobile", xmlns="http://tigase.org/protocol/mobile#v3")})
@Bean(name="mobile_v3", parent=SessionManager.class, active=false)
public class MobileV3
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc {
    protected static final String ID = "mobile_v3";
    protected static final String MOBILE_EL_NAME = "mobile";
    protected static final String XMLNS = "http://tigase.org/protocol/mobile#v3";
    private static final int DEF_MAX_QUEUE_SIZE_VAL = 50;
    private static final Logger log = Logger.getLogger(MobileV3.class.getCanonicalName());
    private static final String MAX_QUEUE_SIZE_KEY = "max-queue-size";
    private static final String PRESENCE_QUEUE_KEY = "mobile_v3-presence-queue";
    private static final String PACKET_QUEUE_KEY = "mobile_v3-packet-queue";
    private static final String DELAY_ELEM_NAME = "delay";
    private static final String DELAY_XMLNS = "urn:xmpp:delay";
    private static final String MESSAGE_ELEM_NAME = "message";
    private static final ThreadLocal<StateHolder> threadState = new ThreadLocal();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    @ConfigField(desc="Max queue size", alias="max-queue-size")
    private int maxQueueSize = 50;

    public MobileV3() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected static boolean isQueueEnabled(XMPPResourceConnection session) {
        Boolean enabled = (Boolean)session.getSessionData(XMLNS);
        return enabled != null && enabled != false;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        try {
            StanzaType type = packet.getType();
            switch (type) {
                case set: {
                    boolean value;
                    Element el = packet.getElement().getChild(MOBILE_EL_NAME);
                    String valueStr = el.getAttributeStaticStr("enable");
                    boolean bl = value = valueStr != null && ("true".equals(valueStr) || "1".equals(valueStr));
                    if (session.getSessionData(PRESENCE_QUEUE_KEY) == null) {
                        session.putSessionData(PRESENCE_QUEUE_KEY, new ConcurrentHashMap());
                    }
                    if (session.getSessionData(PACKET_QUEUE_KEY) == null) {
                        session.putSessionData(PACKET_QUEUE_KEY, new ArrayDeque());
                    }
                    session.putSessionData(XMLNS, value);
                    results.offer(packet.okResult((Element)null, 0));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Mobile processing type is incorrect", false));
                    break;
                }
            }
        }
        catch (PacketErrorTypeException ex) {
            Logger.getLogger(MobileV3.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null) {
            return null;
        }
        if (!session.isAuthorized()) {
            return null;
        }
        return super.supStreamFeatures(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void filter(Packet _packet, XMPPResourceConnection sessionFromSM, NonAuthUserRepository repo, Queue<Packet> results) {
        Object packetQueue;
        Map presenceQueue;
        if (sessionFromSM == null || !sessionFromSM.isAuthorized() || results == null || results.size() == 0) {
            return;
        }
        StateHolder holder = threadState.get();
        if (holder == null) {
            holder = new StateHolder();
            threadState.set(holder);
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Packet res = (Packet)it.next();
            if (res == null || res.getPacketTo() == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("packet without destination");
                continue;
            }
            XMPPSession parentSession = sessionFromSM.getParentSession();
            if (parentSession == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "no session for destination {0} for packet {1} - missing parent session", new Object[]{res.getPacketTo().toString(), res.toString()});
                continue;
            }
            XMPPResourceConnection session = parentSession.getResourceForConnectionId(res.getPacketTo());
            if (session == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "no session for destination {0} for packet {1}", new Object[]{res.getPacketTo().toString(), res.toString()});
                continue;
            }
            presenceQueue = (Map)session.getSessionData(PRESENCE_QUEUE_KEY);
            packetQueue = (Queue)session.getSessionData(PACKET_QUEUE_KEY);
            if (!MobileV3.isQueueEnabled(session)) {
                if (presenceQueue == null && packetQueue == null || presenceQueue.isEmpty() && packetQueue.isEmpty()) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "mobile queues needs flushing - presences: {0}, packets: {1}", new Object[]{presenceQueue.size(), packetQueue.size()});
                }
                holder.setState(res.getPacketTo(), QueueState.need_flush);
                continue;
            }
            QueueState state = this.filter(session, res, holder.getState(res.getPacketTo()), presenceQueue, (Queue<Packet>)packetQueue);
            if (state == QueueState.queued) {
                it.remove();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "queue packet = {0}", res.toString());
                }
                if (presenceQueue.size() > this.maxQueueSize) {
                    state = QueueState.need_flush;
                } else if (packetQueue.size() > this.maxQueueSize) {
                    state = QueueState.need_packet_flush;
                }
            }
            state = holder.setState(res.getPacketTo(), state);
        }
        block14: for (Map.Entry<JID, QueueState> e : holder.states.entrySet()) {
            XMPPResourceConnection session = null;
            switch (e.getValue()) {
                case need_flush: {
                    XMPPSession parentSession;
                    try {
                        parentSession = sessionFromSM.getParentSession();
                        XMPPResourceConnection xMPPResourceConnection = session = parentSession == null ? null : parentSession.getResourceForConnectionId(e.getKey());
                        if (session != null) {
                            presenceQueue = (Map)session.getSessionData(PRESENCE_QUEUE_KEY);
                            packetQueue = presenceQueue;
                            synchronized (packetQueue) {
                                JID connId = session.getConnectionId();
                                for (Packet p : presenceQueue.values()) {
                                    p.setPacketTo(connId);
                                    holder.queue.offer(p);
                                }
                                presenceQueue.clear();
                            }
                        }
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.SEVERE, "this should not happen", ex);
                    }
                }
                case need_packet_flush: {
                    XMPPSession parentSession;
                    try {
                        Queue packetQueue2;
                        if (session == null) {
                            parentSession = sessionFromSM.getParentSession();
                            XMPPResourceConnection xMPPResourceConnection = session = parentSession == null ? null : parentSession.getResourceForConnectionId(e.getKey());
                        }
                        if (session == null) continue block14;
                        Queue queue = packetQueue2 = (Queue)session.getSessionData(PACKET_QUEUE_KEY);
                        synchronized (queue) {
                            JID connId = session.getConnectionId();
                            Packet p = null;
                            while ((p = (Packet)packetQueue2.poll()) != null) {
                                p.setPacketTo(connId);
                                holder.queue.offer(p);
                            }
                            packetQueue2.clear();
                        }
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.SEVERE, "this should not happen", ex);
                    }
                    continue block14;
                }
                case queued: {
                    break;
                }
            }
        }
        if (!holder.queue.isEmpty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "sending queued packets = {0}", holder.queue.size());
            }
            holder.queue.addAll(results);
            results.clear();
            results.addAll(holder.queue);
        }
        holder.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueState filter(XMPPResourceConnection session, Packet res, QueueState state, Map<JID, Packet> presenceQueue, Queue<Packet> packetQueue) {
        Element delay;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "checking if packet should be queued {0}", res.toString());
        }
        if (state == QueueState.need_flush) {
            return state;
        }
        if (res.getElemName() == MESSAGE_ELEM_NAME) {
            if (state.value() > QueueState.queued.value()) {
                return state;
            }
            List children = res.getElement().getChildren();
            if (children != null) {
                for (Element child : children) {
                    Element msg;
                    Element forward;
                    if (!"urn:xmpp:carbons:2".equals(child.getXMLNS())) continue;
                    Element delay2 = res.getElement().getChild(DELAY_ELEM_NAME, DELAY_XMLNS);
                    if (delay2 == null && (delay2 = this.createDelayElem(session)) != null && (forward = child.getChild("forward", "urn:xmpp:forward:0")) != null && (msg = forward.getChild(MESSAGE_ELEM_NAME)) != null) {
                        msg.addChild((XMLNodeIfc)delay2);
                    }
                    Queue<Packet> queue = packetQueue;
                    synchronized (queue) {
                        packetQueue.offer(res);
                    }
                    return QueueState.queued;
                }
            }
            return QueueState.need_packet_flush;
        }
        if (res.getElemName() != "presence") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "ignoring packet, packet is not presence:  {0}", res.toString());
            }
            return QueueState.need_packet_flush;
        }
        StanzaType type = res.getType();
        if (type != null && type != StanzaType.unavailable && type != StanzaType.available) {
            return QueueState.need_flush;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "queuing packet {0}", res.toString());
        }
        if ((delay = res.getElement().getChild(DELAY_ELEM_NAME, DELAY_XMLNS)) == null && (delay = this.createDelayElem(session)) != null) {
            res.getElement().addChild((XMLNodeIfc)delay);
        }
        Map<JID, Packet> map = presenceQueue;
        synchronized (map) {
            presenceQueue.put(res.getStanzaFrom(), res);
        }
        return QueueState.queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element createDelayElem(XMPPResourceConnection session) {
        String timestamp = null;
        SimpleDateFormat simpleDateFormat = this.formatter;
        synchronized (simpleDateFormat) {
            timestamp = this.formatter.format(new Date());
        }
        try {
            return new Element(DELAY_ELEM_NAME, new String[]{"xmlns", "from", "stamp"}, new String[]{DELAY_XMLNS, session.getBareJID().getDomain(), timestamp});
        }
        catch (NotAuthorizedException ex) {
            return null;
        }
    }

    private static class StateHolder {
        private final Queue<Packet> queue = new ArrayDeque<Packet>();
        private final Map<JID, QueueState> states = new HashMap<JID, QueueState>();

        private StateHolder() {
        }

        protected QueueState setState(JID jid, QueueState state) {
            QueueState oldState = this.getState(jid);
            if (oldState.value() < state.value()) {
                this.states.put(jid, state);
                return state;
            }
            return oldState;
        }

        protected QueueState getState(JID jid) {
            QueueState state = this.states.get(jid);
            if (state == null) {
                state = QueueState.none;
            }
            return state;
        }

        protected void reset() {
            this.states.clear();
            this.queue.clear();
        }
    }

    private static enum QueueState {
        none(0),
        queued(1),
        need_flush(3),
        need_packet_flush(2);

        private final int value;

        private QueueState(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

