/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.historyCache;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;

public class AllHistoryCache {
    private static final Logger log = Logger.getLogger(AllHistoryCache.class.getName());
    private StatisticsList[] buffer = null;
    private int count = 0;
    private int highMemoryLevel = 95;
    private int highMemoryUsageCount = 0;
    private int start = 0;

    public AllHistoryCache(int limit, int highMemoryLevel) {
        this.buffer = new StatisticsList[limit];
        this.highMemoryLevel = highMemoryLevel;
    }

    public synchronized void addItem(StatisticsList item) {
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = item;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
        if (this.isHighMemoryUsage()) {
            ++this.highMemoryUsageCount;
            int minimalSize = this.count / 2;
            if (minimalSize < 5) {
                minimalSize = 5;
            }
            if (this.count > minimalSize) {
                for (int i = 0; i < this.count - minimalSize; ++i) {
                    this.buffer[(this.start + i) % this.buffer.length] = null;
                }
                this.start = this.start + this.count - minimalSize;
                this.count = minimalSize;
            }
            log.log(Level.CONFIG, "Shrinking statistics to {0} items for {1} time", new Object[]{minimalSize, this.highMemoryUsageCount});
        } else {
            this.highMemoryUsageCount = 0;
        }
    }

    public synchronized StatisticsList[] getCurrentHistory() {
        StatisticsList[] result = new StatisticsList[this.count];
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            result[i] = this.buffer[ix];
        }
        return result;
    }

    protected boolean isHighMemoryUsage() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsage() > (float)this.highMemoryLevel;
    }
}

