/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import tigase.stats.JMXProxyListenerOpt;
import tigase.stats.StatisticsProviderMBean;
import tigase.util.repository.DataTypes;

public class JavaJMXProxyOpt
implements NotificationListener {
    private static final Logger log = Logger.getLogger(JavaJMXProxyOpt.class.getName());
    private int cpuNo = 0;
    private long delay = -1L;
    private Map<String, LinkedList<Object>> history = null;
    private String hostname = null;
    private String id = null;
    private boolean initialized = false;
    private long interval = -1L;
    private JMXServiceURL jmxUrl = null;
    private JMXConnector jmxc = null;
    private Date lastDisconnectTime = null;
    private List<JMXProxyListenerOpt> listeners = new LinkedList<JMXProxyListenerOpt>();
    private boolean loadHistory = false;
    private Set<String> metrics = new LinkedHashSet<String>();
    private String password = null;
    private int port = -1;
    private MBeanServerConnection server = null;
    private String sysDetails = "No data yet...";
    private StatisticsProviderMBean tigBean = null;
    private StatisticsUpdater updater = null;
    private String urlPath = null;
    private String userName = null;

    public JavaJMXProxyOpt(String id, String hostname, int port, String userName, String password, long delay, long interval, boolean loadHistory) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.delay = delay;
        this.interval = interval;
        this.urlPath = "/jndi/rmi://" + this.hostname + ":" + this.port + "/jmxrmi";
        this.loadHistory = loadHistory;
        System.out.println("Created: " + id + ":" + hostname + ":" + port);
    }

    public void addJMXProxyListener(JMXProxyListenerOpt listener) {
        this.listeners.add(listener);
        String[] dataIds = listener.getDataIds();
        if (dataIds != null && dataIds.length > 0) {
            for (String did : dataIds) {
                this.metrics.add(did);
            }
        }
    }

    public void connect() throws Exception {
        this.jmxUrl = new JMXServiceURL("rmi", "", 0, this.urlPath);
        String[] userCred = new String[]{this.userName, this.password};
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", userCred);
        this.jmxc = JMXConnectorFactory.newJMXConnector(this.jmxUrl, env);
        this.jmxc.addConnectionNotificationListener(this, null, null);
        this.jmxc.connect();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("jmx.remote.connection.opened")) {
            System.out.println("Connected: " + this.id + ":" + this.hostname + ":" + this.port);
            try {
                this.server = this.jmxc.getMBeanServerConnection();
                ObjectName obn = new ObjectName("tigase.stats:type=StatisticsProvider");
                this.tigBean = MBeanServerInvocationHandler.newProxyInstance(this.server, obn, StatisticsProviderMBean.class, false);
                if (this.history == null) {
                    if (this.loadHistory) {
                        String[] metrics_arr = this.metrics.toArray(new String[this.metrics.size()]);
                        this.history = this.tigBean.getStatsHistory(metrics_arr);
                        System.out.println(this.hostname + " loaded history, size: " + (Serializable)(this.history != null && this.history.get(metrics_arr[0]) != null ? Integer.valueOf(this.history.get(metrics_arr[0]).size()) : "null"));
                    } else {
                        System.out.println(this.hostname + " loading history switched off.");
                    }
                    if (this.history == null) {
                        this.history = new LinkedHashMap<String, LinkedList<Object>>();
                        for (String m : this.metrics) {
                            LinkedList list = new LinkedList();
                            this.history.put(m, list);
                        }
                    }
                } else {
                    System.out.println(this.hostname + " history already loaded, skipping.");
                }
                for (JMXProxyListenerOpt jMXProxyListener : this.listeners) {
                    jMXProxyListener.connected(this.id, this);
                }
                this.start();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error handling notification", e);
            }
            return;
        }
        if (notification.getType().equals("jmx.remote.connection.closed")) {
            this.server = null;
            this.tigBean = null;
            this.lastDisconnectTime = new Date();
            for (JMXProxyListenerOpt jMXProxyListener : this.listeners) {
                jMXProxyListener.disconnected(this.id);
            }
            return;
        }
        if (notification.getType().equals("jmx.remote.connection.failed")) {
            System.out.println("Reconnection to {hostName} failed...");
            return;
        }
        System.out.println("Unsupported JMX notification: {notification.getType()}");
    }

    public void start() {
        if (this.updater == null) {
            this.updater = new StatisticsUpdater();
            System.out.println("Started: " + this.id + ":" + this.hostname + ":" + this.port);
        }
    }

    public void update() {
        if (this.tigBean != null) {
            if (this.cpuNo == 0) {
                this.cpuNo = this.tigBean.getCPUsNumber();
            }
            Map<String, Object> curMetrics = this.tigBean.getCurStats(this.metrics.toArray(new String[this.metrics.size()]));
            if (null == this.history) {
                return;
            }
            for (Map.Entry<String, Object> e : curMetrics.entrySet()) {
                LinkedList<Object> list = this.history.get(e.getKey());
                if (list == null) continue;
                list.add(e.getValue());
                if (list.size() <= 1) continue;
                list.removeFirst();
            }
            this.sysDetails = this.tigBean.getSystemDetails();
            this.initialized = true;
        }
    }

    public Map<String, String> getAllStats(int level) {
        if (this.tigBean != null) {
            return this.tigBean.getAllStats(level);
        }
        return null;
    }

    public List<String> getComponentsNames() {
        if (this.tigBean != null) {
            return this.tigBean.getComponentsNames();
        }
        return null;
    }

    public Map<String, String> getComponentStats(String compName, int level) {
        if (this.tigBean != null) {
            return this.tigBean.getComponentStats(compName, level);
        }
        return null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getId() {
        return this.id;
    }

    public Object getMetricData(String key) {
        if (null == this.history) {
            return null;
        }
        LinkedList<Object> h = this.history.get(key);
        if (h != null && h.size() > 0) {
            return h.getLast();
        }
        return null;
    }

    public Object[] getMetricHistory(String key) {
        if (null == this.history) {
            return null;
        }
        List result = this.history.get(key);
        if (result != null) {
            switch (DataTypes.decodeTypeIdFromName(key)) {
                case 'I': {
                    return result.toArray(new Integer[result.size()]);
                }
                case 'L': {
                    return result.toArray(new Long[result.size()]);
                }
                case 'F': {
                    return result.toArray(new Float[result.size()]);
                }
                case 'D': {
                    return result.toArray(new Double[result.size()]);
                }
            }
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public String getSystemDetails() {
        return this.sysDetails;
    }

    public boolean isConnected() {
        return this.tigBean != null;
    }

    public boolean isInitialized() {
        return this.isConnected() && this.initialized;
    }

    private class StatisticsUpdater {
        private Timer updateTimer = new Timer("stats-updater", true);

        private StatisticsUpdater() {
            this.updateTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (JavaJMXProxyOpt.this.server == null) {
                            JavaJMXProxyOpt.this.connect();
                        }
                        if (JavaJMXProxyOpt.this.server != null) {
                            JavaJMXProxyOpt.this.update();
                        }
                    }
                    catch (IOException e) {
                        Throwable cause = e;
                        while (cause.getCause() != null) {
                            cause = cause.getCause();
                        }
                        Object disconnected = "";
                        if (JavaJMXProxyOpt.this.lastDisconnectTime != null) {
                            long disconnectedInterval = (System.currentTimeMillis() - JavaJMXProxyOpt.this.lastDisconnectTime.getTime()) / 60000L;
                            disconnected = ", disconnected: " + JavaJMXProxyOpt.this.lastDisconnectTime + ", " + disconnectedInterval + " minutes ago.";
                        }
                        log.log(Level.WARNING, "{0}, {1}, retrying in {2} seconds{3}", new Object[]{cause.getMessage(), JavaJMXProxyOpt.this.hostname, JavaJMXProxyOpt.this.interval / 1000L, disconnected});
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Problem retrieving statistics: ", e);
                    }
                }
            }, JavaJMXProxyOpt.this.delay, JavaJMXProxyOpt.this.interval);
        }
    }
}

