/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.net.ConnectionType;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SFilterIfc;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.xml.Element;

@Bean(name="streamFeatures", parent=S2SConnectionManager.class, active=true)
public class StreamFeatures
extends S2SAbstractProcessor
implements S2SFilterIfc {
    private static final Logger log = Logger.getLogger(StreamFeatures.class.getName());

    private static boolean hasEmptyOrOnlyObligatoryFeatures(Packet p) {
        return StreamFeatures.hasEmptyOrOnlyObligatoryFeatures(p.getElement());
    }

    private static boolean hasEmptyOrOnlyObligatoryFeatures(Element featuresElement) {
        return featuresElement.getChildren() == null || featuresElement.getChildren().isEmpty() || featuresElement.findChildren(item -> item.getChild("required") != null).isEmpty();
    }

    @Override
    public boolean filter(Packet p, S2SIOService serv, Queue<Packet> results) {
        boolean hasEmptyOrNonObligatoryFeatures = StreamFeatures.hasEmptyOrOnlyObligatoryFeatures(p);
        log.log(Level.FINEST, "Processing stream features and verifying if steam negotiation is complete; authenticated: {0}, completed: {1}, hasEmptyOrNonObligatoryFeatures: {2}, packet: {3} [{4}]", new Object[]{serv.isAuthenticated(), serv.isStreamNegotiationCompleted(), hasEmptyOrNonObligatoryFeatures, p, serv});
        if (p.isElement("features", "http://etherx.jabber.org/streams") && serv.isAuthenticated() && hasEmptyOrNonObligatoryFeatures) {
            this.stremNegotiationComplete(serv);
            return true;
        }
        return false;
    }

    @Override
    public int order() {
        return S2SAbstractProcessor.Order.StreamFeatures.ordinal();
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        return false;
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        if (attribs.containsKey("version") && serv.connectionType() == ConnectionType.accept) {
            List<Element> features = this.handler.getStreamFeatures(serv);
            Element featuresElement = new Element("stream:features");
            featuresElement.addChildren(features);
            if (attribs.containsKey("from") && this.skipTLSForHost(attribs.get("from"))) {
                Element startTls = featuresElement.getChild("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
                featuresElement.removeChild(startTls);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending stream features: {1} [{0}]", new Object[]{serv, featuresElement});
            }
            serv.addPacketToSend(Packet.packetInstance(featuresElement, null, null));
            boolean hasEmptyOrNonObligatoryFeatures = StreamFeatures.hasEmptyOrOnlyObligatoryFeatures(featuresElement);
            log.log(Level.FINEST, "Sending stream features and verifying if steam negotiation is complete; authenticated: {0}, completed: {1}, hasEmptyOrNonObligatoryFeatures: {2}, features: {3} [{4}]", new Object[]{serv.isAuthenticated(), serv.isStreamNegotiationCompleted(), hasEmptyOrNonObligatoryFeatures, featuresElement, serv});
            if (serv.isAuthenticated() && hasEmptyOrNonObligatoryFeatures) {
                this.stremNegotiationComplete(serv);
            }
        }
        return null;
    }

    private void stremNegotiationComplete(S2SIOService serv) {
        if (!serv.isStreamNegotiationCompleted()) {
            CID cid = (CID)serv.getSessionData().get("cid");
            if (cid != null) {
                CIDConnections cid_conns = null;
                try {
                    cid_conns = this.handler.getCIDConnections(cid, false);
                    if (cid_conns != null) {
                        cid_conns.streamNegotiationCompleted(serv);
                    }
                }
                catch (LocalhostException | NotLocalhostException xMPPException) {
                    // empty catch block
                }
            }
            serv.streamNegotiationCompleted();
        }
    }
}

