/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.TLSIOIfc;
import tigase.net.SocketThread;
import tigase.server.Packet;
import tigase.xmpp.XMPPIOService;

public class C2SIOService<RefObject>
extends XMPPIOService<RefObject> {
    private static final Logger log = Logger.getLogger(C2SIOService.class.getCanonicalName());
    private AtomicInteger waitForResponse = new AtomicInteger(0);
    private boolean pipelining = true;
    private Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();
    private byte[] tlsData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addReceivedPacket(Packet packet) {
        if (this.pipelining) {
            Queue<Runnable> queue = this.tasks;
            synchronized (queue) {
                if (this.isWaitingForResponse()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "queuing received packet as a task " + packet);
                    }
                    boolean result = this.tasks.offer(() -> {
                        this.waitForResponse.incrementAndGet();
                        super.addReceivedPacket(packet);
                    });
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "queued (" + result + ") received packet as a task " + packet);
                    }
                } else {
                    super.addReceivedPacket(packet);
                }
            }
        } else {
            super.addReceivedPacket(packet);
        }
    }

    @Override
    public boolean waitingToRead() {
        return this.tlsData == null && super.waitingToRead();
    }

    @Override
    public void processWaitingPackets() throws IOException {
        if (this.pipelining) {
            boolean hadPackets = !this.getWaitingPackets().isEmpty();
            super.processWaitingPackets();
            if (hadPackets && this.getWaitingPackets().isEmpty()) {
                this.runQueuedTaskIfExists();
            }
        } else {
            super.processWaitingPackets();
        }
    }

    public void waitForResponse() {
        this.waitForResponse.incrementAndGet();
    }

    public boolean isWaitingForResponse() {
        return !this.tasks.isEmpty() || this.waitForResponse.get() > 0;
    }

    public void queueTask(Runnable run) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "queuing task " + run);
        }
        this.moveParsedPacketsToReceived(false);
        this.tasks.offer(run);
    }

    public boolean shouldQueueStreamOpened() {
        boolean value = this.hasParsedElements();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "checking if should queue stream opened = " + value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleMalformedInput(ByteBuffer buffer, CharBuffer cb) {
        int i = 0;
        while (cb.position() + i >= 0 && cb.get(cb.position() + i) != '>') {
            --i;
        }
        if (cb.position() + i < 0) {
            cb.position(0);
        } else {
            cb.position(cb.position() + i + 1);
        }
        block11: for (i = 0; i < buffer.limit(); ++i) {
            byte b = buffer.get(i);
            switch (b) {
                case 22: {
                    if (i + 5 < buffer.limit() && buffer.get(i + 5) == 1) {
                        C2SIOService c2SIOService = this;
                        synchronized (c2SIOService) {
                            this.extractTlsHandshakeData(buffer, i);
                        }
                        return true;
                    }
                }
                case 1: {
                    if (i < 2 || (buffer.get(i - 2) & 0x80) != 128) continue block11;
                    C2SIOService c2SIOService = this;
                    synchronized (c2SIOService) {
                        this.extractTlsHandshakeData(buffer, i - 2);
                    }
                    return true;
                }
            }
        }
        log.log(Level.FINER, "Tried Not found SSL/TLS handshake, bb: {0}, contents: {1} , cb: {2}", new String[]{String.valueOf(buffer), Arrays.toString(buffer.array()), String.valueOf(cb.array())});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTLS(boolean clientMode, boolean wantClientAuth, boolean needClientAuth) throws IOException {
        super.startTLS(clientMode, wantClientAuth, needClientAuth);
        if (this.tlsData != null && this.getIO() instanceof TLSIOIfc) {
            C2SIOService c2SIOService = this;
            synchronized (c2SIOService) {
                ((TLSIOIfc)((Object)this.getIO())).processHandshake(this.tlsData);
                this.tlsData = null;
            }
        }
    }

    private void extractTlsHandshakeData(ByteBuffer buffer, int i) {
        buffer.position(i);
        this.tlsData = new byte[buffer.limit() - i];
        buffer.get(this.tlsData);
        if (this.getIO() instanceof TLSIOIfc) {
            try {
                ((TLSIOIfc)((Object)this.getIO())).processHandshake(this.tlsData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.tlsData = null;
        } else {
            SocketThread.removeSocketService(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueuedTaskIfExists() {
        Runnable run;
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            this.waitForResponse.decrementAndGet();
            run = this.tasks.poll();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "got task " + run + " to execute");
        }
        if (run != null) {
            run.run();
            run = this.tasks.peek();
        }
        if (run == null) {
            try {
                if (this.getUserJid() != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "finished stream initiation, disabling pipelining...");
                    }
                    this.pipelining = false;
                }
                if (this.serviceListener != null) {
                    this.serviceListener.packetsReady(this);
                }
            }
            catch (IOException ex) {
                this.forceStop();
            }
        }
    }
}

