/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.cond;

import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.amp.ConditionIfc;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class MatchResource
implements ConditionIfc {
    private static final String name = "match-resource";
    private static Logger log = Logger.getLogger(MatchResource.class.getName());

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean match(Packet packet, Element rule) {
        String value = rule.getAttributeStaticStr("value");
        boolean result = false;
        if (value != null) {
            try {
                MatchValue m_val = MatchValue.valueOf(value);
                String jid_resource = packet.getStanzaTo() != null ? packet.getStanzaTo().getResource() : null;
                String target_resource = packet.getAttributeStaticStr("to-res");
                String from_session_jid_string = packet.getAttributeStaticStr("from-session-jid");
                JID from_original_jid = from_session_jid_string != null ? JID.jidInstance((String)from_session_jid_string) : null;
                switch (m_val) {
                    case any: {
                        result = true;
                        break;
                    }
                    case other: {
                        result = jid_resource != null && target_resource != null && !jid_resource.equals(target_resource) || from_original_jid == null && target_resource == null;
                        break;
                    }
                    case exact: {
                        result = jid_resource != null && jid_resource.equals(target_resource);
                    }
                }
            }
            catch (Exception e) {
                log.info("Incorrect match-resource condition value for rule: " + rule);
            }
        } else {
            log.info("No value set for rule: " + rule);
        }
        return result;
    }

    private static enum MatchValue {
        any,
        exact,
        other;

    }
}

