/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.action;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepositoryImpl;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.Packet;
import tigase.server.amp.ActionAbstract;
import tigase.server.amp.AmpComponent;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="store", parent=AmpComponent.class, active=true)
public class Store
extends ActionAbstract
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(Store.class.getName());
    private static final String name = "store";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat formatter2;
    private Thread expiredProcessor = null;
    @Inject
    private NonAuthUserRepositoryImpl nonAuthUserRepo;
    @Inject
    private MsgRepositoryIfc repo = null;

    public Store() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Packet packet, Element rule) {
        if (this.repo != null) {
            String stamp;
            Date expired;
            block20: {
                expired = null;
                stamp = null;
                if (packet.getAttributeStaticStr("expired") == null) {
                    if (rule == null) {
                        rule = this.getExpireAtRule(packet);
                    }
                } else {
                    this.removeExpireAtRule(packet);
                    rule = null;
                }
                if (rule != null) {
                    try {
                        SimpleDateFormat simpleDateFormat;
                        String value = rule.getAttributeStaticStr("value");
                        if (value == null) break block20;
                        if (value.contains(".")) {
                            simpleDateFormat = this.formatter;
                            synchronized (simpleDateFormat) {
                                expired = this.formatter.parse(value);
                                break block20;
                            }
                        }
                        simpleDateFormat = this.formatter2;
                        synchronized (simpleDateFormat) {
                            expired = this.formatter2.parse(value);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.INFO, "Incorrect expire-at value: " + rule.getAttributeStaticStr("value"), e);
                        expired = null;
                    }
                }
            }
            SimpleDateFormat e = this.formatter;
            synchronized (e) {
                stamp = this.formatter.format(new Date());
            }
            this.removeTigasePayload(packet);
            try {
                Element elem = packet.getElement();
                if (elem.getChild("delay", "urn:xmpp:delay") == null) {
                    Element x = new Element("delay", "Offline Storage", new String[]{"from", "stamp", "xmlns"}, new String[]{packet.getStanzaTo().getDomain(), stamp, "urn:xmpp:delay"});
                    elem.addChild((XMLNodeIfc)x);
                }
                this.repo.storeMessage(packet.getStanzaFrom(), packet.getStanzaTo(), expired, elem, this.nonAuthUserRepo);
            }
            catch (UserNotFoundException ex) {
                log.info("User not found for offline message: " + packet);
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void initialize() {
        if (this.repo != null && this.expiredProcessor == null) {
            this.expiredProcessor = new Thread("expired-processor"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(90000L);
                        do {
                            Element elem;
                            if ((elem = Store.this.repo.getMessageExpired(0L, true)) == null) continue;
                            elem.addAttribute("offline", "1");
                            elem.addAttribute("expired", "1");
                            try {
                                Store.this.resultsHandler.addOutPacket(Packet.packetInstance(elem));
                            }
                            catch (TigaseStringprepException ex) {
                                log.info("Stringprep error for offline message loaded from DB: " + elem);
                            }
                        } while (!Thread.interrupted());
                        log.info("stopping expired-processor");
                        Store.this.expiredProcessor = null;
                        return;
                    }
                    catch (InterruptedException e) {
                        log.log(Level.WARNING, "Could not initialize expired processor", e);
                        return;
                    }
                }
            };
            this.expiredProcessor.setDaemon(true);
            this.expiredProcessor.start();
        }
    }

    @Override
    public void beforeUnregister() {
        if (this.expiredProcessor != null) {
            this.expiredProcessor.interrupt();
        }
    }

    private Element getExpireAtRule(Packet packet) {
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        List rules = amp.getChildren();
        Element rule = null;
        if (rules != null && rules.size() > 0) {
            for (Element r : rules) {
                String cond = r.getAttributeStaticStr("condition");
                if (cond == null || !cond.equals("expire-at")) continue;
                rule = r;
                break;
            }
        }
        return rule;
    }

    private void removeExpireAtRule(Packet packet) {
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        List rules = amp.getChildren();
        if (rules != null && rules.size() > 0) {
            for (Element r : rules) {
                String cond = r.getAttributeStaticStr("condition");
                if (cond == null || !cond.equals("expire-at")) continue;
                amp.removeChild(r);
                break;
            }
        }
        if ((rules = amp.getChildren()) == null || rules.size() == 0) {
            packet.getElement().removeChild(amp);
        }
    }
}

