/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.Objects;
import tigase.xmpp.jid.BareJID;

public class CmdAcl {
    public static final CmdAcl ADMIN = new CmdAcl(Type.ADMIN.name());
    private final BareJID jid;
    private final Type type;

    public CmdAcl(String value) {
        switch (value) {
            case "ALL": {
                this.type = Type.ALL;
                this.jid = null;
                break;
            }
            case "ADMIN": {
                this.type = Type.ADMIN;
                this.jid = null;
                break;
            }
            case "LOCAL": {
                this.type = Type.LOCAL;
                this.jid = null;
                break;
            }
            case "DOMAIN_OWNER": {
                this.type = Type.DOMAIN_OWNER;
                this.jid = null;
                break;
            }
            case "DOMAIN_ADMIN": {
                this.type = Type.DOMAIN_ADMIN;
                this.jid = null;
                break;
            }
            case "NONE": {
                this.type = Type.NONE;
                this.jid = null;
                break;
            }
            default: {
                this.jid = BareJID.bareJIDInstanceNS((String)value);
                this.type = this.jid == null ? Type.NONE : (this.jid.getLocalpart() == null ? Type.DOMAIN : Type.JID);
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isJIDAllowed(BareJID jid) {
        return this.jid.equals((Object)jid);
    }

    public boolean isDomainAllowed(String domain) {
        return domain.equals(domain);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CmdAcl) {
            CmdAcl o = (CmdAcl)obj;
            return this.type == o.type && (this.jid == null || this.jid.equals((Object)this.jid));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.jid});
    }

    public String toString() {
        switch (this.type) {
            case ALL: 
            case ADMIN: 
            case DOMAIN_OWNER: 
            case DOMAIN_ADMIN: 
            case LOCAL: {
                return this.type.name();
            }
        }
        return this.jid.toString();
    }

    public static enum Type {
        ALL,
        ADMIN,
        LOCAL,
        DOMAIN,
        DOMAIN_ADMIN,
        DOMAIN_OWNER,
        JID,
        NONE;

    }
}

