/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.impl.Serializer;
import tigase.kernel.BeanUtils;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.TypesConverter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;

public class EventBusSerializer
implements Serializer {
    private static final Logger log = Logger.getLogger(EventBusSerializer.class.getName());
    private TypesConverter typesConverter = new DefaultTypesConverter();

    @Override
    public <T> T deserialize(Element element) {
        try {
            Field[] fields;
            Class<?> cls = Class.forName(element.getName());
            Object result = cls.newInstance();
            for (Field f : fields = BeanUtils.getAllFields(cls)) {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                try {
                    Element v = element.getChild(f.getName());
                    if (v == null) continue;
                    Object value = Element.class.isAssignableFrom(f.getType()) ? (v.getChildren().size() > 0 ? v.getChildren().get(0) : null) : this.typesConverter.convert(XMLUtils.unescape((String)v.getCData()), f.getType(), f.getGenericType());
                    BeanUtils.setValue(result, f, value);
                }
                catch (IllegalAccessException | InvocationTargetException caught) {
                    log.log(Level.WARNING, "Error while deserializing", caught);
                }
            }
            return (T)result;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.log(Level.WARNING, "Error while deserializing", e);
            return null;
        }
    }

    @Override
    public Element serialize(Object object) {
        Field[] fields;
        Class<?> cls = object.getClass();
        Element e = new Element(cls.getName());
        for (Field f : fields = BeanUtils.getAllFields(cls)) {
            if (Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
            try {
                Object value = BeanUtils.getValue(object, f);
                if (value == null) continue;
                Element v = new Element(f.getName());
                if (Element.class.isAssignableFrom(f.getType())) {
                    v.addChild((XMLNodeIfc)((Element)value));
                } else {
                    String x = this.typesConverter.toString(value);
                    v.setCData(XMLUtils.escape((String)x));
                }
                e.addChild((XMLNodeIfc)v);
            }
            catch (IllegalAccessException | InvocationTargetException caught) {
                log.log(Level.WARNING, "Error while serializing", e);
            }
        }
        return e;
    }
}

