/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component.stores;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import tigase.eventbus.component.EventBusComponent;
import tigase.eventbus.component.stores.Subscription;
import tigase.eventbus.impl.EventName;
import tigase.eventbus.impl.EventsNameMap;
import tigase.kernel.beans.Bean;

@Bean(name="subscriptionStore", parent=EventBusComponent.class, active=true)
public class SubscriptionStore {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final EventsNameMap<Subscription> subscribers = new EventsNameMap();

    public void addSubscription(String eventPackage, String eventName, Subscription subscription) {
        this.subscribers.put(eventPackage, eventName, subscription);
    }

    public Collection<Subscription> getAllData() {
        return this.subscribers.getAllData();
    }

    public Set<EventName> getSubscribedEvents() {
        return this.subscribers.getAllListenedEvents();
    }

    public Collection<Subscription> getSubscribersJIDs(String eventPackage, String eventName) {
        HashSet<Subscription> handlers = new HashSet<Subscription>();
        handlers.addAll(this.subscribers.get(eventPackage, eventName));
        handlers.addAll(this.subscribers.get(eventPackage, null));
        return handlers;
    }

    public boolean hasSubscriber(String eventPackage, String eventName) {
        return this.subscribers.hasData(eventPackage, eventName);
    }

    public void remove(Subscription jid) {
        this.subscribers.delete(jid);
    }

    public void removeSubscription(String eventPackage, String eventName, Subscription jidInstanceNS) {
        this.subscribers.delete(eventPackage, eventName, jidInstanceNS);
    }
}

