/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.derby;

import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import tigase.util.Algorithms;

public class MsgBroadcastRepositoryStoredProcedures {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessage(String msgId, Timestamp expired, String msg) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        ResultSet rs = null;
        try {
            PreparedStatement stmt = conn.prepareStatement("select id from tig_broadcast_messages where id = ?");
            stmt.setString(1, msgId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                return;
            }
            rs.close();
            stmt = conn.prepareStatement("insert into tig_broadcast_messages (id, expired, msg) values (?,?,?)");
            stmt.setString(1, msgId);
            stmt.setTimestamp(2, expired);
            stmt.setString(3, msg);
            stmt.executeUpdate();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            conn.close();
        }
    }

    public static void addMessageRecipient(String msgId, String jid) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        ResultSet rs = null;
        try {
            String jidSha1 = Algorithms.hexDigest((String)jid.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("select jid_id from tig_broadcast_jids where jid_sha1 = ?");
            stmt.setString(1, jidSha1);
            rs = stmt.executeQuery();
            long jidId = -1L;
            if (rs.next()) {
                jidId = rs.getLong(1);
            }
            rs.close();
            if (jidId < 0L) {
                stmt = conn.prepareStatement("insert into tig_broadcast_jids (jid, jid_sha1) values (?,?)");
                stmt.setString(1, jid);
                stmt.setString(2, jidSha1);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    jidId = rs.getLong(1);
                }
                rs.close();
            }
            stmt = conn.prepareStatement("select 1 from tig_broadcast_recipients where \tmsg_id = ? and jid_id = ?");
            stmt.setString(1, msgId);
            stmt.setLong(2, jidId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                return;
            }
            rs.close();
            stmt = conn.prepareStatement("insert into tig_broadcast_recipients (msg_id, jid_id) values (?,?)");
            stmt.setString(1, msgId);
            stmt.setLong(2, jidId);
            stmt.executeUpdate();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMessageRecipients(String msgId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select j.jid from tig_broadcast_recipients r inner join tig_broadcast_jids j on j.jid_id = r.jid_id where r.msg_id = ?");
            stmt.setString(1, msgId);
            data[0] = stmt.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMessages(Timestamp expired, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select id, expired, msg from tig_broadcast_messages where expired >= ?");
            stmt.setTimestamp(1, expired);
            data[0] = stmt.executeQuery();
        }
    }
}

