/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.auth.credentials.entries.ScramCredentialsEntry;
import tigase.kernel.beans.Bean;

public class ScramSha256CredentialsEntry
extends ScramCredentialsEntry {
    private static final String ALGORITHM = "SHA-256";

    public ScramSha256CredentialsEntry(PlainCredentialsEntry entry) throws NoSuchAlgorithmException, InvalidKeyException {
        super(ALGORITHM, entry);
    }

    public ScramSha256CredentialsEntry(byte[] salt, int iterations, byte[] saltedPassword) {
        super(ALGORITHM, salt, iterations, saltedPassword);
    }

    @Bean(name="SCRAM-SHA-256", parent=CredentialsEncoderBean.class, active=true)
    public static class Encoder
    extends ScramCredentialsEntry.Encoder {
        public Encoder() {
            super(ScramSha256CredentialsEntry.ALGORITHM);
        }
    }

    @Bean(name="SCRAM-SHA-256", parent=CredentialsDecoderBean.class, active=true)
    public static class Decoder
    extends ScramCredentialsEntry.Decoder {
        public Decoder() {
            super(ScramSha256CredentialsEntry.ALGORITHM);
        }

        @Override
        protected Credentials.Entry newInstance(byte[] salt, int iterations, byte[] saltedPassword) {
            return new ScramSha256CredentialsEntry(salt, iterations, saltedPassword);
        }
    }
}

