/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.mam;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="mamQueryParser", parent=PubSubComponent.class, active=true)
public class MAMQueryParser
extends tigase.xmpp.mam.MAMQueryParser<Query> {
    private static final String MAM2_XMLNS = "urn:xmpp:mam:2";
    protected static final Set<String> XMLNSs = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("urn:xmpp:mam:1", "urn:xmpp:mam:2")));
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject
    private PubSubLogic pubSubLogic;
    @Inject
    private IPubSubConfig pubSubConfig;

    public Set<String> getXMLNSs() {
        return XMLNSs;
    }

    public Query parseQuery(Query query, Packet packet) throws ComponentException {
        String node = this.parseQueryForNode(query, packet);
        this.validateNode(packet.getStanzaTo().getBareJID(), node);
        query.setPubsubNode(node);
        super.parseQuery((tigase.xmpp.mam.Query)query, packet);
        return query;
    }

    protected String parseQueryForNode(Query query, Packet packet) throws ComponentException {
        return packet.getAttributeStaticStr(Iq.IQ_QUERY_PATH, "node");
    }

    protected void validateNode(BareJID serviceJID, String node) throws PubSubException {
        if (node == null) {
            throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
        }
        try {
            if (!this.pubSubLogic.isMAMEnabled(serviceJID, node)) {
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

