/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="readAllNodesCommand", parent=PubSubComponent.class, active=true)
public class ReadAllNodesCommand
implements AdHocCommand {
    public static final Logger log = Logger.getLogger(ReadAllNodesCommand.class.getName());
    @Inject
    private IPubSubConfig config;
    @Inject
    private IPubSubDAO<?, ?, ?> dao;
    @Inject
    private IPubSubRepository repository;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("form", "Reading all nodes", "To read all nodes from DB press finish");
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    this.startReading(request.getIq().getStanzaTo().getBareJID());
                    Form f = new Form("result", "Info", "Nodes tree has been readed");
                    response.getElements().add(f.getElement());
                }
                response.completeSession();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing read all nodes packet", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "Read ALL nodes";
    }

    public String getNode() {
        return "read-all-nodes";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.config.getAdmins()).contains(jid.toString());
    }

    private void startReading(BareJID serviceJid) throws RepositoryException {
        String[] allNodesId;
        for (String n : allNodesId = this.dao.getAllNodesList(serviceJid)) {
            this.repository.getNodeConfig(serviceJid, n);
        }
    }
}

