/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="unsubscribeNodeModule", parent=PubSubComponent.class, active=true)
public class UnsubscribeNodeModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_UNSUBSCRIBE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"unsubscribe"));

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT_UNSUBSCRIBE;
    }

    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element unsubscribe = pubSub.getChild("unsubscribe");
        JID senderJid = packet.getStanzaFrom();
        String nodeName = unsubscribe.getAttributeStaticStr("node");
        BareJID jid = BareJID.bareJIDInstanceNS((String)unsubscribe.getAttributeStaticStr("jid"));
        String subid = unsubscribe.getAttributeStaticStr("subid");
        try {
            String s;
            if (!senderJid.getBareJID().equals((Object)jid)) {
                this.pubSubLogic.checkPermission(toJid, nodeName, senderJid, PubSubLogic.Action.manageNode);
            }
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            if (subid != null && !subid.equals(s = nodeSubscriptions.getSubscriptionId(jid))) {
                throw new PubSubException(element, Authorization.NOT_ACCEPTABLE, PubSubErrorCondition.INVALID_SUBID);
            }
            Subscription subscription = nodeSubscriptions.getSubscription(jid);
            if (subscription == null) {
                throw new PubSubException(Authorization.UNEXPECTED_REQUEST, PubSubErrorCondition.NOT_SUBSCRIBED);
            }
            nodeSubscriptions.changeSubscription(jid, Subscription.none);
            this.getRepository().update(toJid, nodeName, nodeSubscriptions);
            this.packetWriter.write(packet.okResult((Element)null, 0));
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing unsubscribe node packet", e);
            throw new RuntimeException(e);
        }
    }
}

