/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Map;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;

@Bean(name="retrieveAffiliationsModule", parent=PubSubComponent.class, active=true)
public class RetrieveAffiliationsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"affiliations"));

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-affiliations", "http://jabber.org/protocol/pubsub#publisher-affiliation", "http://jabber.org/protocol/pubsub#outcast-affiliation", "http://jabber.org/protocol/pubsub#member-affiliation"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws PubSubException {
        try {
            BareJID serviceJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element affiliations = pubsub.getChild("affiliations");
            BareJID senderBareJid = packet.getStanzaFrom().getBareJID();
            Element pubsubResult = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Packet result = packet.okResult(pubsubResult, 0);
            Element affiliationsResult = new Element("affiliations");
            pubsubResult.addChild((XMLNodeIfc)affiliationsResult);
            Map<String, UsersAffiliation> userAffiliations = this.getRepository().getUserAffiliations(serviceJid, senderBareJid);
            for (Map.Entry<String, UsersAffiliation> entry : userAffiliations.entrySet()) {
                Affiliation affiliation = entry.getValue().getAffiliation();
                Element a = new Element("affiliation", new String[]{"node", "affiliation"}, new String[]{entry.getKey(), affiliation.name()});
                affiliationsResult.addChild((XMLNodeIfc)a);
            }
            this.packetWriter.write(result);
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing retrieve affiliation packet", e);
            throw new RuntimeException(e);
        }
    }
}

