/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.db.util.SchemaManager;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.form.Field;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.NotificationBroadcaster;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.PubSubLogic;
import tigase.pubsub.utils.executors.Executor;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="publishItemModule", parent=PubSubComponent.class, active=true)
public class PublishItemModule
extends AbstractPubSubModule
implements Initializable,
UnregisterAware {
    public static final String AMP_XMLNS = "http://jabber.org/protocol/amp";
    public static final String[] SUPPORTED_PEP_XMLNS = new String[]{"http://jabber.org/protocol/mood", "http://jabber.org/protocol/geoloc", "http://jabber.org/protocol/activity", "http://jabber.org/protocol/tune"};
    private static final String[] FIELD_VALUE_PATH = new String[]{"field", "value"};
    private static final Criteria CRIT_PUBLISH = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"publish"));
    protected final LeafNodeConfig defaultPepNodeConfig;
    private final TimestampHelper dtf = new TimestampHelper();
    protected final Set<String> pepNodes = new HashSet<String>();
    @Inject
    private EventBus eventBus;
    private long idCounter = 0L;
    @Inject
    private NotificationBroadcaster notificationBroadcaster;
    @Inject
    private PresenceCollectorModule presenceCollector;
    @Inject(nullAllowed=false)
    private IPubSubRepository repository;
    @Inject(bean="publishExecutor")
    private Executor publishExecutor;

    private static Collection<String> extractCDataItems(Element event, String[] path) {
        ArrayList<String> result = new ArrayList<String>();
        List z = event.getChildren(path);
        if (z != null) {
            for (Element element : z) {
                if (!element.getName().equals("item")) continue;
                result.add(element.getCData());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(".");
    }

    public PublishItemModule() {
        for (String xmlns : SUPPORTED_PEP_XMLNS) {
            this.pepNodes.add(xmlns);
        }
        this.defaultPepNodeConfig = new LeafNodeConfig("default-pep");
        this.defaultPepNodeConfig.setValue("pubsub#access_model", AccessModel.presence.name());
        this.defaultPepNodeConfig.setValue("pubsub#presence_based_delivery", true);
        this.defaultPepNodeConfig.setValue("pubsub#send_last_published_item", "on_sub_and_presence");
    }

    public void doPublishItems(BareJID serviceJID, String nodeName, LeafNodeConfig leafNodeConfig, String publisher, List<Element> itemsToSend) throws RepositoryException, PubSubException {
        String uuid = null;
        if (leafNodeConfig.isPersistItem()) {
            if (this.pubSubLogic.isMAMEnabled(serviceJID, nodeName)) {
                uuid = UUID.randomUUID().toString().toLowerCase();
            }
            IItems nodeItems = this.getRepository().getNodeItems(serviceJID, nodeName);
            for (Element item : itemsToSend) {
                String id = item.getAttributeStaticStr("id");
                if (!this.config.isPepRemoveEmptyGeoloc()) {
                    nodeItems.writeItem(id, publisher, item, uuid);
                    continue;
                }
                Element geoloc = item.findChildStaticStr(new String[]{"item", "geoloc"});
                if (geoloc != null && (geoloc.getChildren() == null || geoloc.getChildren().size() == 0)) {
                    nodeItems.deleteItem(id);
                    continue;
                }
                try {
                    nodeItems.writeItem(id, publisher, item, uuid);
                }
                catch (RepositoryException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Could not store the item", ex);
                    }
                    throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "It was not possible to store the item", (Exception)((Object)ex));
                }
            }
            if (leafNodeConfig.getMaxItems() != null) {
                this.trimItems(serviceJID, nodeName, leafNodeConfig.getMaxItems(), leafNodeConfig.getCollectionItemsOrdering());
            }
        }
        this.eventBus.fire((Object)new ItemPublishedEvent(this.config.getComponentName(), serviceJID, nodeName, publisher, uuid, itemsToSend));
        this.generateItemsNotifications(serviceJID, nodeName, itemsToSend, uuid, true);
    }

    public void generateItemsNotifications(BareJID serviceJID, String nodeName, List<Element> itemsToSend, String uuid, boolean persistInMAM) throws RepositoryException {
        Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
        items.addChildren(itemsToSend);
        this.generateNotifications(serviceJID, nodeName, items, itemsToSend.isEmpty() ? null : itemsToSend.get(0).getAttributeStaticStr("id"), itemsToSend.isEmpty() ? null : itemsToSend.get(0).getAttributeStaticStr("expire-at"), uuid, persistInMAM);
    }

    public void generateNodeNotifications(BareJID serviceJID, String nodeName, Element payload, String uuid, boolean persistInMAM) throws RepositoryException {
        this.generateNotifications(serviceJID, nodeName, payload, null, null, uuid, persistInMAM);
    }

    private void generateNotifications(BareJID serviceJID, String nodeName, Element payload, String itemId, String expireAt, String uuid, boolean persistInMAM) throws RepositoryException {
        for (SchemaManager.Pair<String, StanzaType> pair : this.getCollectionsForNotification(serviceJID, nodeName)) {
            HashMap<String, String> headers = null;
            if (pair.getKey() != null) {
                headers = new HashMap<String, String>();
                headers.put("Collection", (String)pair.getKey());
            }
            Element message = this.pubSubLogic.prepareNotificationMessage(JID.jidInstance((BareJID)serviceJID), uuid == null ? String.valueOf(++this.counter) : uuid, uuid, nodeName, payload, expireAt, headers, (StanzaType)pair.getValue());
            if (uuid != null && persistInMAM) {
                this.getRepository().addMAMItem(serviceJID, pair.getKey() == null ? nodeName : (String)pair.getKey(), uuid, message, itemId);
            }
            this.eventBus.fire((Object)new BroadcastNotificationEvent(this.config.getComponentName(), serviceJID, nodeName, message));
            this.broadcastNotification(Executor.Priority.normal, serviceJID, nodeName, message);
        }
    }

    public void sendNotification(BareJID serviceJID, String nodeName, Element item, String uuid, Map<String, String> headers, JID recipient, StanzaType stanzaType) {
        Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
        items.addChild((XMLNodeIfc)item);
        Element message = this.pubSubLogic.prepareNotificationMessage(JID.jidInstance((BareJID)serviceJID), uuid == null ? String.valueOf(++this.counter) : uuid, uuid, nodeName, items, null, headers, stanzaType);
        this.packetWriter.write(Packet.packetInstance((Element)message, (JID)JID.jidInstance((BareJID)serviceJID), (JID)recipient));
    }

    public void broadcastNotification(Executor.Priority priority, BareJID serviceJID, String nodeName, Element message) throws RepositoryException {
        this.notificationBroadcaster.broadcastNotification(priority, serviceJID, nodeName, message);
    }

    public AbstractNodeConfig ensurePepNode(BareJID toJid, String nodeName, BareJID ownerJid, Element publishOptions) throws PubSubException {
        AbstractNodeConfig nodeConfig;
        try {
            IPubSubRepository repo = this.getRepository();
            nodeConfig = repo.getNodeConfig(toJid, nodeName);
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Error occured during autocreation of node", (Exception)((Object)ex));
        }
        if (nodeConfig != null) {
            return nodeConfig;
        }
        return this.createPepNode(toJid, nodeName, ownerJid, publishOptions);
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#publish", "http://jabber.org/protocol/pubsub#publish-options", "http://jabber.org/protocol/pubsub#multi-items", "http://jabber.org/protocol/pubsub#item-ids", "http://jabber.org/protocol/pubsub#persistent-items"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_PUBLISH;
    }

    private List<SchemaManager.Pair<String, StanzaType>> getCollectionsForNotification(BareJID serviceJid, String nodeName) throws RepositoryException {
        ArrayList<SchemaManager.Pair<String, StanzaType>> result = new ArrayList<SchemaManager.Pair<String, StanzaType>>();
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJid, nodeName);
        String cn = nodeConfig.getCollection();
        result.add(new SchemaManager.Pair(null, (Object)nodeConfig.getNotificationType()));
        while (cn != null && !"".equals(cn)) {
            AbstractNodeConfig nc = this.getRepository().getNodeConfig(serviceJid, cn);
            result.add((SchemaManager.Pair<String, StanzaType>)new SchemaManager.Pair((Object)cn, (Object)nc.getNotificationType()));
            cn = nc.getCollection();
        }
        return result;
    }

    public void initialize() {
        if (this.eventBus != null) {
            this.eventBus.registerAll((Object)this);
        } else {
            log.warning("EventBus is not injected!");
        }
    }

    public boolean isPEPNodeName(String nodeName) {
        if (this.config.isPepPeristent()) {
            return false;
        }
        return this.pepNodes.contains(nodeName);
    }

    public void process(Packet packet) throws PubSubException {
        if (this.publishExecutor.isOverloaded()) {
            throw new PubSubException(Authorization.RESOURCE_CONSTRAINT);
        }
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element publish = pubSub.getChild("publish");
        Element publishOptions = Optional.ofNullable(pubSub.getChild("publish-options")).map(el -> el.getChild("x", "jabber:x:data")).orElse(null);
        String nodeName = publish.getAttributeStaticStr("node");
        try {
            if (this.isPEPNodeName(nodeName)) {
                this.pepProcess(packet, pubSub, publish);
                return;
            }
            this.pubSubLogic.checkPermission(toJid, nodeName, packet.getStanzaFrom(), PubSubLogic.Action.publishItems);
            List<Element> itemsToSend = this.makeItemsToSend(publish);
            List<String> itemIds = this.publishItems(toJid, nodeName, packet.getStanzaFrom(), itemsToSend, publishOptions);
            Packet resultIq = packet.okResult((Element)null, 0);
            if (itemIds != null) {
                Element resPubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                resultIq.getElement().addChild((XMLNodeIfc)resPubsub);
                Element resPublish = new Element("publish", new String[]{"node"}, new String[]{nodeName});
                resPubsub.addChild((XMLNodeIfc)resPublish);
                itemIds.stream().map(id -> new Element("item", new String[]{"id"}, new String[]{id})).forEach(arg_0 -> ((Element)resPublish).addChild(arg_0));
            }
            this.packetWriter.write(resultIq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (RepositoryException e1) {
            log.log(Level.FINE, "Error processing publish packet", e1);
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Error processing publish packet", (Exception)((Object)e1));
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing publish packet", e);
            throw new RuntimeException(e);
        }
    }

    public List<String> publishItems(BareJID toJid, String nodeName, JID publisher, List<Element> itemsToPublish, Element publishOptions) throws RepositoryException, PubSubException {
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
        if (nodeConfig == null) {
            if (!this.pubSubLogic.isServiceJidPEP(toJid) || !this.config.isPepPeristent()) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            nodeConfig = this.createPepNode(toJid, nodeName, publisher.getBareJID(), publishOptions);
        } else if (nodeConfig.getNodeType() == NodeType.collection) {
            throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "publish"));
        }
        if (publishOptions != null && publishOptions.findChild(el -> el.getName() == "field" && "FORM_TYPE" == el.getAttributeStaticStr("var") && "http://jabber.org/protocol/pubsub#publish-option".equals(el.getCData(FIELD_VALUE_PATH))) == null) {
            block4: for (Element field : publishOptions.getChildren()) {
                String key = field.getAttributeStaticStr("var");
                if ("FORM_TYPE".equals(key)) continue;
                Field f = nodeConfig.getForm().get(key);
                if (f == null) {
                    throw new PubSubException(Authorization.CONFLICT, PubSubErrorCondition.PRECONDITION_NOT_MET);
                }
                switch (f.getType()) {
                    case bool: {
                        String v1 = field.getCData(FIELD_VALUE_PATH);
                        if (("true".equals(v1) || "1".equals(v1)) == ("true".equals(f.getValue()) || "1".equals(f.getValue()))) continue block4;
                        throw new PubSubException(Authorization.CONFLICT, PubSubErrorCondition.PRECONDITION_NOT_MET);
                    }
                    case jid_multi: 
                    case text_multi: {
                        List reqValues = Optional.ofNullable(field.mapChildren(el -> el.getName() == "value", el -> el.getCData())).orElse(Collections.EMPTY_LIST);
                        String[] values = f.getValues();
                        if (values == null) {
                            if (reqValues.isEmpty()) continue block4;
                            throw new PubSubException(Authorization.CONFLICT, PubSubErrorCondition.PRECONDITION_NOT_MET);
                        }
                        if (reqValues.size() != values.length) {
                            throw new PubSubException(Authorization.CONFLICT, PubSubErrorCondition.PRECONDITION_NOT_MET);
                        }
                        for (String v2 : values) {
                            if (reqValues.contains(v2)) continue;
                            throw new PubSubException(Authorization.CONFLICT, PubSubErrorCondition.PRECONDITION_NOT_MET);
                        }
                        continue block4;
                    }
                    default: {
                        String reqValue = field.getCData(FIELD_VALUE_PATH);
                        String value = f.getValue();
                        if (reqValue == null && value == null || reqValue != null && reqValue.equals(value)) continue block4;
                        throw new PubSubException(Authorization.CONFLICT, PubSubErrorCondition.PRECONDITION_NOT_MET);
                    }
                }
            }
        }
        LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
        if (this.pubSubLogic.isMAMEnabled(toJid, nodeName) && itemsToPublish.size() > 1) {
            throw new PubSubException(Authorization.NOT_ALLOWED, "Bulk publication not allowed");
        }
        ArrayList<String> itemIds = null;
        if (leafNodeConfig.isPersistItem()) {
            itemIds = new ArrayList<String>();
            for (Element item : itemsToPublish) {
                String id = this.pubSubLogic.validateItemId(toJid, nodeName, item.getAttributeStaticStr("id"));
                if (!id.equals(item.getAttributeStaticStr("id"))) {
                    item.setAttribute("id", id);
                }
                itemIds.add(id);
            }
        }
        this.doPublishItems(toJid, nodeName, leafNodeConfig, publisher.toString(), itemsToPublish);
        return itemIds;
    }

    public void publishLastItem(BareJID serviceJid, AbstractNodeConfig nodeConfig, JID destinationJID) throws RepositoryException {
        String[] ids;
        try {
            this.pubSubLogic.checkPermission(serviceJid, nodeConfig.getNodeName(), destinationJID, PubSubLogic.Action.retrieveItems);
        }
        catch (Exception ex) {
            return;
        }
        IItems nodeItems = this.getRepository().getNodeItems(serviceJid, nodeConfig.getNodeName());
        if (nodeItems != null && (ids = nodeItems.getItemsIds(nodeConfig.getCollectionItemsOrdering())) != null && ids.length > 0) {
            String lastID = ids[ids.length - 1];
            IItems.IItem item = nodeItems.getItem(lastID);
            if (item != null && item.getItem() != null) {
                this.sendNotification(serviceJid, nodeConfig.getNodeName(), item.getItem(), item.getUUID(), null, destinationJID, nodeConfig.getNotificationType());
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "There is no payload for item with id '" + lastID + "' at '" + nodeConfig.getNodeName() + "' for '" + serviceJid + "'");
            }
        }
    }

    public void trimItems(BareJID serviceJid, String nodeName, Integer maxItems, CollectionItemsOrdering collectionItemsOrdering) throws RepositoryException {
        IItems nodeItems = this.getRepository().getNodeItems(serviceJid, nodeName);
        String[] ids = nodeItems.getItemsIds(collectionItemsOrdering);
        if (ids == null || ids.length <= maxItems) {
            return;
        }
        for (int i = 0; i < ids.length - maxItems; ++i) {
            String id = ids[i];
            nodeItems.deleteItem(id);
        }
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    protected JID[] getValidBuddies(BareJID id) throws RepositoryException {
        ArrayList<JID> result = new ArrayList<JID>();
        Map<BareJID, RosterElement> rosterJids = this.getRepository().getUserRoster(id);
        if (rosterJids != null) {
            for (Map.Entry<BareJID, RosterElement> e : rosterJids.entrySet()) {
                RosterAbstract.SubscriptionType sub = e.getValue().getSubscription();
                if (sub != RosterAbstract.SubscriptionType.both && sub != RosterAbstract.SubscriptionType.from && sub != RosterAbstract.SubscriptionType.from_pending_out) continue;
                result.add(JID.jidInstance((BareJID)e.getKey()));
            }
        }
        return result.toArray(new JID[0]);
    }

    @HandleEvent
    protected void onCapsChange(PresenceCollectorModule.CapsChangeEvent event) throws TigaseStringprepException {
        if (!event.componentName.equals(this.config.getComponentName())) {
            return;
        }
        Set<String> newFeatures = event.newFeatures;
        if (newFeatures == null || newFeatures.isEmpty() || !this.config.isSendLastPublishedItemOnPresence()) {
            return;
        }
        for (String feature : newFeatures) {
            if (!feature.endsWith("+notify")) continue;
            String nodeName = feature.substring(0, feature.length() - "+notify".length());
            try {
                ISubscriptions subscriptions = this.getRepository().getNodeSubscriptions(event.serviceJid, nodeName);
                if (subscriptions != null && subscriptions.getSubscription(event.buddyJid.getBareJID()) == Subscription.subscribed) continue;
                this.publishLastItem(event.serviceJid, nodeName, event.buddyJid);
            }
            catch (RepositoryException ex) {
                log.log(Level.WARNING, "Exception while sending last published item on on_sub_and_presence for service jid " + event.serviceJid + " and node " + nodeName);
            }
        }
    }

    protected void publishLastItem(BareJID serviceJid, String nodeName, JID buddyJid) throws RepositoryException {
        AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(serviceJid, nodeName);
        if (nodeConfig != null && nodeConfig.getSendLastPublishedItem() == SendLastPublishedItem.on_sub_and_presence) {
            String[] childNodes;
            if (nodeConfig instanceof LeafNodeConfig) {
                this.publishLastItem(serviceJid, nodeConfig, buddyJid);
            } else if (nodeConfig instanceof CollectionNodeConfig && (childNodes = this.repository.getChildNodes(serviceJid, nodeConfig.getNodeName())) != null) {
                for (String childNode : childNodes) {
                    try {
                        this.publishLastItem(serviceJid, childNode, buddyJid);
                    }
                    catch (RepositoryException ex) {
                        log.log(Level.WARNING, "Exception while sending last published item on on_sub_and_presence for service jid " + serviceJid + " and node " + childNode);
                    }
                }
            }
        }
    }

    @HandleEvent
    protected void onPresenceChangeEvent(PresenceCollectorModule.PresenceChangeEvent event) throws TigaseStringprepException {
        if (!event.componentName.equals(this.config.getComponentName())) {
            return;
        }
        Packet packet = event.packet;
        if (packet.getStanzaTo() == null) {
            return;
        }
        if (!this.config.isSendLastPublishedItemOnPresence()) {
            return;
        }
        if (packet.getType() == null || packet.getType() == StanzaType.available) {
            BareJID serviceJid = packet.getStanzaTo().getBareJID();
            JID userJid = packet.getStanzaFrom();
            try {
                Map<String, UsersSubscription> subscrs = this.repository.getUserSubscriptions(serviceJid, userJid.getBareJID());
                log.log(Level.FINEST, "Sending last published items for subscribed nodes: {0}", subscrs);
                for (Map.Entry<String, UsersSubscription> e : subscrs.entrySet()) {
                    String nodeName;
                    AbstractNodeConfig nodeConfig;
                    if (e.getValue().getSubscription() != Subscription.subscribed || (nodeConfig = this.repository.getNodeConfig(serviceJid, nodeName = e.getKey())).getSendLastPublishedItem() != SendLastPublishedItem.on_sub_and_presence) continue;
                    this.publishLastItem(serviceJid, nodeConfig, userJid);
                }
            }
            catch (RepositoryException ex) {
                Logger.getLogger(PublishItemModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private AbstractNodeConfig createPepNode(BareJID toJid, String nodeName, BareJID ownerJid, Element publishOptions) throws PubSubException {
        AbstractNodeConfig nodeConfig;
        if (!toJid.equals((Object)ownerJid)) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        try {
            IPubSubRepository repo = this.getRepository();
            nodeConfig = new LeafNodeConfig(nodeName, this.defaultPepNodeConfig);
            if (publishOptions != null) {
                for (Element field : publishOptions.getChildren()) {
                    String key = field.getAttributeStaticStr("var");
                    if ("http://jabber.org/protocol/pubsub#publish-option".equals(key)) continue;
                    List values = field.mapChildren(el -> el.getName() == "value", el -> el.getCData());
                    Field f = nodeConfig.getForm().get(key);
                    if (f == null) {
                        throw new PubSubException(Authorization.BAD_REQUEST, "Invalid option " + key);
                    }
                    f.setValues(values == null ? null : values.toArray(new String[values.size()]));
                }
            }
            repo.createNode(toJid, nodeName, ownerJid, nodeConfig, NodeType.leaf, "");
            nodeConfig = repo.getNodeConfig(toJid, nodeName);
            IAffiliations nodeaAffiliations = repo.getNodeAffiliations(toJid, nodeName);
            nodeaAffiliations.addAffiliation(ownerJid, Affiliation.owner);
            ISubscriptions nodeaSubscriptions = repo.getNodeSubscriptions(toJid, nodeName);
            if (this.config.isAutoSubscribeNodeCreator()) {
                nodeaSubscriptions.addSubscriberJid(toJid, Subscription.subscribed);
            }
            repo.update(toJid, nodeName, nodeaAffiliations);
            repo.addToRootCollection(toJid, nodeName);
            log.log(Level.FINEST, "Created new PEP node: {0}, conf: {1}, aff: {2}, subs: {3} ", new Object[]{nodeName, nodeConfig, nodeaAffiliations, nodeaSubscriptions});
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Error occured during autocreation of node", (Exception)((Object)ex));
        }
        return nodeConfig;
    }

    private List<Element> makeItemsToSend(Element publish) throws PubSubException {
        ArrayList<Element> items = new ArrayList<Element>();
        for (Element si : publish.getChildren()) {
            if (!"item".equals(si.getName())) continue;
            String expireAttr = si.getAttributeStaticStr("expire-at");
            if (expireAttr != null) {
                try {
                    Date parseDateTime = this.dtf.parseTimestamp(expireAttr);
                    if (null != parseDateTime) {
                        si.setAttribute("expire-at", this.dtf.format(parseDateTime));
                    } else {
                        si.removeAttribute("expire-at");
                    }
                }
                catch (ParseException e) {
                    throw new PubSubException(Authorization.BAD_REQUEST, "Invalid value for attribute expire-at");
                }
            }
            items.add(si);
        }
        return items;
    }

    private void pepProcess(Packet packet, Element pubSub, Element publish) throws RepositoryException {
        JID senderJid = packet.getStanzaFrom();
        JID[] subscribers = this.getValidBuddies(senderJid.getBareJID());
        Element item = publish.getChild("item");
        String nodeName = publish.getAttributeStaticStr("node");
        Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
        items.addChild((XMLNodeIfc)item);
        Element message = this.pubSubLogic.prepareNotificationMessage(senderJid.copyWithoutResource(), String.valueOf(++this.counter), null, nodeName, items, null, null, StanzaType.headline);
        for (JID jid : subscribers) {
            Element clone = message.clone();
            this.packetWriter.write(Packet.packetInstance((Element)clone, (JID)senderJid, (JID)jid));
        }
        this.packetWriter.write(packet.okResult((Element)null, 0));
        this.packetWriter.write(Packet.packetInstance((Element)message, (JID)senderJid, (JID)senderJid));
    }

    public static class BroadcastNotificationEvent {
        public final String componentName;
        public final BareJID serviceJid;
        public final String node;
        public final Element notificationMessage;

        public BroadcastNotificationEvent(String componentName, BareJID serviceJid, String node, Element notificationMessage) {
            this.componentName = componentName;
            this.serviceJid = serviceJid;
            this.node = node;
            this.notificationMessage = notificationMessage;
        }
    }

    public static class ItemPublishedEvent {
        public final String componentName;
        public final List<Element> itemsToSend;
        public final String uuid;
        public final String node;
        public final String publisher;
        public final BareJID serviceJid;

        public ItemPublishedEvent(String componentName, BareJID serviceJid, String node, String publisher, String uuid, List<Element> itemsToSend) {
            this.componentName = componentName;
            this.serviceJid = serviceJid;
            this.node = node;
            this.publisher = publisher;
            this.itemsToSend = itemsToSend;
            this.uuid = uuid;
        }
    }

    private static class Item {
        final String id;
        final Date updateDate;

        Item(String id, Date date) {
            this.updateDate = date;
            this.id = id;
        }
    }
}

