/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Bean(name="disco", parent=PubSubComponent.class, active=true)
public class DiscoveryModule
extends tigase.component.modules.impl.DiscoveryModule {
    public static final String PUBSUB_FEATURE_METADATA = "http://jabber.org/protocol/pubsub#meta-data";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final String[] features;
    @Inject
    private IPubSubConfig config;
    @Inject
    private IPubSubRepository repository;
    @Inject(nullAllowed=true)
    private Predicate<Packet> packetFilter;
    private static final String[] EMPTY_NODES = new String[0];

    public DiscoveryModule() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.features = (String[])Stream.concat(Arrays.stream(super.getFeatures()), Stream.of(PUBSUB_FEATURE_METADATA)).toArray(String[]::new);
    }

    public String[] getFeatures() {
        return this.features;
    }

    public boolean canHandle(Packet packet) {
        if (this.packetFilter != null && !this.packetFilter.test(packet)) {
            return false;
        }
        Criteria criteria = this.getModuleCriteria();
        return criteria != null && criteria.match(packet.getElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node == null) {
            super.processDiscoInfo(packet, jid, node, senderJID);
        } else {
            boolean allowed;
            AbstractNodeConfig nodeConfigClone;
            JID senderJid = packet.getStanzaFrom();
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            INodeMeta nodeMeta = this.repository.getNodeMeta(packet.getStanzaTo().getBareJID(), node);
            if (nodeMeta == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            try {
                nodeConfigClone = nodeMeta.getNodeConfig().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RepositoryException("Exception retrieving node configuration", (Throwable)ex);
            }
            boolean bl = allowed = senderJid == null || nodeConfigClone == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfigClone.getDomains());
            if (!allowed) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", nodeConfigClone.getNodeType().name()}));
            switch (nodeConfigClone.getNodeType()) {
                case leaf: {
                    resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"hierarchy", "leaf"}));
                    break;
                }
                case collection: {
                    resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"hierarchy", "branch"}));
                    break;
                }
            }
            resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
            Form form = nodeConfigClone.getForm();
            form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)PUBSUB_FEATURE_METADATA));
            ArrayList<String> owners = new ArrayList<String>();
            ArrayList<String> publishers = new ArrayList<String>();
            IAffiliations affiliations = this.repository.getNodeAffiliations(packet.getStanzaTo().getBareJID(), node);
            block13: for (UsersAffiliation affiliation : affiliations.getAffiliations()) {
                if (affiliation.getAffiliation() == null) continue;
                switch (affiliation.getAffiliation()) {
                    case owner: {
                        owners.add(affiliation.getJid().toString());
                        continue block13;
                    }
                    case publisher: {
                        publishers.add(affiliation.getJid().toString());
                        continue block13;
                    }
                }
            }
            form.addField(Field.fieldJidMulti((String)"pubsub#owner", (String[])owners.toArray(new String[owners.size()]), (String)"Node owners"));
            form.addField(Field.fieldJidMulti((String)"pubsub#publisher", (String[])publishers.toArray(new String[publishers.size()]), (String)"Publishers to this node"));
            BareJID creator = nodeMeta.getCreator();
            String creationDateStr = "";
            if (nodeMeta.getCreationTime() != null) {
                SimpleDateFormat simpleDateFormat = this.formatter;
                synchronized (simpleDateFormat) {
                    creationDateStr = this.formatter.format(nodeMeta.getCreationTime());
                }
            }
            form.addField(Field.fieldJidSingle((String)"pubsub#creator", (String)(creator != null ? creator.toString() : ""), (String)"Node creator"));
            form.addField(Field.fieldTextSingle((String)"pubsub#creation_date", (String)creationDateStr, (String)"Creation date"));
            form.addField(Field.fieldTextSingle((String)"pubsub#num_subscribers", (String)String.valueOf(this.repository.getNodeSubscriptions(packet.getStanzaTo().getBareJID(), node).size()), (String)"Number of subscribers to this node"));
            resultQuery.addChild((XMLNodeIfc)form.getElement());
            this.write(resultIq);
        }
    }

    protected List<Element> prepareDiscoItems(JID toJid, String nodeName, JID senderJid, RSM rsm) throws ComponentException, RepositoryException {
        boolean allowed;
        AbstractNodeConfig nodeConfig;
        this.log.finest("Asking about Items of node " + nodeName);
        AbstractNodeConfig abstractNodeConfig = nodeConfig = nodeName == null ? null : this.repository.getNodeConfig(toJid.getBareJID(), nodeName);
        if (nodeName != null && nodeConfig == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (nodeName == null || nodeConfig != null && nodeConfig.getNodeType() == NodeType.collection) {
            String[] nodes;
            if (nodeName == null) {
                try {
                    nodes = this.repository.getRootCollection(toJid.getBareJID());
                }
                catch (CachedPubSubRepository.RootCollectionSet.IllegalStateException e) {
                    throw new PubSubException(Authorization.RESOURCE_CONSTRAINT);
                }
            } else {
                nodes = this.repository.getChildNodes(toJid.getBareJID(), nodeName);
            }
            if (nodes != null) {
                int count = nodes.length;
                int index = 0;
                boolean inverted = false;
                if (nodes.length > 0 && rsm != null) {
                    String[] originalNodes = nodes;
                    if ((nodes = this.prefilterNodesWithRSM(nodes, rsm)).length > 0 && originalNodes.length > nodes.length) {
                        for (int i = 0; i < originalNodes.length; ++i) {
                            if (!originalNodes[i].equals(nodes[0])) continue;
                            index = i;
                            break;
                        }
                    }
                    if (inverted = rsm.hasBefore()) {
                        List<String> tmp = Arrays.asList(nodes);
                        Collections.reverse(tmp);
                        nodes = tmp.toArray(new String[tmp.size()]);
                    }
                }
                ArrayList<Element> results = new ArrayList<Element>();
                for (String node : nodes) {
                    boolean allowed2;
                    AbstractNodeConfig childNodeConfig = this.repository.getNodeConfig(toJid.getBareJID(), node);
                    if (childNodeConfig == null) continue;
                    boolean bl = allowed2 = senderJid == null || childNodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), childNodeConfig.getDomains());
                    if (allowed2) {
                        String name = childNodeConfig.getTitle();
                        name = name == null || name.length() == 0 ? node : name;
                        Element item = new Element("item", new String[]{"jid", "node", "name"}, new String[]{toJid.toString(), node, name});
                        results.add(item);
                        if (rsm == null || results.size() < rsm.getMax()) continue;
                        break;
                    }
                    this.log.fine("User " + senderJid + " not allowed to see node '" + node + "'");
                }
                if (inverted) {
                    index = nodes.length - results.size();
                    Collections.reverse(results);
                }
                if (rsm != null && !results.isEmpty()) {
                    rsm.setResults(Integer.valueOf(count), ((Element)results.get(0)).getAttributeStaticStr("node"), ((Element)results.get(results.size() - 1)).getAttributeStaticStr("node"));
                    rsm.setIndex(Integer.valueOf(index));
                }
                return results;
            }
            return Collections.emptyList();
        }
        boolean bl = allowed = senderJid == null || nodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains());
        if (!allowed) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        IItems items = this.repository.getNodeItems(toJid.getBareJID(), nodeName);
        String[] itemsId = items.getItemsIds(nodeConfig.getCollectionItemsOrdering());
        if (itemsId != null) {
            ArrayList<Element> results = new ArrayList<Element>();
            for (String itemId : itemsId) {
                results.add(new Element("item", new String[]{"jid", "name"}, new String[]{toJid.toString(), itemId}));
            }
            return results;
        }
        return Collections.emptyList();
    }

    protected String[] prefilterNodesWithRSM(String[] nodes, RSM rsm) throws PubSubException {
        Integer start = null;
        if (rsm.getAfter() != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].equals(rsm.getAfter())) continue;
                start = i + 1;
                break;
            }
            if (start == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
        } else if (rsm.getIndex() != null) {
            start = rsm.getIndex();
        }
        Integer stop = null;
        if (rsm.getBefore() != null) {
            for (int i = nodes.length - 1; i >= 0; --i) {
                if (!nodes[i].equals(rsm.getBefore())) continue;
                stop = i;
                break;
            }
            if (stop == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
        }
        if (start == null) {
            start = 0;
        }
        if (stop == null) {
            stop = nodes.length;
        }
        if (start <= stop) {
            return Arrays.copyOfRange(nodes, (int)start, (int)stop);
        }
        return EMPTY_NODES;
    }

    protected Packet prepareDiscoInfoResponse(Packet packet, JID jid, String node, JID senderJID) {
        Element query;
        Packet result = super.prepareDiscoInfoResponse(packet, jid, node, senderJID);
        if (node == null && jid.getLocalpart() != null && this.config.isPepPeristent() && (query = result.getElement().getChild("query", "http://jabber.org/protocol/disco#info")) != null) {
            Stream.of("http://jabber.org/protocol/pubsub#auto-create", "http://jabber.org/protocol/pubsub#auto-subscribe").map(feature -> new Element("feature", new String[]{"var"}, new String[]{feature})).forEach(arg_0 -> ((Element)query).addChild(arg_0));
        }
        return result;
    }

    protected IPubSubRepository getRepository() {
        return this.repository;
    }
}

