/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.component.modules.Module;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Inject;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.stats.StatisticHolderImpl;
import tigase.xml.Element;

public abstract class AbstractPubSubModule
extends StatisticHolderImpl
implements Module {
    protected static final Logger log = Logger.getLogger(AbstractPubSubModule.class.getName());
    @Inject
    protected IPubSubConfig config;
    @Inject
    protected PubSubLogic pubSubLogic;
    @Inject
    protected PacketWriter packetWriter;
    @Inject(nullAllowed=false)
    private IPubSubRepository repository;
    @Inject(nullAllowed=true)
    private Predicate<Packet> packetFilter;

    public static List<Element> makeArray(Element ... elements) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (Element element : elements) {
            result.add(element);
        }
        return result;
    }

    public static List<Packet> makeArray(Packet ... packets) {
        LinkedList<Packet> result = new LinkedList<Packet>();
        for (Packet packet : packets) {
            result.add(packet);
        }
        return result;
    }

    public AbstractPubSubModule() {
        this.setStatisticsPrefix(((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean canHandle(Packet packet) {
        if (this.packetFilter != null && !this.packetFilter.test(packet)) {
            return false;
        }
        Criteria criteria = this.getModuleCriteria();
        return criteria != null && criteria.match(packet.getElement());
    }

    protected IPubSubRepository getRepository() {
        return this.repository;
    }
}

