/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.repositories.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StoredProcedures {
    public static void tigPushGetNodeSettingsByDevice(String provider, String deviceId, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select pd.service_jid, pd.user_jid, pd.node, pd.provider, pd.device_id, pd.device_second_id from tig_push_devices pd where pd.provider = ? and pd.device_id = ?");
            preparedStatement.setString(1, provider);
            preparedStatement.setString(2, deviceId);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void tigPushGetNodeSettingsByNode(String serviceJid, String node, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select pd.user_jid, pd.provider, pd.device_id, pd.device_second_id from tig_push_devices pd where pd.service_jid = ? and pd.node = ?");
            preparedStatement.setString(1, serviceJid);
            preparedStatement.setString(2, node);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void tigPushRegisterDevice(String serviceJid, String userJid, String node, String provider, String deviceId, String deviceSecondId) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select 1 from tig_push_devices where service_jid = ? and node = ?");
            preparedStatement.setString(1, serviceJid);
            preparedStatement.setString(2, node);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.close();
            boolean bl = resultSet.next();
            if (bl) {
                PreparedStatement preparedStatement2 = connection.prepareStatement("update tig_push_devices set device_second_id = ? where service_jid = ? and node = ? and user_jid = ?");
                preparedStatement2.setString(1, deviceSecondId);
                preparedStatement2.setString(2, serviceJid);
                preparedStatement2.setString(3, node);
                preparedStatement2.setString(4, userJid);
                preparedStatement2.executeUpdate();
            } else {
                PreparedStatement preparedStatement3 = connection.prepareStatement("insert into tig_push_devices (service_jid, user_jid, node, provider, device_id, device_second_id) values (?, ?, ?, ?, ?, ?)", 1);
                preparedStatement3.setString(1, serviceJid);
                preparedStatement3.setString(2, userJid);
                preparedStatement3.setString(3, node);
                preparedStatement3.setString(4, provider);
                preparedStatement3.setString(5, deviceId);
                preparedStatement3.executeUpdate();
            }
        }
    }

    public static void tigPushUnregisterDevice(String serviceJid, String userJid, String node, String provider, String deviceId) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("delete from tig_push_devices where service_jid = ? and user_jid = ? and node = ? and provider = ? and device_id = ?");
            preparedStatement.setString(1, serviceJid);
            preparedStatement.setString(2, userJid);
            preparedStatement.setString(3, node);
            preparedStatement.setString(4, provider);
            preparedStatement.setString(5, deviceId);
            preparedStatement.executeUpdate();
        }
    }

    public static void tigPushStats(ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select 'all', provider, count(1) from tig_push_devices group by provider union all select 'accounts', provider, count(distinct user_jid) from tig_push_devices group by provider, user_jid");
            data[0] = preparedStatement.executeQuery();
        }
    }
}

