/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.util.UUID;
import tigase.push.apns.ApnsPayload;

public class ApnsNotification {
    private final String a;
    private final String b;
    private final PushType c;
    private final ApnsPayload d;
    private final String e;
    private final String f;

    private ApnsNotification(Builder builder) {
        this.d = builder.a;
        this.c = builder.b;
        this.b = builder.c;
        this.e = builder.d;
        this.f = builder.e;
        if (this.b == null) {
            throw new IllegalArgumentException("DeviceID is required!");
        }
        if (this.c == null) {
            throw new IllegalArgumentException("Push Type can not be null!");
        }
        if (this.d == null) {
            throw new IllegalArgumentException("Payload is required!");
        }
        this.a = UUID.randomUUID().toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDeviceId() {
        return this.b;
    }

    public String getId() {
        return this.a;
    }

    public PushType getPushType() {
        return this.c;
    }

    public int getPriority() {
        return this.c == PushType.background ? 5 : 10;
    }

    public ApnsPayload getPayload() {
        return this.d;
    }

    public String getCollapseId() {
        return this.e;
    }

    public String getTopic() {
        return this.f;
    }

    public String toString() {
        return "[id: " + this.getId() + ", deviceId: " + this.getDeviceId() + ", type: " + this.getPushType().name() + ", collapseId: " + this.getCollapseId() + ", payload: " + this.getPayload().toPayloadString() + " ]";
    }

    public static enum PushType {
        alert,
        background,
        voip;

    }

    public static class Builder {
        private ApnsPayload a;
        private PushType b;
        private String c;
        private String d;
        private String e;

        private Builder() {
        }

        public Builder collapseId(String collapseId) {
            this.d = collapseId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.c = deviceId;
            return this;
        }

        public Builder pushType(PushType pushType) {
            this.b = pushType;
            return this;
        }

        public Builder payload(ApnsPayload payload) {
            this.a = payload;
            return this;
        }

        public Builder topic(String topic) {
            this.e = topic;
            return this;
        }

        public ApnsNotification build() {
            return new ApnsNotification(this);
        }
    }
}

