/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.push.monitor.SSLCertificateExpirationAware;
import tigase.util.Base64;

public class APNSUtil {
    public static KeyStore loadCertificate(InputStream is, String certPass) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(is, certPass.toCharArray());
            return keyStore;
        }
        catch (Exception exception) {
            throw new IOException("Could not load key store", exception);
        }
    }

    public static PrivateKey loadPrivateKey(String data) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String string2 = Arrays.stream(data.replace("\r\n", "\n").split("\n")).filter(string -> !string.startsWith("-----")).collect(Collectors.joining());
        return APNSUtil.loadPrivateKey(Base64.decode((String)string2));
    }

    public static PrivateKey loadPrivateKey(byte[] data) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(data);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public static InputStream inputStreamFromBase64(String base64) {
        byte[] byArray = Base64.decode((String)base64);
        return new ByteArrayInputStream(byArray);
    }

    public static Stream<SSLCertificateExpirationAware.Result> getCertificateValidPeriodFromBase64(String base64Certificate, String password) throws IOException {
        KeyStore keyStore = APNSUtil.loadCertificate(APNSUtil.inputStreamFromBase64(base64Certificate), password);
        return APNSUtil.getCertificateValidPeriod(keyStore);
    }

    public static Stream<SSLCertificateExpirationAware.Result> getCertificateValidPeriodFromFile(String path, String password) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(path);){
            KeyStore keyStore = APNSUtil.loadCertificate(fileInputStream, password);
            Stream<SSLCertificateExpirationAware.Result> stream = APNSUtil.getCertificateValidPeriod(keyStore);
            return stream;
        }
    }

    public static Stream<SSLCertificateExpirationAware.Result> getCertificateValidPeriod(KeyStore keyStore) throws IOException {
        try {
            ArrayList<SSLCertificateExpirationAware.Result> arrayList = new ArrayList<SSLCertificateExpirationAware.Result>();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Certificate certificate = keyStore.getCertificate(string);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)certificate;
                arrayList.add(new SSLCertificateExpirationAware.Result(x509Certificate.getSubjectDN().toString(), x509Certificate.getNotBefore().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), x509Certificate.getNotAfter().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()));
            }
            return arrayList.stream();
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException("Could not validate key store", keyStoreException);
        }
    }
}

